/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.help;

import com.qarks.util.ui.help.HelpNode;
import com.qarks.util.ui.help.HelpParser;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import nanoxml.XMLElement;

public class XmlHelpParser
implements HelpParser {
    private UrlHelpNode rootNode;
    private Hashtable<UrlHelpNode, ArrayList<UrlHelpNode>> table = new Hashtable();

    public XmlHelpParser(XMLElement xMLElement, URL uRL) {
        this.rootNode = new UrlHelpNode(uRL, "root", true);
        this.build(this.rootNode, xMLElement);
    }

    private void build(UrlHelpNode urlHelpNode, XMLElement xMLElement) {
        XMLElement[] xMLElementArray = xMLElement.getChildren().toArray(new XMLElement[0]);
        ArrayList<UrlHelpNode> arrayList = new ArrayList<UrlHelpNode>();
        this.table.put(urlHelpNode, arrayList);
        for (XMLElement xMLElement2 : xMLElementArray) {
            String string = xMLElement2.getProperty("url");
            String string2 = xMLElement2.getProperty("name");
            String string3 = xMLElement2.getProperty("isFolder");
            try {
                string = urlHelpNode.getPageUrl().toString() + "/" + string;
                string = string.replaceAll(" ", "%20");
                URL uRL = new URL(string);
                boolean bl = "true".equalsIgnoreCase(string3);
                UrlHelpNode urlHelpNode2 = new UrlHelpNode(uRL, string2, bl);
                arrayList.add(urlHelpNode2);
                this.build(urlHelpNode2, xMLElement2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public HelpNode[] getChildren(HelpNode helpNode) {
        ArrayList<UrlHelpNode> arrayList;
        HelpNode[] helpNodeArray = new HelpNode[]{};
        if (helpNode == null) {
            helpNode = this.rootNode;
        }
        if ((arrayList = this.table.get(helpNode)) != null) {
            helpNodeArray = arrayList.toArray(helpNodeArray);
        }
        return helpNodeArray;
    }

    private class UrlHelpNode
    extends HelpNode {
        private URL url;

        public UrlHelpNode(URL uRL, String string, boolean bl) {
            super(string, bl);
            this.url = uRL;
        }

        @Override
        public void setPageUrl(URL uRL) {
            this.url = uRL;
        }

        @Override
        public URL getPageUrl() {
            return this.url;
        }
    }
}

