/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.cutoffMethods;

import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.cutoffMethods.CutoffMethod;
import dmLab.utils.GeneralUtils;
import java.util.Arrays;

public final class CriticalAngleCutoff
extends CutoffMethod {
    /*
     * WARNING - void declaration
     */
    public CriticalAngleCutoff(MCFSParams mcfsParams) {
        super((MCFSParams)var1_1);
        void var1_1;
        this.name = "criticalAngle";
    }

    @Override
    public final double getCutoff(Importance[] importance) {
        Object object;
        double[] dArray = Importance.toValues((Importance[])object);
        object = this;
        double d = 0.0;
        double d2 = ((CutoffMethod)object).mcfsParams.cutoffAngle;
        Arrays.sort(dArray);
        object = new double[dArray.length];
        double d3 = dArray[0];
        double d4 = dArray[dArray.length - 1] - d3;
        double d5 = 1.0 / (double)dArray.length;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = (dArray[n] - d3) / d4;
            int n2 = n++;
            object[n2] = (double)n2 * d5;
        }
        double d6 = CriticalAngleCutoff.linearRegressionAngle((double[])object, dArray, dArray.length - 2);
        for (int i = dArray.length - 3; i > 0; --i) {
            double d7;
            double d8 = CriticalAngleCutoff.linearRegressionAngle((double[])object, dArray, i);
            if (Math.abs(d7 - d6) < d2) {
                d = dArray[i] * d4 + d3;
                break;
            }
            d6 = d8;
        }
        System.out.println("Cutoff RI (based on linear regression angle) = " + GeneralUtils.formatFloat(d, 7));
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static double linearRegressionAngle(double[] xvals, double[] yvals, int shift) {
        void var3_3;
        double sumy = 0.0;
        double sumx = 0.0;
        for (int i = shift; i < yvals.length; ++i) {
            sumy += yvals[i];
            sumx += xvals[i];
        }
        void ybar = var3_3 / (double)yvals.length;
        double xbar = sumx / (double)yvals.length;
        double xxbar = 0.0;
        double xybar = 0.0;
        for (void i = var2_2; i < yvals.length; ++i) {
            xxbar += (xvals[i] - xbar) * (xvals[i] - xbar);
            xybar += (xvals[i] - xbar) * (yvals[i] - ybar);
        }
        double d = xybar / xxbar;
        return d;
    }
}

