/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.basta.GenericBastaLikelihoodDelegate;
import dr.evomodel.coalescent.basta.ProcessOnCoalescentIntervalDelegate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelBastaLikelihoodDelegate
extends GenericBastaLikelihoodDelegate {
    private static final int MIN_BRANCH_TASKS = 50;
    private static final int MIN_MATRIX_TASKS = 1000000;
    private final int threadCount;
    private final ExecutorService pool;
    private final double[][] temp;

    public ParallelBastaLikelihoodDelegate(String string, Tree tree, int n, int n2, boolean bl) {
        super(string, tree, n, bl);
        if (n2 > 1) {
            this.pool = Executors.newFixedThreadPool(n2);
        } else if (n2 < -1) {
            this.pool = Executors.newCachedThreadPool();
        } else {
            throw new IllegalArgumentException("Illegal threadCount value");
        }
        this.threadCount = Math.abs(n2);
        this.temp = new double[this.threadCount][n * n];
    }

    @Override
    protected void computeInnerBranchIntervalOperations(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, int n4, int n5) {
        int n6 = n5 - n4;
        if (n6 <= 50) {
            super.computeInnerBranchIntervalOperations(list, n4, n5);
        } else {
            this.forkJoin((n, n2, n3) -> super.computeInnerBranchIntervalOperations(list, n, n2), n4, n5);
        }
    }

    @Override
    protected void computeInnerTransitionProbabilityOperationsGrad(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list, int n4, int n5) {
        int n6 = n5 - n4;
        if (n6 <= 1000000) {
            super.computeInnerTransitionProbabilityOperationsGrad(list, n4, n5);
        } else {
            this.forkJoin((n, n2, n3) -> super.computeInnerTransitionProbabilityOperationsGrad(list, n, n2), n4, n5);
        }
    }

    @Override
    protected void computeInnerBranchIntervalOperationsGrad(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list2, int n4, int n5) {
        int n6 = n5 - n4;
        if (n6 <= 50) {
            super.computeInnerBranchIntervalOperationsGrad(list, list2, n4, n5);
        } else {
            this.forkJoin((n, n2, n3) -> super.computeInnerBranchIntervalOperationsGrad(list, list2, n, n2), n4, n5);
        }
    }

    @Override
    protected void computeInnerTransitionProbabilityOperations(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list, int n4, int n5, double[] dArray) {
        int n6 = n5 - n4;
        if (n6 <= 1000000) {
            super.computeInnerTransitionProbabilityOperations(list, n4, n5, dArray);
        } else {
            this.forkJoin((n, n2, n3) -> super.computeInnerTransitionProbabilityOperations(list, n, n2, this.temp[n3]), n4, n5);
        }
    }

    private void forkJoin(RangeCallable rangeCallable, int n, int n2) {
        int n3 = n2 - n;
        int n4 = n3 / this.threadCount;
        if (n3 % this.threadCount != 0) {
            ++n4;
        }
        ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>(this.threadCount);
        int n5 = 0;
        for (int i = n; i < n2; i += n4) {
            int n6 = i;
            int n7 = Math.min(n2, i + n4);
            int n8 = n5++;
            arrayList.add(() -> {
                rangeCallable.execute(n6, n7, n8);
                return null;
            });
        }
        try {
            this.pool.invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private static interface RangeCallable {
        public void execute(int var1, int var2, int var3);
    }
}

