/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.MultivariateDistribution;

public class MultivariateGammaDistribution
implements MultivariateDistribution,
GradientProvider {
    public static final String TYPE = "multivariateGamma";
    private double[] shape;
    private double[] scale;
    private int dim;
    private boolean[] flags;

    public MultivariateGammaDistribution(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("Creation error in MultivariateGammaDistribution");
        }
        this.dim = dArray.length;
        this.shape = dArray;
        this.scale = dArray2;
        this.flags = new boolean[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.flags[i] = true;
        }
    }

    public MultivariateGammaDistribution(double[] dArray, double[] dArray2, boolean[] blArray) {
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("Creation error in MultivariateGammaDistribution");
        }
        this.dim = dArray.length;
        this.shape = dArray;
        this.scale = dArray2;
        this.flags = blArray;
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        if (dArray.length != this.dim) {
            throw new IllegalArgumentException("data array is of the wrong dimension");
        }
        for (int i = 0; i < this.dim; ++i) {
            if (!this.flags[i]) continue;
            d += GammaDistribution.logPdf(dArray[i], this.shape[i], this.scale[i]);
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = GammaDistribution.gradLogPdf(dArray[i], this.shape[i], this.scale[i]);
        }
        return dArray2;
    }
}

