/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.stat.tdouble.DoubleDescriptive;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinder;

public class ExactDoubleQuantileFinder
extends PersistentObject
implements DoubleQuantileFinder {
    private static final long serialVersionUID = 1L;
    public DoubleArrayList buffer = new DoubleArrayList(0);
    public boolean isSorted;

    public ExactDoubleQuantileFinder() {
        this.clear();
    }

    public void add(double d) {
        this.buffer.add(d);
        this.isSorted = false;
    }

    public void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    public void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        this.buffer.addAllOfFromTo(doubleArrayList, n, n2);
        this.isSorted = false;
    }

    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    public Object clone() {
        ExactDoubleQuantileFinder exactDoubleQuantileFinder = (ExactDoubleQuantileFinder)super.clone();
        if (this.buffer != null) {
            exactDoubleQuantileFinder.buffer = exactDoubleQuantileFinder.buffer.copy();
        }
        return exactDoubleQuantileFinder;
    }

    public boolean contains(double d) {
        this.sort();
        return this.buffer.binarySearch(d) >= 0;
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        double[] dArray = this.buffer.elements();
        int n = (int)this.size();
        int n2 = 0;
        while (n2 < n) {
            if (doubleProcedure.apply(dArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public long memory() {
        return this.buffer.elements().length;
    }

    public double phi(double d) {
        this.sort();
        return DoubleDescriptive.rankInterpolated(this.buffer, d) / (double)this.size();
    }

    public DoubleArrayList quantileElements(DoubleArrayList doubleArrayList) {
        this.sort();
        return DoubleDescriptive.quantiles(this.buffer, doubleArrayList);
    }

    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    public long totalMemory() {
        return this.memory();
    }
}

