/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.robjects.RModel;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarDouble;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.SVarInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.util.Global;

public class RController {
    public static final String TEMP_MATRIX_DIM_NAMES_JGR = "tempMatrixDimNamesJGR";
    public static final String TEMP_MATRIX_CONTENT_JGR = "tempMatrixContentJGR";
    public static final String TEMP_VARIABLE_NAME = "jgrtemp";
    public static Object dummy = new Object();

    public static String getRHome() {
        try {
            REXP x = JGR.timedEval("R.home()");
            return x.asString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String[] getRLibs() {
        try {
            REXP x = JGR.timedEval(".libPaths()");
            return x.asStrings();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getRPrompt() {
        try {
            REXP x = JGR.timedEval("try(as.character(options('prompt')),silent=TRUE)");
            return x.asString();
        }
        catch (Exception exception) {
            return "> ";
        }
    }

    public static String getRContinue() {
        try {
            REXP x = JGR.timedEval("try(as.character(options('continue')),silent=TRUE)");
            return x.asString();
        }
        catch (Exception exception) {
            return "> ";
        }
    }

    public static String getCurrentPackages() {
        try {
            REXP x = JGR.timedEval(".packages(TRUE)");
            if (x != null && !x.isNull() && x.asStrings() != null) {
                String p = "";
                for (int i = 0; i < x.asStrings().length - 1; ++i) {
                    p = p + x.asStrings()[i] + ",";
                }
                p = p + x.asStrings()[x.asStrings().length - 1];
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String[] getDefaultPackages() {
        try {
            REXP x = JGR.timedEval("getOption(\"defaultPackages\")");
            return x.asStrings();
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String[] getJgrDefaultPackages() {
        String jdp = JGRPrefs.defaultPackages;
        if (jdp == null) {
            jdp = "JGR";
        }
        try {
            REXP x = JGR.timedEval("as.character(unique(c(getOption(\"defaultPackages\"),strsplit(\"" + jdp + "\",', ?')[[1]],'JGR')))");
            return x.asStrings();
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static void requirePackages(String rlist) {
        try {
            JGR.timedAssign(".$JGR", new REXPString(rlist));
            JGR.timedEval("{ for (pkg in strsplit(`.$JGR`,', ?')[[1]]) require(pkg, warn.conflicts=FALSE, character.only=TRUE); rm(`.$JGR`); TRUE }");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadPackage(String pack) {
        String packages = RController.getCurrentPackages();
        if (!packages.contains(pack)) {
            try {
                JGR.timedEval("cat('Package " + pack + " not found. Attempting to download...\n')");
            }
            catch (Exception exception) {
                // empty catch block
            }
            JGR.MAINRCONSOLE.execute("install.packages('" + pack + "');library(" + pack + ")", true);
        } else {
            try {
                JGR.MAINRCONSOLE.execute("library(" + pack + ")");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String[] completeCommand(String partOfCmd) {
        if (!JGR.STARTED) {
            return null;
        }
        if (partOfCmd.trim().length() == 0) {
            return null;
        }
        partOfCmd = partOfCmd.replaceAll("\\.", "\\\\\\\\.");
        try {
            REXP cmds = JGR.idleEval("try(.completeCommand(\"" + partOfCmd + "\"),silent=TRUE)");
            String[] c = null;
            if (cmds != null && (c = cmds.asStrings()) != null) {
                return c;
            }
        }
        catch (REngineException rEngineException) {
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return null;
    }

    public static String[] completeFile(String part) {
        part = part.replaceFirst("~", System.getProperty("user.home"));
        int tl = part.length();
        int ls = tl - 1;
        int fb = 0;
        if (tl == 0) {
            ls = 0;
        }
        String dir = null;
        boolean working = false;
        String fn = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            part = part.replaceAll(":/", "://");
        }
        while (ls > 0 && part.charAt(ls) != '/') {
            --ls;
        }
        if (ls == 0 && (tl == 0 || part.charAt(ls) != '/')) {
            working = true;
        }
        dir = working ? "." : (ls == 0 ? "/" : part.substring(0, ls));
        fb = ls;
        if (fb < tl && part.charAt(fb) == '/') {
            ++fb;
        }
        fn = fb < tl ? part.substring(fb) : "";
        File directory = null;
        String[] cont = null;
        directory = new File(dir);
        if (directory.exists()) {
            cont = directory.list();
        }
        if (cont == null) {
            return null;
        }
        int matches = 0;
        Vector<String> matchedFiles = new Vector<String>();
        String common = null;
        for (int i = 0; i < cont.length; ++i) {
            String sx = cont[i];
            if (!sx.startsWith(fn)) continue;
            common = matches == 0 ? sx : RController.commonWithPrefix(common, sx);
            ++matches;
            if (JGRPrefs.showHiddenFiles) {
                matchedFiles.add(sx);
                continue;
            }
            if (sx.trim().startsWith(".")) continue;
            matchedFiles.add(sx);
        }
        if (common != null && matchedFiles.size() == 1) {
            String fnp = common.replace('\\', '/');
            File tfile = null;
            fnp = dir == "." ? fnp : (dir == "/" ? "/" + fnp : dir + "/" + fnp);
            tfile = new File(fnp);
            if (tfile.exists() && tfile.isDirectory()) {
                fnp = fnp + "/";
            }
            if (fnp.endsWith("//")) {
                fnp = "";
            }
            return new String[]{fnp.replaceFirst(part, "")};
        }
        if (matchedFiles.size() > 1) {
            Object[] m = new String[matchedFiles.size()];
            matchedFiles.copyInto(m);
            return m;
        }
        return null;
    }

    public static String addSlashes(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer s = new StringBuffer(str);
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\"') {
                s.insert(i++, '\\');
                continue;
            }
            if (s.charAt(i) != '\'') continue;
            s.insert(i++, '\\');
        }
        return s.toString();
    }

    public static String makeValidVariableName(String var) {
        String v = var.replaceAll("[ -+*/\\()=!~`@#$%^&*<>,?;:\"']", ".");
        return v.replaceAll("^\\d", "d");
    }

    public static String makeRStringVector(ArrayList lis) {
        if (lis.size() == 0) {
            return "c()";
        }
        String result = "c(";
        for (int i = 0; i < lis.size(); ++i) {
            result = result + "\"" + lis.get(i).toString() + "\"";
            if (i < lis.size() - 1) {
                result = result + ",";
            }
            if (i % 10 != 9) continue;
            result = result + "\n";
        }
        result = result + ")";
        return result;
    }

    public static String makeRStringVector(JList list) {
        ArrayList varList = new ArrayList();
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            varList.add(list.getModel().getElementAt(i));
        }
        return RController.makeRStringVector(varList);
    }

    public static String makeRStringVector(DefaultListModel mod) {
        ArrayList varList = new ArrayList();
        for (int i = 0; i < mod.getSize(); ++i) {
            varList.add(mod.getElementAt(i));
        }
        return RController.makeRStringVector(varList);
    }

    public static String makeRStringVector(Vector mod) {
        ArrayList varList = new ArrayList();
        for (int i = 0; i < mod.size(); ++i) {
            varList.add(mod.get(i));
        }
        return RController.makeRStringVector(varList);
    }

    public static String makeRVector(Vector vec) {
        String outcomes = "c(";
        for (int i = 0; i < vec.size(); ++i) {
            outcomes = outcomes + (String)vec.get(i);
            if (i < vec.size() - 1) {
                outcomes = outcomes + ",";
            }
            if (i % 10 != 9) continue;
            outcomes = outcomes + "\n";
        }
        outcomes = outcomes + ")";
        return outcomes;
    }

    public static String makeRVector(DefaultListModel mod) {
        Vector tmp = new Vector();
        for (int i = 0; i < mod.getSize(); ++i) {
            tmp.add(mod.getElementAt(i));
        }
        return RController.makeRVector(tmp);
    }

    public static boolean isValidSubsetExp(String subset, String dataName) {
        if (subset == null || subset.length() < 1) {
            return false;
        }
        try {
            REXPLogical valid = (REXPLogical)JGR.timedEval("(function(x,subset){result<-try(e <- substitute(subset),silent=TRUE)\nif(class(result)==\"try-error\")\n\treturn(FALSE)\nresult<-try(r <- eval(e, x, parent.frame()),silent=TRUE)\nif(class(result)==\"try-error\")\n\treturn(FALSE)\nis.logical(r)\n})(" + dataName + "," + subset + ")");
            if (valid == null) {
                return false;
            }
            if (valid == null) {
                return false;
            }
            return valid.isTRUE()[0];
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String[] getKeyWords() {
        String[] r = null;
        try {
            REXP x = JGR.idleEval(".refreshKeyWords()");
            if (x != null && !x.isNull() && (r = x.asStrings()) != null) {
                return r;
            }
        }
        catch (REngineException rEngineException) {
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return r;
    }

    public static String[] getObjects() {
        String[] r = null;
        try {
            REXP x = JGR.idleEval(".refreshObjects()");
            if (x != null && !x.isNull() && (r = x.asStrings()) != null) {
                return r;
            }
        }
        catch (REngineException rEngineException) {
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return r;
    }

    public static void refreshObjects() {
        String name;
        boolean b;
        int i;
        int a;
        REXP x = null;
        try {
            String[] models;
            x = JGR.idleEval(".getModels()");
            if (x != null && x != null && !x.isNull()) {
                JGR.MODELS.clear();
            }
            if (x != null && !x.isNull() && x != null && !x.isNull() && (models = x.asStrings()) != null) {
                for (int i2 = 0; i2 < models.length; ++i2) {
                    JGR.MODELS.add(RController.createRModel(models[i2], models[++i2]));
                }
            }
        }
        catch (REngineException i2) {
        }
        catch (REXPMismatchException i2) {
            // empty catch block
        }
        try {
            String[] data;
            x = JGR.idleEval(".getDataObjects()");
            if (x != null && !x.isNull()) {
                JGR.DATA.clear();
            }
            if (x != null && !x.isNull() && (data = x.asStrings()) != null) {
                a = 1;
                for (i = 0; i < data.length; ++i) {
                    b = data[i].equals("null") || data[i].trim().length() == 0;
                    name = b ? a + "" : data[i];
                    JGR.DATA.add(RController.createRObject(name, data[++i], null, !b));
                    ++a;
                }
            }
        }
        catch (REngineException data) {
        }
        catch (REXPMismatchException data) {
            // empty catch block
        }
        try {
            String[] other;
            x = JGR.idleEval(".getOtherObjects()");
            if (x != null && !x.isNull()) {
                JGR.OTHERS.clear();
            }
            if (x != null && !x.isNull() && (other = x.asStrings()) != null) {
                a = 1;
                for (i = 0; i < other.length; ++i) {
                    b = other[i].equals("null") || other[i].trim().length() == 0;
                    name = b ? a + "" : other[i];
                    JGR.OTHERS.add(RController.createRObject(name, other[++i], null, !b));
                    ++a;
                }
            }
        }
        catch (REngineException other) {
        }
        catch (REXPMismatchException other) {
            // empty catch block
        }
        try {
            String[] functions;
            x = JGR.idleEval(".getFunctionsInWS()");
            if (x != null && !x.isNull()) {
                JGR.FUNCTIONS.clear();
            }
            if (x != null && !x.isNull() && (functions = x.asStrings()) != null) {
                a = 1;
                for (i = 0; i < functions.length; ++i) {
                    JGR.FUNCTIONS.add(RController.createRObject(functions[i], "function", null, true));
                    ++a;
                }
            }
        }
        catch (REngineException rEngineException) {
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
    }

    public static Object[][] refreshPackages() {
        Object[][] pkg;
        block8: {
            pkg = null;
            Hashtable<String, Object> loadedP = new Hashtable<String, Object>();
            try {
                int i;
                String[] res;
                REXP x = JGR.timedEval("sort(.packages(all.available=T))");
                if (x == null || x.isNull() || x.asStrings() == null) break block8;
                REXP y = JGR.timedEval("(.packages())");
                if (y != null && !y.isNull() && (res = y.asStrings()) != null) {
                    for (i = 0; i < res.length; ++i) {
                        loadedP.put(res[i], dummy);
                    }
                }
                res = x.asStrings();
                pkg = new Object[res.length][4];
                for (i = 0; i < res.length; ++i) {
                    pkg[i][2] = new String(res[i]);
                    try {
                        pkg[i][3] = JGR.timedEval("packageDescription(\"" + res[i] + "\",fields=\"Title\")").asString();
                    }
                    catch (Exception e) {
                        pkg[i][1] = "";
                    }
                    pkg[i][0] = loadedP.containsKey(res[i]) ? new Boolean(true) : new Boolean(false);
                    pkg[i][1] = new Boolean(false);
                    for (int d = 0; d < JGRPackageManager.defaultPackages.length; ++d) {
                        if (!res[i].equals(JGRPackageManager.defaultPackages[d]) && !JGRPackageManager.neededPackages.containsKey(res[i])) continue;
                        pkg[i][1] = new Boolean(true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pkg;
    }

    public static Vector createContent(RObject o, Collection c) {
        Vector<RObject> cont = new Vector<RObject>();
        String p = "";
        if (o.getParent() != null && o.getParent().getType().equals("table")) {
            p = "," + o.getParent().getRName();
        }
        try {
            String[] res;
            REXP x = JGR.timedEval("suppressWarnings(try(.getContent(" + o.getRName() + p + "),silent=TRUE))");
            if (x != null && !x.isNull() && (res = x.asStrings()) != null && !res[0].startsWith("Error")) {
                int a = 1;
                for (int i = 0; i < res.length; ++i) {
                    RObject ro;
                    boolean b = res[i].equals("null") || res[i].trim().length() == 0;
                    String name = b ? a + "" : res[i];
                    if ((ro = RController.createRObject(name, res[++i], o, !b)) != null) {
                        cont.add(ro);
                    }
                    ++a;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cont;
    }

    public static RObject createRObject(String sx, String type, RObject parent, boolean b) {
        RObject ro = new RObject(sx, type, parent, b);
        if (type.equals("data.frame")) {
            try {
                REXP y = JGR.timedEval("dim(" + ro.getRName() + ")");
                if (y != null && !y.isNull() && y.asIntegers() != null) {
                    ro.setInfo("dim(" + y.asIntegers()[0] + ":" + y.asIntegers()[1] + ")");
                }
            }
            catch (Exception exception) {}
        } else if (type.equals("matrix")) {
            try {
                REXP y = JGR.timedEval("dim(" + ro.getRName() + ")");
                if (y != null && !y.isNull() && y.asIntegers() != null) {
                    ro.setInfo("dim(" + y.asIntegers()[0] + ":" + y.asIntegers()[1] + ")");
                }
            }
            catch (Exception exception) {}
        } else if (type.equals("factor")) {
            try {
                REXP y = JGR.timedEval("length(levels(" + ro.getRName() + "))");
                if (y != null && y != null && !y.isNull() && y.asIntegers() != null) {
                    ro.setInfo("levels: " + y.asIntegers()[0]);
                }
            }
            catch (Exception exception) {}
        } else if (type.equals("list")) {
            try {
                REXP y = JGR.timedEval("length(" + ro.getRName() + ")");
                if (y != null && !y.isNull() && y.asIntegers() != null) {
                    ro.setInfo("length: " + y.asIntegers()[0]);
                }
            }
            catch (Exception exception) {}
        } else if (type.equals("table")) {
            try {
                REXP y = JGR.timedEval("length(dim(" + ro.getRName() + "))");
                if (y != null && !y.isNull() && y.asIntegers() != null) {
                    ro.setInfo("dim: " + y.asIntegers()[0]);
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {}
        } else if (type.equals("function")) {
            String fHelp = RController.getFunHelp(ro.getRName());
            if (fHelp != null) {
                ro.setInfo("arguments: " + fHelp.replaceFirst(ro.getRName(), "").replaceAll("<br>", ""));
            }
        } else if (parent != null && parent.getType().equals("table")) {
            try {
                REXP y = JGR.timedEval("length(dimnames(" + parent.getRName() + ")[[\"" + ro.getName() + "\"]])");
                if (y != null && !y.isNull() && y.asIntegers() != null) {
                    ro.setInfo("cats: " + y.asIntegers()[0]);
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
        }
        return ro;
    }

    public static RModel createRModel(String sx, String type) {
        int i;
        String[] res2;
        REXP z;
        double[] res;
        REXP y;
        RModel m = new RModel(sx, type);
        try {
            y = JGR.timedEval("try(summary(" + sx + ")[[\"r.squared\"]],silent=TRUE)");
            if (y != null && !y.isNull() && y.isNumeric() && (res = y.asDoubles()) != null) {
                m.setRsquared(res[0]);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        try {
            y = JGR.timedEval("try(AIC(" + sx + "),silent=TRUE)");
            if (y != null && !y.isNull() && y.isNumeric() && (res = y.asDoubles()) != null) {
                m.setAic(res[0]);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        try {
            y = JGR.timedEval("try(deviance(" + sx + "),silent=TRUE)");
            if (y != null && !y.isNull() && y.isNumeric() && (res = y.asDoubles()) != null) {
                m.setDeviance(res[0]);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        try {
            int[] res1;
            REXP x = JGR.timedEval("try(summary(" + sx + ")[[\"df\"]],silent=TRUE)");
            if (x != null && x != null && !x.isNull() && x.isNumeric() && (res1 = x.asIntegers()) != null) {
                m.setDf(res1[0]);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        try {
            z = JGR.timedEval("try(family(" + sx + ")[[\"family\"]],silent=TRUE)");
            if (z != null && !z.isNull() && (res2 = z.asStrings()) != null) {
                m.setFamily(res2[0]);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        try {
            z = JGR.timedEval("suppressWarnings(try(capture.output(" + sx + "[[\"call\"]][[\"formula\"]])))");
            if (z != null && !z.isNull() && (res2 = z.asStrings()) != null) {
                String call = "";
                for (i = 0; i < res2.length; ++i) {
                    call = call + res2[i];
                }
                m.setCall(call);
            }
        }
        catch (REXPMismatchException call) {
            // empty catch block
        }
        try {
            z = JGR.timedEval("suppressWarnings(try(capture.output(" + sx + "[[\"call\"]][[\"data\"]])))");
            if (z != null && !z.isNull() && (res2 = z.asStrings()) != null) {
                String data = "";
                for (i = 0; i < res2.length; ++i) {
                    data = data + res2[i];
                }
                if (!data.trim().equals("NULL")) {
                    m.setData(data);
                }
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return m;
    }

    public static String getFunHelpTip(String s) {
        String tip = RController.getFunHelp(s);
        return tip != null ? "<html><pre>" + tip + "</pre></html>" : null;
    }

    private static String getFunHelp(String s) {
        if (s == null) {
            return null;
        }
        String tip = null;
        String[] res = null;
        try {
            REXP x = JGR.idleEval("try(deparse(args(" + s + ")),silent=T)");
            if (x != null && !x.isNull() && (res = x.asStrings()) != null) {
                tip = "";
                int l = -1;
                for (int i = 0; i < (l = res.length); ++i) {
                    if (l - 2 == i && !res[i].trim().equals("NULL")) {
                        tip = tip + res[i].replaceFirst("function", s);
                        continue;
                    }
                    if (res[i].trim().equals("NULL")) continue;
                    tip = tip + res[i].replaceFirst("function", s) + "<br>";
                }
            } else {
                return null;
            }
            tip = tip + "";
            if (tip.trim().length() == 0) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return tip.indexOf("Error") >= 0 ? null : tip;
    }

    public static String getSummary(RObject o) {
        if (o.getType().equals("function")) {
            return "<html><pre>" + RController.getFunHelp(o.getRName()) + "</pre></html>";
        }
        String tip = "";
        String[] res = null;
        try {
            int l;
            REXP x = JGR.idleEval("suppressWarnings(try(capture.output(summary(" + o.getRName() + ")),silent=TRUE))");
            if (x != null && !x.isNull() && (res = x.asStrings()) != null && !res[0].startsWith("Error")) {
                l = -1;
                for (int i = ((l = res.length) > 10 ? 10 : l) - 1; i >= 0; --i) {
                    tip = i < l - 1 ? res[i] + "<br>" + tip : res[i] + "       ";
                }
            } else {
                return null;
            }
            tip = "<html><pre>" + tip + (l > 10 ? "..." : "") + "</pre></html>";
        }
        catch (Exception e) {
            return null;
        }
        return tip.startsWith("<html><pre>Error") ? null : tip;
    }

    public static void newFunction(RObject o) {
        try {
            String[] res;
            REXP x = JGR.timedEval("suppressWarnings(try(capture.output(" + o.getRName() + "),silent=TRUE))");
            if (x != null && !x.isNull() && (res = x.asStrings()) != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < res.length; ++i) {
                    if (i == 0) {
                        sb.append(o.getRName() + " <- " + res[i] + "\n");
                        continue;
                    }
                    sb.append(res[i] + "\n");
                }
                if (sb.length() > 0) {
                    new Editor().setText(sb);
                }
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
    }

    public static SVarSet newSet(RObject o) {
        SVarSet cvs = new SVarSet();
        cvs.setName(o.getRName());
        if (o.getType().equals("function")) {
            try {
                String[] res;
                REXP x = JGR.timedEval("suppressWarnings(try(paste(deparse(" + o.getRName() + "),collapse=\"\n\"),silent=TRUE))");
                if (x != null && !x.isNull() && (res = x.asStrings()) != null) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < res.length; ++i) {
                        if (i == 0) {
                            sb.append(o.getRName() + " <- " + res[i] + "\n");
                            continue;
                        }
                        sb.append(res[i] + "\n");
                    }
                    if (sb.length() > 0) {
                        Editor ed = new Editor();
                        ed.setText(sb);
                    }
                }
            }
            catch (REXPMismatchException res) {
                // empty catch block
            }
            return null;
        }
        try {
            Iterator i;
            String[] res;
            REXP x = JGR.timedEval("suppressWarnings(try(attributes(" + o.getRName() + ")[[\"row.names\"]],silent=TRUE))");
            if (x != null && !x.isNull() && (res = x.asStrings()) != null && res.length > 0 && !res[0].startsWith("Error")) {
                SVar v = RController.newVar(cvs, "row.names", x.asStrings());
                cvs.add(v);
            }
            if (!(i = RController.createContent(o, null).iterator()).hasNext()) {
                cvs.add(RController.createSVar(cvs, o));
            }
            while (i.hasNext()) {
                RObject o2 = (RObject)i.next();
                cvs.add(RController.createSVar(cvs, o2));
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return cvs;
    }

    private static SVar createSVar(SVarSet cvs, RObject o) {
        SVar v = null;
        try {
            REXP x = JGR.timedEval("suppressWarnings(try(" + o.getRName() + ",silent=TRUE))");
            if (x == null || x.isNull()) {
                return null;
            }
            if (o.getType().equals("factor")) {
                REXP y = JGR.timedEval("suppressWarnings(try(levels(" + o.getRName() + "),silent=TRUE))");
                REXP z = JGR.timedEval("suppressWarnings(try(as.integer(" + o.getRName() + "),silent=TRUE))");
                if (z != null && !z.isNull() && x != null && !x.isNull() && y.asStrings() != null && z.asIntegers() != null) {
                    int[] id = new int[z.asIntegers().length];
                    for (int i = 0; i < id.length; ++i) {
                        id[i] = z.asIntegers()[i];
                    }
                    v = RController.newVar(cvs, o.getName(), id, y.asStrings());
                }
            } else if (o.getType().equals("character")) {
                if (x != null && !x.isNull() && x.isString()) {
                    v = RController.newVar(cvs, o.getName(), x.asStrings());
                }
            } else if (x != null && !x.isNull() && x.isInteger()) {
                v = RController.newVar(cvs, o.getName(), x.asIntegers());
            } else if (x != null && !x.isNull() && x.isNumeric()) {
                v = RController.newVar(cvs, o.getName(), x.asDoubles());
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return v;
    }

    public static SVar newVar(SVarSet cvs, String name, double[] d) {
        if (d == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: double[" + d.length + "]");
        }
        if (cvs.count() > 0 && cvs.at(0).size() != d.length) {
            double[] n = new double[cvs.at(0).size()];
            for (int i = 0; i < d.length && i < n.length; ++i) {
                n[i] = d[i];
            }
            d = n;
        }
        SVarDouble v = new SVarDouble(name, d);
        return v;
    }

    public static SVar newVar(SVarSet cvs, String name, int[] d) {
        if (d == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + d.length + "]");
        }
        if (cvs.count() > 0 && cvs.at(0).size() != d.length) {
            int[] n = new int[cvs.at(0).size()];
            for (int i = 0; i < d.length && i < n.length; ++i) {
                n[i] = d[i];
            }
            d = n;
        }
        SVarInt v = new SVarInt(name, d);
        return v;
    }

    public static SVar newVar(SVarSet cvs, String name, String[] d) {
        int i;
        if (d == null) {
            return null;
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: String[]");
        }
        if (cvs.count() > 0 && cvs.at(0).size() != d.length) {
            String[] n = new String[cvs.at(0).size()];
            for (i = 0; i < d.length && i < n.length; ++i) {
                n[i] = d[i];
            }
            d = n;
        }
        SVarObj v = new SVarObj(name);
        i = 0;
        while (i < d.length) {
            ((SVar)v).add(d[i++]);
        }
        return v;
    }

    public static SVar newVar(SVarSet cvs, String name, int[] ix, String[] d) {
        if (ix == null) {
            return null;
        }
        if (d == null) {
            return RController.newVar(cvs, name, ix);
        }
        if (Global.DEBUG > 0) {
            System.out.println("newVar: int[" + ix.length + "] + levels[" + d.length + "]");
        }
        if (cvs.count() > 0 && cvs.at(0).size() != ix.length) {
            int[] n = new int[cvs.at(0).size()];
            for (int i = 0; i < d.length && i < n.length; ++i) {
                n[i] = ix[i];
            }
            ix = n;
        }
        int j = 0;
        while (j < ix.length) {
            int n = j++;
            ix[n] = ix[n] - 1;
        }
        SVarFact v = new SVarFact(name, ix, d);
        return v;
    }

    public static boolean export(SVarSet vs, String type) {
        boolean success = false;
        if (type == null || type.equals("data.frame")) {
            success = RController.exportDataFrame(vs);
        } else if (type != null && type.equals("matrix")) {
            success = RController.exportMatrix(vs);
        } else if (type != null && type.equals("list")) {
            success = RController.exportList(vs);
        } else if (type != null && type.equals("numeric")) {
            success = RController.exportNumeric(vs);
        } else if (type != null && type.equals("integer")) {
            success = RController.exportInteger(vs);
        } else if (type != null && type.equals("character")) {
            success = RController.exportCharacter(vs);
        } else if (type != null && type.equals("factor")) {
            success = RController.exportFactor(vs);
        }
        return success;
    }

    private static boolean exportNumeric(SVarSet vs) {
        try {
            if (vs.count() > 1) {
                return false;
            }
            if (vs.at(0) instanceof SVarInt) {
                return RController.exportInteger(vs);
            }
            JGR.timedAssign(TEMP_VARIABLE_NAME, new REXPDouble(((SVarDouble)vs.at((int)0)).cont));
            RController.setVariableName(vs.getName());
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    private static boolean exportInteger(SVarSet vs) {
        try {
            if (vs.count() > 1) {
                return false;
            }
            JGR.timedAssign(TEMP_VARIABLE_NAME, new REXPInteger(((SVarInt)vs.at((int)0)).cont));
            RController.setVariableName(vs.getName());
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    private static boolean exportFactor(SVarSet vs) {
        try {
            if (vs.count() > 1) {
                return false;
            }
            int[] ids = new int[((SVarFact)vs.at((int)0)).cont.length];
            for (int z = 0; z < ids.length; ++z) {
                ids[z] = ((SVarFact)vs.at((int)0)).cont[z] + 1;
            }
            REXPFactor factor = new REXPFactor(ids, ((SVarFact)vs.at((int)0)).cats);
            JGR.timedAssign(TEMP_VARIABLE_NAME, factor);
            RController.setVariableName(vs.getName());
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    private static boolean exportCharacter(SVarSet vs) {
        try {
            if (vs.count() > 1) {
                return false;
            }
            JGR.timedAssign(TEMP_VARIABLE_NAME, new REXPString(((SVarObj)vs.at(0)).getContent()));
            RController.setVariableName(vs.getName());
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    private static boolean setVariableName(String name) throws REngineException, REXPMismatchException {
        JGR.timedEval(name + " <- " + TEMP_VARIABLE_NAME + "; rm(" + TEMP_VARIABLE_NAME + ")");
        return true;
    }

    private static boolean exportDataFrame(SVarSet vs) {
        try {
            int i;
            boolean rnames = false;
            String[] rownames = new String[vs.length()];
            SVar rn = null;
            int rnn = 0;
            for (int i2 = 0; i2 < vs.count(); ++i2) {
                if (!vs.at(i2).getName().equals("row.names")) continue;
                int length = rownames.length;
                for (int a = 0; a < rownames.length; ++a) {
                    Object o = vs.at(i2).at(a);
                    if (o != null) {
                        rownames[a] = o.toString();
                        continue;
                    }
                    rownames[a] = length - 1 + "";
                    ++length;
                }
                rnames = true;
                rnn = i2;
                rn = vs.at(i2);
                vs.remove(i2);
                break;
            }
            RList content = new RList();
            for (i = 0; i < vs.count(); ++i) {
                if (vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                    REXPDouble rd = new REXPDouble(((SVarDouble)vs.at((int)i)).cont);
                    content.put(vs.at(i).getName(), rd);
                    continue;
                }
                if (vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                    REXPInteger ri = new REXPInteger(((SVarInt)vs.at((int)i)).cont);
                    content.put(vs.at(i).getName(), ri);
                    continue;
                }
                if (vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    int[] ids = new int[((SVarFact)vs.at((int)i)).cont.length];
                    String[] cats = ((SVarFact)vs.at((int)i)).cats;
                    boolean NAS = false;
                    for (int z = 0; z < ids.length; ++z) {
                        ids[z] = ((SVarFact)vs.at((int)i)).cont[z] + 1;
                        if (ids[z] != 0) continue;
                        NAS = true;
                        ids[z] = cats.length + 1;
                    }
                    if (NAS) {
                        String[] newcats = new String[cats.length + 1];
                        System.arraycopy(cats, 0, newcats, 0, cats.length);
                        newcats[newcats.length - 1] = "NA";
                        cats = newcats;
                        NAS = false;
                    }
                    REXPFactor rf = new REXPFactor(ids, cats);
                    content.put(vs.at(i).getName(), rf);
                    continue;
                }
                if (!vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarObj")) continue;
                REXPString rs = new REXPString(((SVarObj)vs.at(i)).getContent());
                content.put(vs.at(i).getName(), rs);
            }
            if (!rnames) {
                for (i = 1; i <= rownames.length; ++i) {
                    rownames[i - 1] = i + "";
                }
            }
            if (rnames) {
                vs.insert(rnn, rn);
            }
            REXPString rexpRowNames = new REXPString(rownames);
            JGR.timedAssign(TEMP_VARIABLE_NAME, RController.createDataFrame(content, rexpRowNames));
            RController.setVariableName(vs.getName());
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    public static REXP createDataFrame(RList l, REXP rownames) throws REXPMismatchException {
        if (l == null || l.size() < 1) {
            throw new REXPMismatchException(new REXPList(l), "data frame (must have dim>0)");
        }
        if (!(l.at(0) instanceof REXPVector)) {
            throw new REXPMismatchException(new REXPList(l), "data frame (contents must be vectors)");
        }
        return new REXPGenericVector(l, new REXPList(new RList(new REXP[]{new REXPString("data.frame"), new REXPString(l.keys()), rownames}, new String[]{"class", "names", "row.names"})));
    }

    private static boolean exportMatrix(SVarSet vs) {
        try {
            Object[] mcont;
            String[] names = new String[vs.count()];
            int vlength = vs.at(0).size();
            boolean isInt = false;
            boolean isDouble = false;
            if (vs.at(0).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                mcont = new double[vs.count() * vlength];
                isDouble = true;
            } else if (vs.at(0).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                mcont = new int[vs.count() * vlength];
                isInt = true;
            } else if (vs.at(0).getClass().getName().equals("org.rosuda.ibase.SVarObj")) {
                mcont = new String[vs.count() * vlength];
            } else {
                return false;
            }
            for (int i = 0; i < vs.count(); ++i) {
                names[i] = vs.at(i).getName();
                if (isInt) {
                    System.arraycopy(((SVarInt)vs.at((int)i)).cont, 0, mcont, i * vlength, vlength);
                    continue;
                }
                if (isDouble) {
                    System.arraycopy(((SVarDouble)vs.at((int)i)).cont, 0, mcont, i * vlength, vlength);
                    continue;
                }
                System.arraycopy(((SVarObj)vs.at(i)).getContent(), 0, mcont, i * vlength, vlength);
            }
            REXPVector content = isInt ? new REXPInteger((int[])mcont) : (isDouble ? new REXPDouble((double[])mcont) : new REXPString((String[])mcont));
            JGR.timedAssign(TEMP_MATRIX_CONTENT_JGR, content);
            String[] rownames = new String[vs.length()];
            for (int i = 1; i <= rownames.length; ++i) {
                rownames[i - 1] = i + "";
            }
            REXPList dimnames = new REXPList(new RList(new REXP[]{new REXPString(rownames), new REXPString(names)}));
            JGR.timedAssign(TEMP_MATRIX_DIM_NAMES_JGR, dimnames);
            JGR.timedEval(vs.getName() + " <- matrix(tempMatrixContentJGR,dimnames=tempMatrixDimNamesJGR,nrow=" + rownames.length + ",ncol=" + names.length + ")");
            JGR.timedEval("rm(tempMatrixContentJGR);rm(tempMatrixDimNamesJGR)");
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    private static boolean exportList(SVarSet vs) {
        try {
            RList content = new RList();
            for (int i = 0; i < vs.count(); ++i) {
                if (vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                    REXPDouble rd = new REXPDouble(((SVarDouble)vs.at((int)i)).cont);
                    content.put(vs.at(i).getName(), rd);
                    continue;
                }
                if (vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                    REXPInteger ri = new REXPInteger(((SVarInt)vs.at((int)i)).cont);
                    content.put(vs.at(i).getName(), ri);
                    continue;
                }
                if (vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    int[] ids = new int[((SVarFact)vs.at((int)i)).cont.length];
                    for (int z = 0; z < ids.length; ++z) {
                        ids[z] = ((SVarFact)vs.at((int)i)).cont[z] + 1;
                    }
                    REXPFactor rf = new REXPFactor(ids, ((SVarFact)vs.at((int)i)).cats);
                    content.put(vs.at(i).getName(), rf);
                    continue;
                }
                if (!vs.at(i).getClass().getName().equals("org.rosuda.ibase.SVarObj")) continue;
                REXPString rs = new REXPString(((SVarObj)vs.at(i)).getContent());
                content.put(vs.at(i).getName(), rs);
            }
            REXPList rl = new REXPList(content);
            JGR.timedAssign(TEMP_VARIABLE_NAME, rl);
            RController.setVariableName(vs.getName());
            return true;
        }
        catch (Exception e) {
            new ErrorMsg(e);
            return false;
        }
    }

    public static String commonWithPrefix(String str1, String str2) {
        int min = Math.min(str1.length(), str2.length());
        String result = "";
        String s = "";
        for (int i = 0; i < min && (s = str1.substring(i, i + 1)).equals(str2.substring(i, i + 1)); ++i) {
            result = result + s;
        }
        return result;
    }
}

