/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.POC;

import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class POCGenerator
extends PrototypeGenerator {
    private double alfaRatio;
    private String method;
    protected int numberOfPrototypes;
    protected int numberOfClass;

    public POCGenerator(PrototypeSet _trainingDataSet, double ratio, String Method) {
        super(_trainingDataSet);
        this.algorithmName = "POC";
        this.alfaRatio = ratio;
        this.method = Method;
    }

    public POCGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "POC";
        this.method = parameters.getNextAsString();
        this.alfaRatio = parameters.getNextAsDouble();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.println("Isaac dice: ratio= " + this.alfaRatio + " method = " + this.method);
        System.out.println("Number of class= " + this.numberOfClass);
    }

    protected Pair<Prototype, Prototype> finding_poc_nn(PrototypeSet S, double class1, double class2) {
        Prototype Xp1;
        Prototype Xp2;
        PrototypeSet S1 = S.getFromClass(class1);
        PrototypeSet S2 = S.getFromClass(class2);
        if (S1.size() >= S2.size()) {
            Prototype Xm = S1.avg();
            Xp2 = S2.nearestTo(Xm);
            Xp1 = S1.nearestTo(Xp2);
        } else {
            Prototype Xm = S2.avg();
            Xp1 = S1.nearestTo(Xm);
            Xp2 = S2.nearestTo(Xp1);
        }
        return new Pair<Prototype, Prototype>(Xp1, Xp2);
    }

    protected PrototypeSet selecting_poc_nn(PrototypeSet S, double class1, double class2) {
        PrototypeSet pocNNset = new PrototypeSet(S.size());
        Pair<Prototype, Prototype> pocnn = this.finding_poc_nn(S, class1, class2);
        Prototype Xp1 = pocnn.first();
        Prototype Xp2 = pocnn.second();
        if (Xp1 != null && Xp2 != null) {
            double Aux;
            int p;
            Prototype auxC = Xp1.add(Xp2);
            Prototype center = auxC.mul(0.5);
            Prototype w = Xp1.sub(Xp2);
            double module = 1.0 / w.module();
            w = w.mul(module);
            double b = w.mulEscalar(center);
            pocNNset.add(Xp1);
            pocNNset.add(Xp2);
            PrototypeSet R1 = new PrototypeSet();
            PrototypeSet R2 = new PrototypeSet();
            double dist = Distance.d(Xp1, Xp2);
            for (int i = 0; i < S.size(); ++i) {
                Prototype Xi = (Prototype)S.get(i);
                double Aux2 = w.mulEscalar(Xi);
                if ((Aux2 -= b) >= 0.0) {
                    R1.add(Xi);
                    continue;
                }
                R2.add(Xi);
            }
            double clasR1 = Xp1.getOutput(0);
            double clasR2 = Xp2.getOutput(0);
            int misR1 = 0;
            int misR2 = 0;
            boolean[] marcas = new boolean[R1.size()];
            Arrays.fill(marcas, false);
            for (p = 0; p < R1.size(); ++p) {
                if (((Prototype)R1.get(p)).getOutput(0) == clasR1) continue;
                Aux = w.mulEscalar((Prototype)R1.get(p));
                Aux -= b;
                if ((Aux = Math.abs(Aux)) > this.alfaRatio * dist) {
                    ++misR1;
                    continue;
                }
                marcas[p] = true;
            }
            for (p = R1.size() - 1; p > 0; --p) {
                if (!marcas[p]) continue;
                R1.remove(p);
            }
            marcas = new boolean[R2.size()];
            Arrays.fill(marcas, false);
            for (p = 0; p < R2.size(); ++p) {
                if (((Prototype)R2.get(p)).getOutput(0) == clasR2) continue;
                Aux = w.mulEscalar((Prototype)R2.get(p));
                Aux -= b;
                if ((Aux = Math.abs(Aux)) > this.alfaRatio * dist) {
                    ++misR2;
                    continue;
                }
                marcas[p] = true;
            }
            for (p = R2.size() - 1; p > 0; --p) {
                if (!marcas[p]) continue;
                R2.remove(p);
            }
            if (misR1 > 0 && R1.size() > 0) {
                pocNNset.add(this.selecting_poc_nn(R1, class1, class2));
            }
            if (misR2 > 0 && R2.size() > 0) {
                pocNNset.add(this.selecting_poc_nn(R2, class1, class2));
            }
        } else {
            return null;
        }
        return pocNNset;
    }

    protected PrototypeSet replacing_poc_nn(PrototypeSet S, double class1, double class2) {
        PrototypeSet morNNset = new PrototypeSet();
        Prototype Xmor = new Prototype();
        PrototypeSet pocNNset = new PrototypeSet(S.size());
        Pair<Prototype, Prototype> pocnn = this.finding_poc_nn(S, class1, class2);
        Prototype Xp1 = pocnn.first();
        Prototype Xp2 = pocnn.second();
        if (Xp1 != null && Xp2 != null) {
            double Aux;
            int p;
            Prototype center = Xp1.add(Xp2);
            center = center.mul(0.5);
            Prototype w = Xp1.sub(Xp2);
            double module = 1.0 / w.module();
            w = w.mul(module);
            double b = w.mulEscalar(center);
            pocNNset.add(Xp1);
            pocNNset.add(Xp2);
            pocNNset.add(center);
            PrototypeSet R1 = new PrototypeSet();
            PrototypeSet R2 = new PrototypeSet();
            double dist = Distance.d(Xp1, Xp2);
            for (int i = 0; i < S.size(); ++i) {
                Prototype Xi = (Prototype)S.get(i);
                double Aux2 = w.mulEscalar(Xi);
                double AuxAbs = Math.abs(Aux2 -= b);
                if (Aux2 >= 0.0) {
                    R1.add(Xi);
                    continue;
                }
                R2.add(Xi);
            }
            double clasR1 = Xp1.getOutput(0);
            double clasR2 = Xp2.getOutput(0);
            int misR1 = 0;
            int misR2 = 0;
            boolean[] marcas = new boolean[R1.size()];
            Arrays.fill(marcas, false);
            for (p = 0; p < R1.size(); ++p) {
                if (((Prototype)R1.get(p)).getOutput(0) == clasR1) continue;
                Aux = w.mulEscalar((Prototype)R1.get(p));
                Aux -= b;
                if ((Aux = Math.abs(Aux)) > this.alfaRatio * dist) {
                    ++misR1;
                    continue;
                }
                marcas[p] = true;
            }
            for (p = R1.size() - 1; p > 0; --p) {
                if (!marcas[p]) continue;
                R1.remove(p);
            }
            marcas = new boolean[R2.size()];
            Arrays.fill(marcas, false);
            for (p = 0; p < R2.size(); ++p) {
                if (((Prototype)R2.get(p)).getOutput(0) == clasR2) continue;
                Aux = w.mulEscalar((Prototype)R2.get(p));
                Aux -= b;
                if ((Aux = Math.abs(Aux)) > this.alfaRatio * dist) {
                    ++misR2;
                    continue;
                }
                marcas[p] = true;
            }
            for (p = R2.size() - 1; p > 0; --p) {
                if (!marcas[p]) continue;
                R2.remove(p);
            }
            if (misR1 > 0 && R1.size() > 0) {
                morNNset.add(this.replacing_poc_nn(R1, class1, class2));
            } else if (R1.size() != 0) {
                Xmor = R1.avg();
                morNNset.add(Xmor);
            }
            if (misR2 > 0 && R2.size() > 0) {
                morNNset.add(this.selecting_poc_nn(R2, class1, class2));
            } else if (R2.size() != 0) {
                Xmor = R2.avg();
                morNNset.add(Xmor);
            }
            if (misR1 == 0 && misR2 == 0) {
                if (R1.size() != 0) {
                    Xmor = R1.avg();
                    morNNset.add(Xmor);
                }
                if (R2.size() != 0) {
                    Xmor = R2.avg();
                    morNNset.add(Xmor);
                }
                return morNNset;
            }
        } else {
            return null;
        }
        return morNNset;
    }

    @Override
    public PrototypeSet reduceSet() {
        int i;
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of class " + this.numberOfClass);
        PrototypeSet result = new PrototypeSet();
        if (this.numberOfClass == 2) {
            result = this.method.equals("selecting") ? this.selecting_poc_nn(this.trainingDataSet, 0.0, 1.0) : this.replacing_poc_nn(this.trainingDataSet, 0.0, 1.0);
        } else {
            for (i = 0; i < this.numberOfClass - 1; ++i) {
                for (int j = i + 1; j < this.numberOfClass; ++j) {
                    PrototypeSet sal;
                    PrototypeSet pairwise = this.trainingDataSet.getFromClass(i);
                    pairwise.add(this.trainingDataSet.getFromClass(j));
                    if (this.method.equals("selecting")) {
                        sal = this.selecting_poc_nn(pairwise, i, j);
                        if (sal == null) continue;
                        result.add(sal);
                        continue;
                    }
                    sal = this.replacing_poc_nn(pairwise, i, j);
                    if (sal == null) continue;
                    result.add(sal);
                }
            }
        }
        if (result.size() == 0) {
            for (i = 1; i < this.numberOfClass; ++i) {
                PrototypeSet aux = this.trainingDataSet.getFromClass(i);
                if (aux.size() == 0) continue;
                result.add(aux.get(RandomGenerator.RandintClosed(0, aux.size())));
            }
        }
        System.out.println("Accuracy % " + POCGenerator.accuracy(result, this.trainingDataSet));
        System.out.println("Reduction % " + (100.0 - (double)result.size() * 100.0 / (double)this.trainingDataSet.size()));
        if (result.size() > 1) {
            boolean[] marcas = new boolean[result.size()];
            Arrays.fill(marcas, true);
            double accuracyInic = KNN.classficationAccuracy(result, this.trainingDataSet);
            for (int i2 = 0; i2 < result.size(); ++i2) {
                marcas[i2] = false;
                PrototypeSet leaveOneOut = result.without((Prototype)result.get(i2));
                double accuracy = KNN.classficationAccuracy(leaveOneOut, this.trainingDataSet);
                if (!(accuracy > accuracyInic)) continue;
                marcas[i2] = true;
            }
            PrototypeSet clean = new PrototypeSet();
            for (int i3 = 0; i3 < marcas.length; ++i3) {
                if (marcas[i3]) continue;
                clean.add(result.get(i3));
            }
            System.out.println("Accuracy % " + POCGenerator.accuracy(clean, this.trainingDataSet));
            System.out.println("Reduction % " + (100 - clean.size() * 100 / this.trainingDataSet.size()));
        }
        return result;
    }

    public static void main(String[] args) {
        Parameters.setUse("POC", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        POCGenerator.setSeed(seed);
        POCGenerator generator = new POCGenerator(training, 0.5, "selection");
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

