/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.ENPC;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class ENPCGenerator
extends PrototypeGenerator {
    private int k;
    private int MaxIter;
    protected int numberOfPrototypes;
    protected int numberOfClass;

    public ENPCGenerator(PrototypeSet _trainingDataSet, int k, int max) {
        super(_trainingDataSet);
        this.algorithmName = "ENPC";
        this.k = k;
        this.MaxIter = max;
    }

    public ENPCGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "ENPC";
        this.k = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.println("Isaac dice: k= " + this.k);
        System.out.println("Number of class= " + this.numberOfClass);
    }

    protected int regions(double sj, PrototypeSet S) {
        int number = 0;
        for (Prototype p : S) {
            if (p.getOutput(0) != sj) continue;
            ++number;
        }
        return number;
    }

    protected double expectation(double sj, PrototypeSet S) {
        return (double)S.size() * 1.0 / (double)this.regions(sj, S);
    }

    protected void mutation(PrototypeSet classifier, PrototypeSet[][] V) {
        for (int i = 0; i < classifier.size(); ++i) {
            int max = 1;
            double clasToLabel = ((Prototype)classifier.get(i)).getOutput(0);
            for (int j = 0; j < V[i].length; ++j) {
                if (V[i][j].size() <= max && (V[i][j].size() != max || (double)j == ((Prototype)classifier.get(i)).getOutput(0))) continue;
                max = V[i][j].size();
                clasToLabel = ((Prototype)V[i][j].get(0)).getOutput(0);
            }
            if (max == V[i][(int)((Prototype)classifier.get(i)).getOutput(0)].size()) continue;
            ((Prototype)classifier.get(i)).setFirstOutput(clasToLabel);
        }
    }

    protected PrototypeSet[][] reproduction(PrototypeSet classifier, PrototypeSet[][] V) {
        int initialSize = classifier.size();
        for (int i = 0; i < initialSize; ++i) {
            int max = Integer.MIN_VALUE;
            double clase = 0.0;
            double limiteRuleta = 0.0;
            for (int j = 0; j < this.numberOfClass; ++j) {
                limiteRuleta += (double)V[i][j].size();
            }
            double aleatorio = RandomGenerator.Randdouble(0.0, limiteRuleta);
            double suma = 0.0;
            boolean encontrado = false;
            for (int j = 0; j < this.numberOfClass && !encontrado; ++j) {
                if (!(aleatorio < (suma += (double)V[i][j].size()))) continue;
                clase = (double)j * 1.0;
                encontrado = true;
            }
            if (clase == ((Prototype)classifier.get(i)).getOutput(0)) continue;
            classifier.add(V[i][(int)clase].avg());
            PrototypeSet[][] nuevoV = new PrototypeSet[classifier.size()][];
            for (int j = 0; j < classifier.size() - 1; ++j) {
                nuevoV[j] = new PrototypeSet[this.numberOfClass];
                for (int m = 0; m < this.numberOfClass; ++m) {
                    nuevoV[j][m] = V[j][m] != null ? V[j][m].clone() : null;
                }
            }
            nuevoV[j] = new PrototypeSet[this.numberOfClass];
            nuevoV[classifier.size() - 1][(int)clase] = V[i][(int)clase].clone();
            nuevoV[i][(int)clase] = null;
            V = new PrototypeSet[classifier.size()][];
            V = (PrototypeSet[][])nuevoV.clone();
        }
        return V;
    }

    protected void fight(PrototypeSet classifier, PrototypeSet[][] V, double[] quality) {
        int i;
        for (i = 0; i < classifier.size(); ++i) {
            ((Prototype)classifier.get(i)).setIndex(i);
        }
        for (i = 0; i < classifier.size(); ++i) {
            PrototypeSet neighbors = KNN.getNearestNeighbors((Prototype)classifier.get(i), classifier, this.k);
            neighbors.remove((Prototype)classifier.get(i));
            double max = Double.MIN_VALUE;
            Prototype select = new Prototype();
            for (Prototype p : neighbors) {
                if (!(quality[i] - quality[p.getIndex()] > max)) continue;
                select = p;
                max = quality[i] - quality[p.getIndex()];
            }
            double aleatorio = RandomGenerator.Randint(0, 1);
            double si = ((Prototype)classifier.get(i)).getOutput(0);
            if (!(max < aleatorio)) continue;
            if (select.getOutput(0) != si) {
                V[i][(int)si].add(V[select.getIndex()][(int)si]);
                V[select.getIndex()][(int)si] = null;
                continue;
            }
            double limiteRuleta = quality[i] + quality[select.getIndex()];
            aleatorio = RandomGenerator.Randdouble(0.0, limiteRuleta);
            if (aleatorio < quality[i]) {
                V[i][(int)si].add(V[select.getIndex()][(int)si]);
                V[select.getIndex()][(int)si] = null;
                continue;
            }
            V[select.getIndex()][(int)si].add(V[i][(int)si]);
            V[i][(int)si] = null;
        }
    }

    protected void move(PrototypeSet classifier, PrototypeSet[][] V) {
        for (int i = 0; i < classifier.size(); ++i) {
            int clase = (int)((Prototype)classifier.get(i)).getOutput(0);
            if (V[i][clase].size() <= 0) continue;
            ((Prototype)classifier.get(i)).set(V[i][clase].avg());
        }
    }

    protected PrototypeSet die(PrototypeSet classifier, double[] quality) {
        double pDie = 0.0;
        boolean[] toClean = new boolean[classifier.size()];
        for (int j = 0; j < classifier.size(); ++j) {
            pDie = quality[j] > 0.5 ? 0.0 : 1.0 - 2.0 * quality[j];
            double aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
            toClean[j] = aleatorio < pDie;
        }
        PrototypeSet clean = new PrototypeSet();
        for (int i = 0; i < classifier.size(); ++i) {
            if (toClean[i]) continue;
            clean.add(classifier.get(i));
        }
        return clean;
    }

    PrototypeSet[] nearPrototype(PrototypeSet initial, PrototypeSet outputDataSet) {
        double dMin = Double.POSITIVE_INFINITY;
        PrototypeSet[] region = new PrototypeSet[outputDataSet.size()];
        Prototype nearest = null;
        for (int i = 0; i < outputDataSet.size(); ++i) {
            region[i] = new PrototypeSet();
            if (outputDataSet.get(i) == null) continue;
            ((Prototype)outputDataSet.get(i)).setIndex(i);
        }
        for (Prototype p : initial) {
            dMin = Double.POSITIVE_INFINITY;
            for (Prototype q : outputDataSet) {
                double d;
                if (q == null || !((d = Distance.d(q, p)) < dMin) || q == p) continue;
                dMin = d;
                nearest = q;
            }
            region[nearest.getIndex()].add(p);
        }
        return region;
    }

    PrototypeSet[][] nearPrototypeWithClass(PrototypeSet initial, PrototypeSet outputDataSet) {
        double dMin = Double.POSITIVE_INFINITY;
        PrototypeSet[][] region = new PrototypeSet[outputDataSet.size()][];
        Prototype nearest = null;
        for (int i = 0; i < outputDataSet.size(); ++i) {
            region[i] = new PrototypeSet[this.numberOfClass];
            for (int j = 0; j < this.numberOfClass; ++j) {
                region[i][j] = new PrototypeSet();
            }
            ((Prototype)outputDataSet.get(i)).setIndex(i);
        }
        for (Prototype p : initial) {
            dMin = Double.POSITIVE_INFINITY;
            for (Prototype q : outputDataSet) {
                double d = Distance.d(q, p);
                if (!(d < dMin) || q == p) continue;
                dMin = d;
                nearest = q;
            }
            region[nearest.getIndex()][(int)p.getOutput(0)].add(p);
        }
        return region;
    }

    @Override
    public PrototypeSet reduceSet() {
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of class " + this.numberOfClass);
        PrototypeSet outputDataSet = new PrototypeSet();
        int aleatory = RandomGenerator.Randint(0, this.trainingDataSet.size() - 1);
        outputDataSet.add(this.trainingDataSet.get(aleatory));
        PrototypeSet[] Sj = new PrototypeSet[this.numberOfClass];
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            int i;
            PrototypeSet[][] V = new PrototypeSet[outputDataSet.size()][];
            PrototypeSet[] R = new PrototypeSet[outputDataSet.size()];
            double[] accuracy = new double[outputDataSet.size()];
            double[] apportation = new double[outputDataSet.size()];
            double[] quality = new double[outputDataSet.size()];
            for (i = 0; i < this.numberOfClass; ++i) {
                Sj[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
            }
            R = this.nearPrototype(this.trainingDataSet, outputDataSet);
            V = this.nearPrototypeWithClass(this.trainingDataSet, outputDataSet);
            for (i = 0; i < outputDataSet.size(); ++i) {
                int clase = (int)((Prototype)outputDataSet.get(i)).getOutput(0);
                accuracy[i] = (double)V[i][clase].size() * 1.0 / (double)R[i].size();
                apportation[i] = (double)V[i][clase].size() / (this.expectation(clase, Sj[clase]) / 2.0);
                quality[i] = Math.min(1.0, accuracy[i] * apportation[i]);
            }
            int initialSize = outputDataSet.size();
            this.mutation(outputDataSet, V);
            V = this.reproduction(outputDataSet, V);
            if (outputDataSet.size() > initialSize) {
                int i2;
                accuracy = new double[outputDataSet.size()];
                apportation = new double[outputDataSet.size()];
                quality = new double[outputDataSet.size()];
                R = this.nearPrototype(this.trainingDataSet, outputDataSet);
                boolean[] toClean = new boolean[R.length];
                for (int j = 0; j < R.length; ++j) {
                    toClean[j] = R[j].size() == 0;
                }
                PrototypeSet clean = new PrototypeSet();
                for (i2 = 0; i2 < outputDataSet.size(); ++i2) {
                    if (toClean[i2]) continue;
                    clean.add(outputDataSet.get(i2));
                }
                outputDataSet = new PrototypeSet(clean);
                R = this.nearPrototype(this.trainingDataSet, outputDataSet);
                V = this.nearPrototypeWithClass(this.trainingDataSet, outputDataSet);
                for (i2 = 0; i2 < outputDataSet.size(); ++i2) {
                    int clase = (int)((Prototype)outputDataSet.get(i2)).getOutput(0);
                    if (V[i2][clase] != null) {
                        accuracy[i2] = (double)V[i2][clase].size() * 1.0 / (double)R[i2].size();
                        apportation[i2] = (double)V[i2][clase].size() / (this.expectation(clase, Sj[clase]) / 2.0);
                    } else {
                        accuracy[i2] = 0.0;
                        apportation[i2] = 0.0;
                    }
                    quality[i2] = Math.min(1.0, accuracy[i2] * apportation[i2]);
                }
            }
            this.fight(outputDataSet, V, quality);
            this.move(outputDataSet, V);
            outputDataSet = new PrototypeSet(this.die(outputDataSet, quality));
        }
        System.out.println("Accuracy % " + ENPCGenerator.accuracy(outputDataSet, this.trainingDataSet));
        System.out.println("Reduction % " + (100 - outputDataSet.size() * 100 / this.trainingDataSet.size()));
        return outputDataSet;
    }

    public static void main(String[] args) {
        Parameters.setUse("ENPC", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        ENPCGenerator.setSeed(seed);
        int blocks = Parameters.assertExtendedArgAsInt(args, 10, "number of blocks", 1.0, 2.147483647E9);
        ENPCGenerator generator = new ENPCGenerator(training, 3, 250);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

