/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet;

import java.util.ArrayList;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputNeuron;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class InputLayer
implements ILayer<InputNeuron> {
    protected static final XmlFormat<InputLayer> XML = new XmlFormat<InputLayer>(InputLayer.class){

        @Override
        public void format(InputLayer source, XmlElement xml) {
            xml.setAttribute("max-n-of-neurons", source.maxnofneurons);
            xml.add(source.neurons, "neurons");
        }

        @Override
        public InputLayer parse(XmlElement xml) {
            InputLayer result = (InputLayer)xml.object();
            result.maxnofneurons = xml.getAttribute("max-n-of-neurons", 1);
            result.neurons = (ArrayList)xml.get("neurons");
            return result;
        }

        @Override
        public String defaultName() {
            return "input-layer";
        }
    };
    private static final long serialVersionUID = -4960947669851010992L;
    protected int maxnofneurons;
    protected ArrayList<InputNeuron> neurons = new ArrayList();

    @Override
    public int getMaxnofneurons() {
        return this.maxnofneurons;
    }

    public void setMaxnofneurons(int maxnofneurons) {
        this.maxnofneurons = maxnofneurons;
        if (this.neurons != null) {
            this.neurons.clear();
        }
        for (int i = 0; i < maxnofneurons; ++i) {
            InputNeuron iNeuron = new InputNeuron();
            iNeuron.setIndex(i);
            this.addNeuron(iNeuron);
        }
    }

    @Override
    public void addNeuron(InputNeuron neuron) {
        this.neurons.add(neuron);
    }

    @Override
    public InputNeuron getNeuron(int index) {
        return this.neurons.get(index);
    }

    @Override
    public int getNofneurons() {
        return this.neurons.size();
    }

    public int indexOf(InputNeuron neuron) {
        return this.neurons.indexOf(neuron);
    }

    @Override
    public boolean equals(ILayer<InputNeuron> other) {
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(41, 43);
        for (INeuron iNeuron : this.neurons) {
            hcb.append(iNeuron);
        }
        return hcb.toHashCode();
    }

    public InputLayer copy() {
        InputLayer result = new InputLayer();
        result.setMaxnofneurons(this.maxnofneurons);
        return result;
    }
}

