/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.Pearson6Dist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class Pearson6Gen
extends RandomVariateGen {
    protected double alpha1;
    protected double alpha2;
    protected double beta;

    public Pearson6Gen(RandomStream s, double alpha1, double alpha2, double beta) {
        super(s, new Pearson6Dist(alpha1, alpha2, beta));
        this.setParams(alpha1, alpha2, beta);
    }

    public Pearson6Gen(RandomStream s, double alpha1, double alpha2) {
        this(s, alpha1, alpha2, 1.0);
    }

    public Pearson6Gen(RandomStream s, Pearson6Dist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha1(), dist.getAlpha2(), dist.getBeta());
        }
    }

    public static double nextDouble(RandomStream s, double alpha1, double alpha2, double beta) {
        return Pearson6Dist.inverseF(alpha1, alpha2, beta, s.nextDouble());
    }

    public double getAlpha1() {
        return this.alpha1;
    }

    public double getAlpha2() {
        return this.alpha2;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double alpha1, double alpha2, double beta) {
        if (alpha1 <= 0.0) {
            throw new IllegalArgumentException("alpha1 <= 0");
        }
        if (alpha2 <= 0.0) {
            throw new IllegalArgumentException("alpha2 <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.beta = beta;
    }
}

