/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkSampleStream
extends FilterObjectStream<String, ChunkSample> {
    public ChunkSampleStream(ObjectStream<String> samples) {
        super(samples);
    }

    @Override
    public ChunkSample read() throws IOException {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        String line = (String)this.samples.read();
        while (line != null && !line.equals("")) {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                System.err.println("Skipping corrupt line: " + line);
            } else {
                toks.add(parts[0]);
                tags.add(parts[1]);
                preds.add(parts[2]);
            }
            line = (String)this.samples.read();
        }
        if (toks.size() > 0) {
            return new ChunkSample(toks.toArray(new String[toks.size()]), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]));
        }
        return null;
    }
}

