/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class BasicDialog
extends JDialog {
    protected JPanel toolbar;
    private JPanel mainPanel;
    private JButton ok;
    private JButton cancel;
    private boolean cancelled = true;

    public BasicDialog(Window window, String string, Dialog.ModalityType modalityType) {
        super(window, string, modalityType);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(this.mainPanel);
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        this.mainPanel.add((Component)jPanel, "South");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasicDialog.this.onOk();
                    BasicDialog.this.cancelled = false;
                    BasicDialog.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(BasicDialog.this, exception.getMessage(), ResourceManager.getString((Object)ResourceKey.ERROR), 0);
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicDialog.this.dispose();
            }
        });
        this.mainPanel.add(this.getCenterComponent(), "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                BasicDialog.this.onDialogShowing();
            }
        });
        this.pack();
    }

    public void enableAction(boolean bl) {
        this.ok.setEnabled(bl);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected void onDialogShowing() {
    }

    protected abstract Component getCenterComponent();

    protected abstract void onOk() throws Exception;
}

