% Generated by roxygen2: do not edit by hand
\name{apply}
\alias{apply}
\title{Apply Over Array Margin(s)}
\arguments{
  \item{X}{an array}
  \item{MARGIN}{which subscript(s) of X to apply over, a vector}
  \item{FUN}{the function to apply over X}
  \item{...}{additional arguments to FUN (optional)
}
}

\details{
Calculate row and column sums of a matrix
\code{
(A <- matrix(1:9, ncol = 3))
apply(A, MARGIN = 2, FUN = sum) # column sums
apply(A, MARGIN = 1, FUN = sum) # row sums
}

Apply over multiple subscripts
\code{
Matrices <- array(rnorm(9 * 100), dim = c(3, 3, 100))
apply(Matrices, 1:2, mean)
}

Provide additional arguments to FUN
\code{apply(Matrices, 1:2, mean, trim = .25)}

Return unsimplified list
\code{
B <- matrix(rpois(100, rep(1:10, times = 10)), ncol = 10)
apply(B, 1, range, simplify = FALSE)
}}

