% Generated by roxygen2: do not edit by hand
\name{tapply}
\alias{tapply}
\title{Apply Over a Ragged Array}
\arguments{
  \item{X}{an object}
  \item{INDEX}{a (list of) factor(s), each the same length as X}
  \item{FUN}{the function to apply over X}
  \item{...}{additional arguments to FUN (optional)
}
}

\details{
Summarize y according to groups defined by x1
\code{
x1 <- factor(sample(c("ctrl", "trt"), size = 200, replace = TRUE))
y <- 5 * (x1 == "trt") + rnorm(200)
tapply(y, x1, mean)
}

Summarize y according to groups defined by x1 and x2
\code{
x2 <- factor(rep(c("A", "B"), times = 100))
tapply(y, list(x1, x2), mean)
}

Supply additional arguments to FUN via ...
\code{
tapply(y, x1, mean, trim = .25)
tapply(y, list(x1, x2), mean, trim = .25)
}

}

