/*
 * Decompiled with CFR 0.152.
 */
package epp;

import epp.EvolutionPP;
import epp.ParametrePP;
import epp.reportToR;
import ihm.Bienvenue;
import ihm.Ihm;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javalain.math.PseudoRandomNumbers;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import math.Matrice;
import util.FileUtils;
import util.MsgUtils;

public class EPPLab {
    public static final String nom = "EPP-Lab";
    private static final String name = "epplab";
    public static ResourceBundle msg = ResourceBundle.getBundle("ihm/MessagesBundle");
    private static int pos_x;
    private static int pos_y;
    public static String result;
    public Matrice dataMatrix;
    public static int dataRows;
    public static int dataCols;
    public static double[] dataValues;
    public static boolean runsInR;

    public static void setResult(String putThis) {
        result = putThis;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        final ParametrePP p = new ParametrePP();
        final EvolutionPP e = new EvolutionPP(p);
        if (args.length != 0 && args[0].equals("noIhm")) {
            p.setRepDonnees("/home/medafi/temp");
            p.setRepSortie("/home/medafi/temp/sortie");
            p.nbSimulation = 10;
            p.sphere = true;
            String copie = p.rep_donnees + File.separatorChar + "copie";
            File fc = new File(copie);
            if (!fc.exists()) {
                fc.mkdir();
            }
            while (true) {
                File f = new File(p.rep_donnees);
                Vector<String> v = FileUtils.listeFichiers(f);
                for (int i = 0; i < v.size(); ++i) {
                    p.ficherDeDonnees = v.get(i);
                    p.nomIndice = "Friedman";
                    p.methode = "Genetic Algorithm";
                    p.setNbIndividus(50);
                    p.setNbIterations(20);
                    e.setEtat(1);
                    EvolutionPP.attendre(e);
                    p.methode = "Particule Swarm Optimization";
                    p.setNbIndividus(20);
                    p.setNbIterations(50);
                    e.setEtat(1);
                    EvolutionPP.attendre(e);
                    p.methode = "Tribes";
                    p.setNbIndividus(20);
                    p.setNbIterations(100);
                    e.setEtat(1);
                    EvolutionPP.attendre(e);
                    File src = new File(p.rep_donnees + File.separatorChar + p.ficherDeDonnees);
                    System.out.println(src);
                    File dest = new File(copie + File.separatorChar + p.ficherDeDonnees);
                    System.out.println(dest);
                    src.renameTo(dest);
                }
                Thread.sleep(10L);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!EPPLab.loadPrefs(p)) {
                    Bienvenue bienvenue = new Bienvenue(e, p);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension size = bienvenue.getSize();
                    bienvenue.setLocation((screenSize.width - size.width) / 3, (screenSize.height - size.height) / 3);
                    bienvenue.pack();
                    bienvenue.setVisible(true);
                } else {
                    new Ihm(pos_x, pos_y, e, p);
                }
            }
        });
    }

    public static boolean loadPrefs(ParametrePP parametre) {
        Properties p = new Properties();
        try {
            FileInputStream fis = new FileInputStream(System.getProperty("user.home") + File.separatorChar + "." + name + File.separatorChar + name + ".ini");
            p.loadFromXML(fis);
            fis.close();
            pos_x = Integer.parseInt(p.getProperty("position_fenetre_x", "0"));
            pos_y = Integer.parseInt(p.getProperty("position_fenetre_y", "0"));
            String dir_work = p.getProperty("repertoire_de_travail");
            File f = new File(dir_work);
            if (!f.exists()) {
                throw new FileNotFoundException();
            }
            parametre.updatePath(p.getProperty("repertoire_de_travail"));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void savePrefs(ParametrePP parametre, int pos_x, int pos_y) {
        Properties p = new Properties();
        try {
            p.setProperty("version", "0");
            p.setProperty("position_fenetre_x", "" + pos_x);
            p.setProperty("position_fenetre_y", "" + pos_y);
            p.setProperty("repertoire_de_travail", parametre.rep_travail);
            File f = new File(System.getProperty("user.home") + File.separatorChar + "." + name);
            if (!f.exists()) {
                f.mkdir();
            }
            FileOutputStream fos = new FileOutputStream(System.getProperty("user.home") + File.separatorChar + "." + name + File.separatorChar + name + ".ini");
            p.storeToXML(fos, "Pr\u00e9f\u00e9rences de l'utilisateur pour EPP-Lab");
            fos.close();
        }
        catch (IOException e) {
            MsgUtils.erreurAndExit(null, "Erreur lors de l'enregistrement des pr\u00e9f\u00e9rences de l'utilisateur.", "Erreur");
        }
    }

    public static String test(double chooseIndex) throws Exception {
        String inPut = "Hallo " + chooseIndex;
        return inPut;
    }

    public static String eppLabRInterface(double chooseIndex, double nSimulation, String alg, double iter, double tPara, double dRows, double dCols, double[] data, double seed, double step_iter, double eps) throws Exception {
        long seedCasted = (long)seed;
        PseudoRandomNumbers.createGenerator(seedCasted);
        int iterations = (int)iter;
        int individuals = (int)tPara;
        int stepIter = (int)step_iter;
        runsInR = true;
        dataRows = (int)dRows;
        dataCols = (int)dCols;
        dataValues = new double[dataRows * dataCols];
        System.arraycopy(data, 0, dataValues, 0, dataRows * dataCols);
        ParametrePP p = new ParametrePP();
        EvolutionPP e = new EvolutionPP(p);
        p.nbSimulation = (int)nSimulation;
        p.sphere = false;
        p.step_iter = stepIter;
        p.eps = eps;
        p.ficherDeDonnees = "olive.txt";
        if (chooseIndex == 1.0) {
            p.nomIndice = "Kurtosis Max";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                System.out.println(p);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                System.out.println(p);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        } else if (chooseIndex == 2.0) {
            p.nomIndice = "Friedman";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        } else if (chooseIndex == 3.0) {
            p.nomIndice = "Discriminant";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        } else if (chooseIndex == 4.0) {
            p.nomIndice = "Friedman Tukey";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        } else if (chooseIndex == 5.0) {
            p.nomIndice = "Kurtosis Min";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        } else if (chooseIndex == 6.0) {
            p.nomIndice = "Indice 4";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        } else if (chooseIndex == 7.0) {
            p.nomIndice = "Stahel Donoho";
            if (alg.equals("GA")) {
                p.methode = "Genetic Algorithm";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("PSO")) {
                p.methode = "Particule Swarm Optimization";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
            if (alg.equals("Tribe")) {
                p.methode = "Tribes";
                p.setNbIndividus(individuals);
                p.setNbIterations(iterations);
                e.setEtat(1);
                EvolutionPP.attendre(e);
            }
        }
        EPPLab.setResult(reportToR.getResult());
        PseudoRandomNumbers.destroyGenerator();
        return result;
    }

    static {
        runsInR = false;
    }
}

