/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.DROP3PSO;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Algorithms.Preprocess.Basic.Referencia;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;

public class DROP3PSO
extends Metodo {
    private int k;
    private double semilla;
    public String Script;
    private PrototypeSet trainingDataSet;
    private PrototypeGenerator generador;
    private int SwarmSize;
    private int ParticleSize;
    private int MaxIter;
    private double C1;
    private double C2;
    private double VMax;
    private double Wstart;
    private double Wend;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    protected int numberOfStrategies;

    public DROP3PSO(String ficheroScript) {
        super(ficheroScript);
    }

    public static PrototypeSet readPrototypeSet(String nameOfFile) {
        Attributes.clearAll();
        InstanceSet training = new InstanceSet();
        try {
            training.readSet(nameOfFile, true);
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    public static Prototype _1nn(Prototype current, PrototypeSet dataSet) {
        Prototype nearestNeighbor = (Prototype)dataSet.get(0);
        int indexNN = 0;
        double minDist = Double.POSITIVE_INFINITY;
        int _size = dataSet.size();
        for (int i = 0; i < _size; ++i) {
            Prototype pi = (Prototype)dataSet.get(i);
            double currDist = Distance.euclideanDistance(pi, current);
            if (!(currDist > 0.0) || !(currDist < minDist)) continue;
            minDist = currDist;
            indexNN = i;
        }
        return (Prototype)dataSet.get(indexNN);
    }

    public double classficationAccuracy1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = DROP3PSO._1nn(p, training);
            if (p.getOutput(0) != nearestNeighbor.getOutput(0)) continue;
            ++wellClassificated;
        }
        return 100.0 * ((double)wellClassificated / (double)test.size());
    }

    public PrototypeSet reduceSet(PrototypeSet initial) {
        int k;
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        PrototypeSet[] population = new PrototypeSet[this.SwarmSize];
        PrototypeSet[] mejorPosicion = new PrototypeSet[this.SwarmSize];
        PrototypeSet nominalPopulation = new PrototypeSet();
        double[] fitness = new double[this.SwarmSize];
        double[] fitness_bestPopulation = new double[this.SwarmSize];
        PrototypeSet bestParticle = new PrototypeSet();
        double inertia = (this.Wstart - this.Wend) * (double)this.MaxIter / ((double)this.MaxIter + this.Wend);
        boolean mejorParticula = false;
        population[0] = new PrototypeSet(initial);
        this.generador = new PrototypeGenerator(this.trainingDataSet);
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[0]);
        fitness[0] = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.println("Best initial fitness = " + fitness[0]);
        fitness_bestPopulation[0] = fitness[0];
        for (int i = 1; i < this.SwarmSize; ++i) {
            population[i] = new PrototypeSet();
            for (int j = 0; j < population[0].size(); ++j) {
                Prototype aux = new Prototype(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
                population[i].add(aux);
            }
            nominalPopulation = new PrototypeSet();
            nominalPopulation.formatear(population[i]);
            fitness[i] = this.classficationAccuracy1NN(population[i], this.trainingDataSet);
            fitness_bestPopulation[i] = fitness[i];
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i = 1; i < this.SwarmSize; ++i) {
            if (!(fitness[i] > bestFitness)) continue;
            bestFitness = fitness[i];
            bestFitnessIndex = i;
        }
        for (int j = 0; j < this.SwarmSize; ++j) {
            mejorPosicion[j] = population[j].clone();
            for (int i = 0; i < population[j].size(); ++i) {
                ((Prototype)population[j].get(i)).setIndex(i);
            }
        }
        double[][][] velocidad = new double[this.SwarmSize][][];
        int num_atribs = ((Prototype)population[0].get(0)).numberOfInputs();
        for (int i = 0; i < this.SwarmSize; ++i) {
            velocidad[i] = new double[population[0].size()][];
            for (int j = 0; j < population[0].size(); ++j) {
                velocidad[i][j] = new double[num_atribs];
                for (k = 0; k < num_atribs; ++k) {
                    velocidad[i][j][k] = RandomGenerator.Randdouble(-this.VMax, this.VMax) * 1.0;
                }
            }
        }
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            int i;
            for (i = 0; i < this.SwarmSize; ++i) {
                for (k = 0; k < population[i].size(); ++k) {
                    Prototype resta = ((Prototype)mejorPosicion[i].get(k)).sub((Prototype)population[i].get(k));
                    Prototype restaBestParticle = ((Prototype)mejorPosicion[bestFitnessIndex].get(k)).sub((Prototype)population[i].get(k));
                    for (int j = 0; j < num_atribs; ++j) {
                        velocidad[i][k][j] = inertia * velocidad[i][k][j];
                        double aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                        double[] dArray = velocidad[i][k];
                        int n = j;
                        dArray[n] = dArray[n] + this.C1 * aleatorio * resta.getInput(j);
                        aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                        double[] dArray2 = velocidad[i][k];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + this.C2 * aleatorio * restaBestParticle.getInput(j);
                        if (velocidad[i][k][j] > this.VMax) {
                            velocidad[i][k][j] = this.VMax;
                        } else if (velocidad[i][k][j] < -this.VMax) {
                            velocidad[i][k][j] = -this.VMax;
                        }
                        double suma = ((Prototype)population[i].get(k)).getInput(j) + velocidad[i][k][j] * 1.0;
                        ((Prototype)population[i].get(k)).setInput(j, suma);
                        ((Prototype)population[i].get(k)).applyThresholds();
                    }
                }
            }
            for (i = 0; i < this.SwarmSize; ++i) {
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i]);
                fitness[i] = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
            }
            for (i = 0; i < this.SwarmSize; ++i) {
                if (fitness[i] > bestFitness) {
                    bestFitness = fitness[i];
                    bestFitnessIndex = i;
                }
                if (!(fitness[i] > fitness_bestPopulation[i])) continue;
                fitness_bestPopulation[i] = fitness[i];
                mejorPosicion[i] = population[i].clone();
            }
            inertia = (this.Wstart - this.Wend) * (double)(this.MaxIter - iter) / ((double)this.MaxIter + this.Wend);
        }
        System.err.println("Best Fitness " + bestFitness);
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(mejorPosicion[bestFitnessIndex]);
        System.err.println("\n% de acierto en training Nominal " + this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet));
        return nominalPopulation;
    }

    public void ejecutar() {
        int m;
        int l;
        int[] clasesS;
        boolean[][] conjM;
        int[][] conjN;
        double[][] conjR;
        double[][] conjS;
        double dist;
        int j;
        int claseObt;
        int i;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        boolean[] marcas = new boolean[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
        }
        int nSel = this.datosTrain.length;
        for (i = 0; i < this.datosTrain.length; ++i) {
            claseObt = KNN.evaluacionKNN2((int)this.k, (double[][])this.datosTrain, (double[][])this.realTrain, (int[][])this.nominalTrain, (boolean[][])this.nulosTrain, (int[])this.clasesTrain, (double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (int)nClases, (boolean)this.distanceEu);
            if (claseObt == this.clasesTrain[i]) continue;
            marcas[i] = false;
            --nSel;
        }
        Object[] orden = new Referencia[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            double bestD = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.datosTrain.length; ++j) {
                if (this.clasesTrain[i] == this.clasesTrain[j] || !((dist = KNN.distancia((double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (double[])this.datosTrain[j], (double[])this.realTrain[j], (int[])this.nominalTrain[j], (boolean[])this.nulosTrain[j], (boolean)this.distanceEu)) < bestD)) continue;
                bestD = dist;
            }
            orden[i] = new Referencia(i, bestD);
        }
        Arrays.sort(orden);
        double[] distTemp = new double[this.k + 1];
        int[] vecinosTemp = new int[this.k + 1];
        int[][] vecinos = new int[this.datosTrain.length][this.k + 1];
        Vector[] asociados = new Vector[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            asociados[i] = new Vector();
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            KNN.evaluacionKNN2((int)(this.k + 1), (double[][])this.datosTrain, (double[][])this.realTrain, (int[][])this.nominalTrain, (boolean[][])this.nulosTrain, (int[])this.clasesTrain, (double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (int)nClases, (boolean)this.distanceEu, (int[])vecinos[i]);
            for (j = 0; j < vecinos[i].length; ++j) {
                if (vecinos[i][j] < 0) continue;
                asociados[vecinos[i][j]].addElement(new Referencia(i, 0.0));
            }
        }
        for (int o = 0; o < this.datosTrain.length; ++o) {
            i = ((Referencia)orden[o]).entero;
            if (!marcas[i]) continue;
            int aciertosSin = 0;
            marcas[i] = false;
            conjS = new double[--nSel][this.datosTrain[0].length];
            conjR = new double[nSel][this.datosTrain[0].length];
            conjN = new int[nSel][this.datosTrain[0].length];
            conjM = new boolean[nSel][this.datosTrain[0].length];
            clasesS = new int[nSel];
            l = 0;
            for (m = 0; m < this.datosTrain.length; ++m) {
                if (!marcas[m]) continue;
                for (j = 0; j < this.datosTrain[0].length; ++j) {
                    conjS[l][j] = this.datosTrain[m][j];
                    conjR[l][j] = this.realTrain[m][j];
                    conjN[l][j] = this.nominalTrain[m][j];
                    conjM[l][j] = this.nulosTrain[m][j];
                }
                clasesS[l] = this.clasesTrain[m];
                ++l;
            }
            marcas[i] = true;
            ++nSel;
            for (j = 0; j < this.k + 1; ++j) {
                if (vecinos[i][j] < 0 || (claseObt = KNN.evaluacionKNN2((int)this.k, (double[][])conjS, (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (double[])this.datosTrain[vecinos[i][j]], (double[])this.realTrain[vecinos[i][j]], (int[])this.nominalTrain[vecinos[i][j]], (boolean[])this.nulosTrain[vecinos[i][j]], (int)nClases, (boolean)this.distanceEu)) != this.clasesTrain[vecinos[i][j]]) continue;
                ++aciertosSin;
            }
            int mayoria = (this.k + 1) / 2;
            if (aciertosSin <= mayoria) continue;
            marcas[i] = false;
            --nSel;
            for (j = 0; j < asociados[i].size(); ++j) {
                boolean parar;
                for (l = 0; l < this.k + 1; ++l) {
                    vecinosTemp[l] = vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][l];
                    vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][l] = -1;
                    distTemp[l] = Double.POSITIVE_INFINITY;
                }
                for (l = 0; l < this.datosTrain.length; ++l) {
                    if (!marcas[l]) continue;
                    dist = KNN.distancia((double[])this.datosTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (double[])this.realTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (int[])this.nominalTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (boolean[])this.nulosTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (double[])this.datosTrain[l], (double[])this.realTrain[l], (int[])this.nominalTrain[l], (boolean[])this.nulosTrain[l], (boolean)this.distanceEu);
                    parar = false;
                    for (m = 0; m < this.k + 1 && !parar; ++m) {
                        if (!(dist < distTemp[m])) continue;
                        parar = true;
                        for (int n = m + 1; n < this.k + 1; ++n) {
                            distTemp[n] = distTemp[n - 1];
                            vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][n] = vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][n - 1];
                        }
                        distTemp[m] = dist;
                        vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][m] = l;
                    }
                }
                for (l = 0; l < this.k + 1; ++l) {
                    parar = false;
                    for (m = 0; m < asociados[vecinosTemp[l]].size() && !parar; ++m) {
                        if (((Referencia)asociados[vecinosTemp[l]].elementAt((int)m)).entero != ((Referencia)asociados[i].elementAt((int)j)).entero || vecinosTemp[l] == i) continue;
                        asociados[vecinosTemp[l]].removeElementAt(m);
                        parar = true;
                    }
                }
                for (l = 0; l < this.k + 1; ++l) {
                    asociados[vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][l]].addElement(new Referencia(((Referencia)asociados[i].elementAt((int)j)).entero, 0.0));
                }
            }
        }
        conjS = new double[nSel][this.datosTrain[0].length];
        conjR = new double[nSel][this.datosTrain[0].length];
        conjN = new int[nSel][this.datosTrain[0].length];
        conjM = new boolean[nSel][this.datosTrain[0].length];
        clasesS = new int[nSel];
        l = 0;
        for (m = 0; m < this.datosTrain.length; ++m) {
            if (!marcas[m]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[m][j];
                conjR[l][j] = this.realTrain[m][j];
                conjN[l][j] = this.nominalTrain[m][j];
                conjM[l][j] = this.nulosTrain[m][j];
            }
            clasesS[l] = this.clasesTrain[m];
            ++l;
        }
        System.out.println("DROP3 " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida((String)this.ficheroSalida[0], (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        OutputIS.escribeSalida((String)this.ficheroSalida[1], (InstanceSet)this.test, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        Parameters.assertBasicArgs(this.ficheroSalida);
        PrototypeGenerationAlgorithm.readParametersFile(this.Script);
        PrototypeGenerationAlgorithm.printParameters();
        PrototypeSet training = DROP3PSO.readPrototypeSet(this.ficheroSalida[0]);
        this.trainingDataSet = DROP3PSO.readPrototypeSet(this.ficheroTraining);
        PrototypeSet SADE = this.reduceSet(training);
        SADE.save(this.ficheroSalida[0]);
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate((double[])this.datosTrain[i], (double[][])SADE.prototypeSetTodouble(), (int)nClases, (int[])SADE.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[0], (int[][])trainRealClass, (int[][])trainPrediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate((double[])this.datosTest[i], (double[][])SADE.prototypeSetTodouble(), (int)nClases, (int[])SADE.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[1], (int[][])realClass, (int[][])prediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
    }

    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.SwarmSize = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.MaxIter = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.C1 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.C2 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.VMax = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.Wstart = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.Wend = Double.parseDouble(tokens.nextToken().substring(1));
        System.out.print("\nIsaac dice:   Swar= " + this.SwarmSize + " Maxiter= " + this.MaxIter + " Wend=  " + this.Wend + "\n");
    }
}

