/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Selection.CHC;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Instance_Selection.CHC.Cromosoma;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import org.core.Fichero;
import org.core.Randomize;

public class CHC
extends Metodo {
    private long semilla;
    private int tamPoblacion;
    private int nEval;
    private double alfa;
    private double r;
    private double prob0to1Rec;
    private double prob0to1Div;
    private int kNeigh;

    public CHC(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        int j;
        int l;
        int i;
        int nSel = 0;
        int ev = 0;
        int d = this.datosTrain.length / 4;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        Randomize.setSeed(this.semilla);
        Object[] poblacion = new Cromosoma[this.tamPoblacion];
        int[] baraje = new int[this.tamPoblacion];
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i] = new Cromosoma(this.datosTrain.length);
        }
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.alfa, this.kNeigh, nClases, this.distanceEu);
        }
        while (ev < this.nEval) {
            Cromosoma[] C = new Cromosoma[this.tamPoblacion];
            for (i = 0; i < this.tamPoblacion; ++i) {
                baraje[i] = i;
            }
            for (i = 0; i < this.tamPoblacion; ++i) {
                int pos = Randomize.Randint(i, this.tamPoblacion - 1);
                int tmp = baraje[i];
                baraje[i] = baraje[pos];
                baraje[pos] = tmp;
            }
            for (i = 0; i < this.tamPoblacion; ++i) {
                C[i] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[baraje[i]]);
            }
            int tamC = this.recombinar(C, d);
            Object[] newPob = new Cromosoma[tamC];
            l = 0;
            for (i = 0; i < C.length; ++i) {
                if (!C[i].esValido()) continue;
                newPob[l] = new Cromosoma(this.datosTrain.length, C[i]);
                ++l;
            }
            for (i = 0; i < newPob.length; ++i) {
                newPob[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.alfa, this.kNeigh, nClases, this.distanceEu);
                ++ev;
            }
            Arrays.sort(poblacion);
            Arrays.sort(newPob);
            if (tamC == 0 || ((Cromosoma)newPob[0]).getCalidad() < ((Cromosoma)poblacion[this.tamPoblacion - 1]).getCalidad()) {
                --d;
            } else {
                Cromosoma[] pobTemp = new Cromosoma[this.tamPoblacion];
                j = 0;
                int k = 0;
                for (i = 0; i < this.tamPoblacion && k < tamC; ++i) {
                    if (((Cromosoma)poblacion[j]).getCalidad() > ((Cromosoma)newPob[k]).getCalidad()) {
                        pobTemp[i] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[j]);
                        ++j;
                        continue;
                    }
                    pobTemp[i] = new Cromosoma(this.datosTrain.length, (Cromosoma)newPob[k]);
                    ++k;
                }
                if (k == tamC) {
                    while (i < this.tamPoblacion) {
                        pobTemp[i] = new Cromosoma(this.datosTrain.length, (Cromosoma)poblacion[j]);
                        ++j;
                        ++i;
                    }
                }
                poblacion = pobTemp;
            }
            if (d >= 0) continue;
            for (i = 1; i < this.tamPoblacion; ++i) {
                ((Cromosoma)poblacion[i]).divergeCHC(this.r, (Cromosoma)poblacion[0], this.prob0to1Div);
            }
            for (i = 0; i < this.tamPoblacion; ++i) {
                if (((Cromosoma)poblacion[i]).estaEvaluado()) continue;
                ((Cromosoma)poblacion[i]).evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.alfa, this.kNeigh, nClases, this.distanceEu);
                ++ev;
            }
            d = (int)(this.r * (1.0 - this.r) * (double)this.datosTrain.length);
        }
        Arrays.sort(poblacion);
        nSel = ((Cromosoma)poblacion[0]).genesActivos();
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!((Cromosoma)poblacion[0]).getGen(i)) continue;
            for (j = 0; j < this.datosTrain[i].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("CHC " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        String Subset = new String(this.ficheroSalida[0].substring(11, this.ficheroSalida[0].length()));
        Subset = "../datasets/" + Subset;
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate(this.datosTrain[i], conjS, nClases, clasesS, this.kNeigh);
        }
        KNN.writeOutput(this.ficheroSalida[0], trainRealClass, trainPrediction, this.entradas, this.salida, this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate(this.datosTest[i], conjS, nClases, clasesS, this.kNeigh);
        }
        KNN.writeOutput(this.ficheroSalida[1], realClass, prediction, this.entradas, this.salida, this.relation);
    }

    private int recombinar(Cromosoma[] C, int d) {
        int tamC = 0;
        for (int i = 0; i < C.length / 2; ++i) {
            int j;
            int distHamming = 0;
            for (j = 0; j < this.datosTrain.length; ++j) {
                if (C[i * 2].getGen(j) == C[i * 2 + 1].getGen(j)) continue;
                ++distHamming;
            }
            if (distHamming / 2 > d) {
                for (j = 0; j < this.datosTrain.length; ++j) {
                    if (C[i * 2].getGen(j) == C[i * 2 + 1].getGen(j) || !(Randomize.Rand() < 0.5)) continue;
                    if (C[i * 2].getGen(j)) {
                        C[i * 2].setGen(j, false);
                    } else if (Randomize.Rand() < this.prob0to1Rec) {
                        C[i * 2].setGen(j, true);
                    }
                    if (C[i * 2 + 1].getGen(j)) {
                        C[i * 2 + 1].setGen(j, false);
                        continue;
                    }
                    if (!(Randomize.Rand() < this.prob0to1Rec)) continue;
                    C[i * 2 + 1].setGen(j, true);
                }
                tamC += 2;
                continue;
            }
            C[i * 2].borrar();
            C[i * 2 + 1].borrar();
        }
        return tamC;
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.tamPoblacion = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.nEval = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.alfa = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.r = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.prob0to1Rec = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.prob0to1Div = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.kNeigh = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

