/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Selection.CHC;

import keel.Algorithms.Preprocess.Basic.KNN;
import org.core.Randomize;

public class Cromosoma
implements Comparable {
    boolean[] cuerpo;
    double calidad;
    boolean cruzado;
    boolean valido;
    double errorRate;

    public Cromosoma(int size) {
        this.cuerpo = new boolean[size];
        for (int i = 0; i < size; ++i) {
            double u = Randomize.Rand();
            this.cuerpo[i] = !(u < 0.5);
        }
        this.cruzado = true;
        this.valido = true;
    }

    public Cromosoma(int size, Cromosoma a) {
        this.cuerpo = new boolean[size];
        for (int i = 0; i < this.cuerpo.length; ++i) {
            this.cuerpo[i] = a.getGen(i);
        }
        this.calidad = a.getCalidad();
        this.cruzado = false;
        this.valido = true;
    }

    public Cromosoma(boolean[] datos) {
        this.cuerpo = new boolean[datos.length];
        for (int i = 0; i < datos.length; ++i) {
            this.cuerpo[i] = datos[i];
        }
        this.cruzado = true;
        this.valido = true;
    }

    public boolean getGen(int indice) {
        return this.cuerpo[indice];
    }

    public double getCalidad() {
        return this.calidad;
    }

    public void setGen(int indice, boolean valor) {
        this.cuerpo[indice] = valor;
    }

    public void evalua(double[][] datos, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double alfa, int kNeigh, int nClases, boolean distanceEu) {
        int aciertos = 0;
        double M = datos.length;
        double s = this.genesActivos();
        if (kNeigh > 1) {
            int[] vecinos = new int[kNeigh];
            double[][] conjS = new double[(int)s][datos[0].length];
            double[][] conjR = new double[(int)s][datos[0].length];
            int[][] conjN = new int[(int)s][datos[0].length];
            boolean[][] conjM = new boolean[(int)s][datos[0].length];
            int[] clasesS = new int[(int)s];
            int l = 0;
            for (int j = 0; j < datos.length; ++j) {
                if (!this.cuerpo[j]) continue;
                for (int m = 0; m < datos[j].length; ++m) {
                    conjS[l][m] = datos[j][m];
                    conjR[l][m] = real[j][m];
                    conjN[l][m] = nominal[j][m];
                    conjM[l][m] = nulos[j][m];
                }
                clasesS[l] = clases[j];
                ++l;
            }
            for (int i = 0; i < datos.length; ++i) {
                int claseObt = KNN.evaluacionKNN2(kNeigh, conjS, conjR, conjN, conjM, clasesS, datos[i], real[i], nominal[i], nulos[i], nClases, distanceEu, vecinos);
                if (claseObt < 0 || clases[i] != claseObt) continue;
                ++aciertos;
            }
        } else {
            for (int i = 0; i < datos.length; ++i) {
                int vecinoCercano = -1;
                double minDist = Double.POSITIVE_INFINITY;
                for (int j = 0; j < datos.length; ++j) {
                    double dist;
                    if (!this.cuerpo[j] || !((dist = KNN.distancia(datos[i], real[i], nominal[i], nulos[i], datos[j], real[j], nominal[j], nulos[j], distanceEu)) < minDist) || dist == 0.0) continue;
                    minDist = dist;
                    vecinoCercano = j;
                }
                if (vecinoCercano < 0 || clases[i] != clases[vecinoCercano]) continue;
                ++aciertos;
            }
        }
        this.calidad = (double)aciertos / M * alfa * 100.0;
        this.calidad += (1.0 - alfa) * 100.0 * (M - s) / M;
        this.cruzado = false;
    }

    public void mutacion(double pMutacion1to0, double pMutacion0to1) {
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (this.cuerpo[i]) {
                if (!(Randomize.Rand() < pMutacion1to0)) continue;
                this.cuerpo[i] = false;
                this.cruzado = true;
                continue;
            }
            if (!(Randomize.Rand() < pMutacion0to1)) continue;
            this.cuerpo[i] = true;
            this.cruzado = true;
        }
    }

    public void divergeCHC(double r, Cromosoma mejor, double prob) {
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (Randomize.Rand() < r) {
                if (Randomize.Rand() < prob) {
                    this.cuerpo[i] = true;
                    continue;
                }
                this.cuerpo[i] = false;
                continue;
            }
            this.cuerpo[i] = mejor.getGen(i);
        }
        this.cruzado = true;
    }

    public boolean estaEvaluado() {
        return !this.cruzado;
    }

    public int genesActivos() {
        int suma = 0;
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (!this.cuerpo[i]) continue;
            ++suma;
        }
        return suma;
    }

    public boolean esValido() {
        return this.valido;
    }

    public void borrar() {
        this.valido = false;
    }

    public int compareTo(Object o1) {
        if (this.calidad > ((Cromosoma)o1).calidad) {
            return -1;
        }
        if (this.calidad < ((Cromosoma)o1).calidad) {
            return 1;
        }
        return 0;
    }

    public int differenceAtOne(Cromosoma a) {
        int cont = 0;
        int pos = -1;
        for (int i = 0; i < this.cuerpo.length && cont < 2; ++i) {
            if (this.cuerpo[i] == a.getGen(i)) continue;
            pos = i;
            ++cont;
        }
        if (cont >= 2) {
            return -1;
        }
        return pos;
    }

    public String toString() {
        String temp = "[";
        for (int i = 0; i < this.cuerpo.length; ++i) {
            temp = this.cuerpo[i] ? temp + "1" : temp + "0";
        }
        temp = temp + ", " + String.valueOf(this.calidad) + "," + String.valueOf(this.errorRate) + ", " + String.valueOf(this.genesActivos()) + "]";
        return temp;
    }
}

