/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.myDataset;
import org.core.Randomize;

public class Chromosome
implements Comparable {
    public Gene[] genes;
    public ArrayList<Gene> antecedent;
    public ArrayList<Gene> consequent;
    public double fitness;
    public double antsSupport;
    public double consSupport;
    public double support;
    public double confidence;
    public double percentInterval;
    public double suppFit;
    public double lift;
    public double conv;
    public double CF;
    public double netConf;
    public double yulesQ;
    public int nAnts;
    boolean n_e;
    public boolean proceed;
    public boolean seed;
    public boolean specieChild;
    public boolean isReinicio;
    ArrayList<Gene> listGeneCommon1 = new ArrayList();
    ArrayList<Gene> listGeneCommon2 = new ArrayList();
    double countGenDiff;
    double distCommonGenes;
    double distCoverGenes;
    boolean tournSelect;
    double distChrToPop;
    char[] transCover;

    public Chromosome(Gene[] genes) {
        this.genes = new Gene[genes.length];
        this.antecedent = new ArrayList();
        this.consequent = new ArrayList();
        this.nAnts = 0;
        for (int i = 0; i < genes.length; ++i) {
            this.genes[i] = genes[i].copy();
            if (this.genes[i].getActAs() == 0) {
                ++this.nAnts;
                this.antecedent.add(this.genes[i].copy());
            }
            if (this.genes[i].getActAs() != 1) continue;
            this.consequent.add(this.genes[i].copy());
        }
        this.fitness = 0.0;
        this.support = 0.0;
        this.antsSupport = 0.0;
        this.consSupport = 0.0;
        this.confidence = 0.0;
        this.conv = 0.0;
        this.CF = 0.0;
        this.netConf = 0.0;
        this.yulesQ = 0.0;
        this.n_e = true;
        this.proceed = false;
        this.seed = false;
        this.specieChild = false;
        this.tournSelect = false;
        this.suppFit = 0.0;
        this.isReinicio = false;
    }

    public double getDistChrToPop() {
        return this.distChrToPop;
    }

    public void setDistChrToPop(double distChrToPop) {
        this.distChrToPop = distChrToPop;
    }

    public boolean isReinicio() {
        return this.isReinicio;
    }

    public void setReinicio(boolean isReinicio) {
        this.isReinicio = isReinicio;
    }

    public boolean isSeed() {
        return this.seed;
    }

    public void setSeed(boolean seed) {
        this.seed = seed;
    }

    public Chromosome copy() {
        Chromosome chromo = new Chromosome(this.genes);
        chromo.transCover = new char[this.transCover.length];
        for (int i = 0; i < this.transCover.length; ++i) {
            chromo.transCover[i] = this.transCover[i];
        }
        chromo.fitness = this.fitness;
        chromo.support = this.support;
        chromo.antsSupport = this.antsSupport;
        chromo.consSupport = this.consSupport;
        chromo.confidence = this.confidence;
        chromo.CF = this.CF;
        chromo.netConf = this.netConf;
        chromo.yulesQ = this.yulesQ;
        chromo.conv = this.conv;
        chromo.lift = this.lift;
        chromo.nAnts = this.nAnts;
        chromo.n_e = this.n_e;
        chromo.proceed = this.proceed;
        chromo.specieChild = this.specieChild;
        chromo.seed = this.seed;
        chromo.tournSelect = this.tournSelect;
        chromo.suppFit = this.suppFit;
        chromo.isReinicio = this.isReinicio;
        return chromo;
    }

    public boolean isTournSelect() {
        return this.tournSelect;
    }

    public void setTournSelect(boolean tournSelect) {
        this.tournSelect = tournSelect;
    }

    public boolean isSpecieChild() {
        return this.specieChild;
    }

    public void setSpecieChild(boolean specieChild) {
        this.specieChild = specieChild;
    }

    public boolean isProceed() {
        return this.proceed;
    }

    public void setProceed(boolean proceed) {
        this.proceed = proceed;
    }

    public void setSupport(double support) {
        this.support = support;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public double getSupport() {
        return this.support;
    }

    public double getAntsSupport() {
        return this.antsSupport;
    }

    public double getConsSupport() {
        return this.consSupport;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Gene[] getGenes() {
        return this.genes;
    }

    public Gene getGene(int i) {
        return this.genes[i];
    }

    public void forceConsistency() {
        int count;
        int pos;
        int i;
        int n_cons = 0;
        int n_ant = 0;
        for (i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() == 0) {
                ++n_ant;
            }
            if (this.genes[i].getActAs() != 1) continue;
            ++n_cons;
        }
        if (n_cons > 1) {
            pos = Randomize.RandintClosed(1, n_cons);
            count = 1;
            for (i = 0; i < this.genes.length; ++i) {
                if (this.genes[i].getActAs() != 1) continue;
                if (count != pos) {
                    this.genes[i].setActAs(0);
                    ++n_ant;
                }
                ++count;
            }
        } else if (n_cons < 1) {
            if (n_ant > 1) {
                pos = Randomize.RandintClosed(1, n_ant);
                count = 1;
                for (i = 0; i < this.genes.length && count <= pos; ++i) {
                    if (this.genes[i].getActAs() != 0) continue;
                    if (count == pos) {
                        this.genes[i].setActAs(1);
                        --n_ant;
                    }
                    ++count;
                }
            } else {
                pos = Randomize.Randint(0, this.genes.length);
                while (this.genes[pos].getActAs() != -1) {
                    pos = Randomize.Randint(0, this.genes.length);
                }
                this.genes[pos].setActAs(1);
            }
            ++n_cons;
        }
        if (n_ant < 1) {
            pos = Randomize.Randint(0, this.genes.length);
            while (this.genes[pos].getActAs() != -1) {
                pos = Randomize.Randint(0, this.genes.length);
            }
            this.genes[pos].setActAs(0);
        }
    }

    public boolean equals(Chromosome chr) {
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != -1 && chr.genes[i].getActAs() == -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 && chr.genes[i].getActAs() != -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 || chr.genes[i].getActAs() == -1 || chr.genes[i].equals(this.genes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String str = "Lift:  " + this.lift + "; Rule Support: " + this.support + "; Rule Confidence: " + this.confidence + "\n";
        str = str + "Fitness:" + this.fitness + "\n";
        for (int i = 0; i < this.genes.length; ++i) {
            str = str + this.genes[i] + "\n";
        }
        return str;
    }

    public int isBetter(Chromosome chromo) {
        if (this.fitness > chromo.fitness) {
            return 1;
        }
        if (this.fitness < chromo.fitness) {
            return -1;
        }
        return 0;
    }

    public boolean isCovered(double[] example) {
        boolean covered = true;
        for (int i = 0; i < this.genes.length && covered; ++i) {
            if (this.genes[i].getActAs() == -1) continue;
            covered = this.genes[i].isCover(i, example[i]);
        }
        return covered;
    }

    public void setNew(boolean value) {
        this.n_e = value;
    }

    public boolean isNew() {
        return this.n_e;
    }

    public void computeObjetives(myDataset dataset, double[] wTrans) {
        int i;
        int nTrans = dataset.getnTrans();
        int nVars = dataset.getnVars();
        this.antsSupport = 0.0;
        this.consSupport = 0.0;
        this.support = 0.0;
        this.confidence = 0.0;
        this.conv = 0.0;
        this.netConf = 0.0;
        this.CF = 0.0;
        this.nAnts = 0;
        this.suppFit = 0.0;
        int nCons = 0;
        int[] covered = new int[nTrans];
        this.transCover = new char[nTrans];
        for (i = 0; i < nTrans; ++i) {
            covered[i] = 0;
            this.transCover[i] = 48;
        }
        for (i = 0; i < nTrans; ++i) {
            double[] example = dataset.getExample(i);
            boolean consCover = true;
            boolean antsCover = true;
            for (int j = 0; j < nVars && (antsCover || consCover); ++j) {
                if (this.genes[j].getActAs() == 0 && antsCover) {
                    if (this.genes[j].isCover(j, example[j])) continue;
                    antsCover = false;
                    continue;
                }
                if (this.genes[j].getActAs() != 1 || !consCover || this.genes[j].isCover(j, example[j])) continue;
                consCover = false;
            }
            if (antsCover) {
                this.antsSupport += 1.0;
            }
            if (consCover) {
                this.consSupport += 1.0;
            }
            if (!antsCover || !consCover) continue;
            this.support += 1.0;
            this.suppFit += wTrans[i];
            covered[i] = 1;
            this.transCover[i] = 49;
        }
        this.antsSupport /= (double)nTrans;
        this.consSupport /= (double)nTrans;
        this.support /= (double)nTrans;
        this.suppFit /= (double)nTrans;
        if (this.antsSupport > 0.0) {
            this.confidence = this.support / this.antsSupport;
        }
        for (i = 0; i < nVars; ++i) {
            if (this.genes[i].getActAs() == 0) {
                ++this.nAnts;
            }
            if (this.genes[i].getActAs() == 1) {
                ++nCons;
            }
            if (this.genes[i].getActAs() == -1) continue;
            this.genes[i].tuneInterval(dataset, covered);
            double amp = this.genes[i].getUpperBound() - this.genes[i].getLowerBound();
            double d = this.genes[i].getIsPositiveInterval() ? amp / dataset.getAmplitude(i) : (dataset.getAmplitude(i) - amp) / dataset.getAmplitude(i);
        }
        this.percentInterval /= (double)(this.nAnts + nCons);
        this.lift = this.antsSupport == 0.0 || this.consSupport == 0.0 ? 1.0 : this.support / (this.antsSupport * this.consSupport);
        this.conv = this.consSupport == 1.0 || this.antsSupport == 0.0 ? 1.0 : this.antsSupport * (1.0 - this.consSupport) / (this.antsSupport - this.support);
        this.netConf = this.antsSupport == 0.0 || this.antsSupport == 1.0 || Math.abs(this.antsSupport * (1.0 - this.antsSupport)) <= 0.001 ? 0.0 : (this.support - this.antsSupport * this.consSupport) / (this.antsSupport * (1.0 - this.antsSupport));
        double numeratorYules = this.support * (1.0 - this.consSupport - this.antsSupport + this.support) - (this.antsSupport - this.support) * (this.consSupport - this.support);
        double denominatorYules = this.support * (1.0 - this.consSupport - this.antsSupport + this.support) + (this.antsSupport - this.support) * (this.consSupport - this.support);
        this.yulesQ = this.antsSupport == 0.0 || this.antsSupport == 1.0 || this.consSupport == 0.0 || this.consSupport == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
        this.CF = 0.0;
        if (this.confidence > this.consSupport) {
            this.CF = (this.confidence - this.consSupport) / (1.0 - this.consSupport);
        } else if (this.confidence < this.consSupport) {
            this.CF = (this.confidence - this.consSupport) / this.consSupport;
        }
        double componentSupport = 1.0 - 1.0 / Math.pow(2.0, 10.0 * this.support);
        this.fitness = componentSupport * (1.0 - 1.0 / this.lift) + this.netConf + 1.0 / (double)(this.nAnts * 2);
        this.n_e = false;
    }

    public double getLift() {
        return this.lift;
    }

    public void setLift(double lift) {
        this.lift = lift;
    }

    public boolean isSubChromo(Chromosome chromo2) {
        if (this.getSupport() < chromo2.getSupport()) {
            return false;
        }
        for (int i = 0; i < this.genes.length; ++i) {
            Gene gen = chromo2.getGene(i);
            if (this.genes[i].getActAs() != -1 && gen.getActAs() == -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 && gen.getActAs() != -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 || gen.getActAs() == -1 || this.genes[i].isSubGen(gen)) continue;
            return false;
        }
        return true;
    }

    public double getPercentInterval() {
        return this.percentInterval;
    }

    public void setPercentInterval(double percentInterval) {
        this.percentInterval = percentInterval;
    }

    public void proceedCommonDiffGene(Chromosome chr) {
        this.countGenDiff = 0.0;
        this.listGeneCommon1.clear();
        this.listGeneCommon2.clear();
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != -1 && chr.genes[i].getActAs() != -1) {
                this.listGeneCommon1.add(this.genes[i]);
                this.listGeneCommon2.add(chr.genes[i]);
                continue;
            }
            if (this.genes[i].getActAs() != -1 && chr.genes[i].getActAs() == -1) {
                this.countGenDiff += 1.0;
                continue;
            }
            if (this.genes[i].getActAs() != -1 || chr.genes[i].getActAs() == -1) continue;
            this.countGenDiff += 1.0;
        }
    }

    public double distanceCommonGenes(ArrayList<Gene> listGeneCommon1, ArrayList<Gene> listGeneCommon2) {
        double distCommonGenes = 0.0;
        if (!listGeneCommon1.isEmpty()) {
            for (int i = 0; i < listGeneCommon1.size(); ++i) {
                distCommonGenes += listGeneCommon1.get(i).distanceGenMaxOverlap(listGeneCommon2.get(i));
            }
            return distCommonGenes /= (double)listGeneCommon1.size();
        }
        return 1.0;
    }

    public double getDistCoverGenes() {
        return this.distCoverGenes;
    }

    public void setDistCoverGenes(double distCoverGenes) {
        this.distCoverGenes = distCoverGenes;
    }

    public double distanceChromosome(Chromosome chr) {
        this.proceedCommonDiffGene(chr);
        this.distCommonGenes = this.distanceCommonGenes(this.listGeneCommon1, this.listGeneCommon2);
        this.distCoverGenes = this.distCover(chr);
        return (this.distCommonGenes + this.distCoverGenes) / 2.0;
    }

    public double distCover(Chromosome chr) {
        double cCoverBoth = 0.0;
        double cCoverR1 = 0.0;
        double cCoverR2 = 0.0;
        for (int i = 0; i < this.transCover.length; ++i) {
            boolean coverR1 = false;
            boolean coverR2 = false;
            if (this.transCover[i] == '1') {
                cCoverR1 += 1.0;
                coverR1 = true;
            }
            if (chr.getTransCover()[i] == '1') {
                cCoverR2 += 1.0;
                coverR2 = true;
            }
            if (!coverR1 || !coverR2) continue;
            cCoverBoth += 1.0;
        }
        double distCover = 1.0 - Math.max(cCoverBoth / cCoverR1, cCoverBoth / cCoverR2);
        return distCover;
    }

    public char[] getTransCover() {
        return this.transCover;
    }

    public void setTransCover(char[] transCover) {
        this.transCover = transCover;
    }

    public ArrayList<Gene> getListGeneCommon1() {
        return this.listGeneCommon1;
    }

    public void setListGeneCommon1(ArrayList<Gene> listGeneCommon1) {
        this.listGeneCommon1 = listGeneCommon1;
    }

    public ArrayList<Gene> getListGeneCommon2() {
        return this.listGeneCommon2;
    }

    public void setListGeneCommon2(ArrayList<Gene> listGeneCommon2) {
        this.listGeneCommon2 = listGeneCommon2;
    }

    public double getDistCommonGenes() {
        return this.distCommonGenes;
    }

    public void setDistCommonGenes(double distCommonGenes) {
        this.distCommonGenes = distCommonGenes;
    }

    public int getnAnts() {
        return this.nAnts;
    }

    public void setnAnts(int value) {
        this.nAnts = value;
    }

    public ArrayList<Integer> getCoveredTIDs(myDataset dataset) {
        ArrayList<Integer> TIDs = new ArrayList<Integer>();
        for (int i = 0; i < dataset.getnTrans(); ++i) {
            double[] example = dataset.getExample(i);
            if (!this.isCovered(example)) continue;
            TIDs.add(i);
        }
        return TIDs;
    }

    public int compareTo(Object chr) {
        if (((Chromosome)chr).fitness < this.fitness) {
            return -1;
        }
        if (((Chromosome)chr).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }

    public double getCF() {
        return this.CF;
    }

    public void setCF(double cf) {
        this.CF = cf;
    }

    public double getConv() {
        return this.conv;
    }

    public void setConv(double conv) {
        this.conv = conv;
    }

    public double getNetConf() {
        return this.netConf;
    }

    public void setNetConf(double netConf) {
        this.netConf = netConf;
    }

    public double getYulesQ() {
        return this.yulesQ;
    }

    public ArrayList<Gene> getAntecedent() {
        return this.antecedent;
    }

    public ArrayList<Gene> getConsequent() {
        return this.consequent;
    }
}

