/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO.core;

import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.SVM.SMO.core.Option;
import keel.Algorithms.SVM.SMO.core.OptionHandler;
import keel.Algorithms.SVM.SMO.core.Utils;

public abstract class Check
implements OptionHandler {
    protected boolean m_Debug = false;
    protected boolean m_Silent = false;

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        result.addElement(new Option("\tSilent mode - prints nothing to stdout.", "S", 0, "-S"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        this.setSilent(Utils.getFlag('S', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        if (this.getSilent()) {
            result.add("-S");
        }
        return result.toArray(new String[result.size()]);
    }

    protected Object forName(String prefix, Class cls, String classname, String[] options) throws Exception {
        Object result = null;
        try {
            result = Utils.forName(cls, classname, options);
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().indexOf("can't find") > -1) {
                try {
                    result = Utils.forName(cls, prefix + "." + classname, options);
                }
                catch (Exception ex) {
                    if (e.getMessage().toLowerCase().indexOf("can't find") > -1) {
                        throw new Exception("Can't find class called '" + classname + "' or '" + prefix + "." + classname + "'!");
                    }
                    throw new Exception(ex);
                }
            }
            throw new Exception(e);
        }
        return result;
    }

    public abstract void doTests();

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
        if (this.getDebug()) {
            this.setSilent(false);
        }
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSilent(boolean value) {
        this.m_Silent = value;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    protected void print(Object msg) {
        if (!this.getSilent()) {
            System.out.print(msg);
        }
    }

    protected void println(Object msg) {
        this.print(msg + "\n");
    }

    protected void println() {
        this.print("\n");
    }

    protected static void runCheck(Check check, String[] options) {
        try {
            try {
                check.setOptions(options);
                Utils.checkForRemainingOptions(options);
            }
            catch (Exception ex) {
                String result = ex.getMessage() + "\n\n" + check.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                Enumeration enm = check.listOptions();
                while (enm.hasMoreElements()) {
                    Option option = (Option)enm.nextElement();
                    result = result + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(result);
            }
            check.doTests();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

