/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.af.gMCP.gui.CreateGraphGUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DView
extends JTabbedPane {
    private static final Log logger = LogFactory.getLog(DView.class);
    CreateGraphGUI control;
    JPanel description = null;
    private JTextArea jtaDescription = null;
    JPanel analysis = null;
    JTextArea jtaAnalysis = null;
    public static final String defaultDescription = "Enter a description for the graph.";

    public DView(CreateGraphGUI control) {
        this.control = control;
        this.setDescription(defaultDescription);
        this.setAnalysis("");
        this.setSelectedComponent(this.description);
    }

    public void setDescription(String s) {
        if (s == null && this.description != null) {
            return;
        }
        if (this.description == null) {
            this.description = new JPanel();
            this.jtaDescription = this.getTextArea(s, true);
            this.description.setLayout(new GridBagLayout());
            GridBagConstraints c = this.getConstraints();
            JScrollPane sp = new JScrollPane(this.jtaDescription);
            sp.setHorizontalScrollBarPolicy(31);
            this.description.add((Component)sp, c);
            this.insertTab("Description", null, this.description, "Description", 0);
            return;
        }
        this.jtaDescription.setText(s);
        this.jtaDescription.setCaretPosition(0);
    }

    public void setAnalysis(String s) {
        if (s == null && this.analysis != null) {
            return;
        }
        if (this.analysis == null) {
            this.analysis = new JPanel();
            this.analysis.setLayout(new GridBagLayout());
            this.jtaAnalysis = this.getTextArea(s, false);
            GridBagConstraints c = this.getConstraints();
            JScrollPane sp = new JScrollPane(this.jtaAnalysis);
            sp.setHorizontalScrollBarPolicy(31);
            this.analysis.add((Component)sp, c);
            this.insertTab("Analysis", null, this.analysis, "Analysis", this.getComponentCount());
            return;
        }
        this.jtaAnalysis.setText(s);
        this.jtaAnalysis.setCaretPosition(0);
    }

    public JTextArea getTextArea(String s, boolean editable) {
        JTextArea jta = new JTextArea(s);
        jta.setFont(new Font("Monospaced", 0, 12));
        jta.setMargin(new Insets(5, 5, 5, 5));
        jta.setLineWrap(true);
        jta.setEditable(editable);
        jta.setWrapStyleWord(true);
        jta.setCaretPosition(0);
        return jta;
    }

    public GridBagConstraints getConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 0;
        c.ipady = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        return c;
    }

    public String getDescription() {
        String descr = this.jtaDescription.getText();
        descr = descr.replaceAll("\\\\", "\\\\\\\\");
        descr = descr.replaceAll("\n", "\\\\n");
        descr = descr.replaceAll("\"", "\\\\\"");
        return descr;
    }
}

