/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.model.AbstractModel;
import opennlp.perceptron.PerceptronModelWriter;

public class PlainTextPerceptronModelWriter
extends PerceptronModelWriter {
    BufferedWriter output;

    public PlainTextPerceptronModelWriter(AbstractModel model, File f) throws IOException, FileNotFoundException {
        super(model);
        this.output = f.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f)))) : new BufferedWriter(new FileWriter(f));
    }

    public PlainTextPerceptronModelWriter(AbstractModel model, BufferedWriter bw) {
        super(model);
        this.output = bw;
    }

    public void writeUTF(String s) throws IOException {
        this.output.write(s);
        this.output.newLine();
    }

    public void writeInt(int i) throws IOException {
        this.output.write(Integer.toString(i));
        this.output.newLine();
    }

    public void writeDouble(double d) throws IOException {
        this.output.write(Double.toString(d));
        this.output.newLine();
    }

    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

