/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.pipeline;

import eu.kliegr.ac1.pipeline.ReplacementParam;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PipelineStep {
    private final String filename;
    private String outputfilename;
    private ReplacementParam replaceparam;
    private static final Logger LOG = Logger.getLogger(PipelineStep.class.getName());

    public PipelineStep(Node xml) {
        NodeList params;
        Element step = (Element)xml;
        this.filename = step.getElementsByTagName("filename").item(0).getTextContent();
        NodeList outputFN = step.getElementsByTagName("outputfilename");
        if (outputFN.getLength() == 1) {
            this.outputfilename = step.getElementsByTagName("outputfilename").item(0).getTextContent();
        }
        if ((params = step.getElementsByTagName("replaceparam")).getLength() == 1) {
            this.replaceparam = new ReplacementParam(params.item(0));
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getOutputfilename(String replacementName, String replacementValue) {
        return this.outputfilename.replaceAll(replacementName, replacementValue);
    }

    public ReplacementParam getReplacementParam() {
        return this.replaceparam;
    }
}

