/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.nary.sat.NogoodStealer;
import org.chocosolver.solver.constraints.nary.sat.PropSat;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.decision.SetDecision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class NogoodFromRestarts
implements IMonitorRestart {
    private final ArrayDeque<Decision> decisions;
    private final PropSat png;
    private final NogoodStealer nogoodStealer;

    public NogoodFromRestarts(Model model) {
        this(model, NogoodStealer.NONE);
    }

    public NogoodFromRestarts(Model model, NogoodStealer stealer) {
        this.png = model.getMinisat().getPropSat();
        this.decisions = new ArrayDeque(16);
        this.nogoodStealer = stealer;
        this.nogoodStealer.add(model);
    }

    @Override
    public void beforeRestart() {
        this.extractNogoodFromPath(this.png.getModel().getSolver().getDecisionPath());
        this.nogoodStealer.nogoodStealing(this.png.getModel(), this);
    }

    public void extractNogoodFromPath(DecisionPath decisionPath) {
        assert (this.decisions.isEmpty());
        decisionPath.transferInto(this.decisions, false);
        int d = this.decisions.size();
        int[] lits = new int[d];
        int i = 0;
        while (!this.decisions.isEmpty()) {
            Decision decision = this.decisions.pollFirst();
            int lit = this.asLit(decision);
            if (decision.hasNext() || decision.getArity() == 1) {
                lits[i++] = lit;
                continue;
            }
            if (i == 0) {
                this.png.addLearnt(lit);
                continue;
            }
            lits[i] = lit;
            this.png.addLearnt(Arrays.copyOf(lits, i + 1));
        }
    }

    private <V extends Variable> int asLit(Decision<V> decision) {
        if (decision instanceof IntDecision) {
            IntDecision id = (IntDecision)decision;
            return this.asLit(this.nogoodStealer.getById((IntVar)id.getDecisionVariable(), this.png.getModel()), id.getDecOp(), (int)id.getDecisionValue());
        }
        if (decision instanceof SetDecision) {
            SetDecision id = (SetDecision)decision;
            return this.asLit(this.nogoodStealer.getById((SetVar)id.getDecisionVariable(), this.png.getModel()), id.getDecOp(), (int)id.getDecisionValue());
        }
        throw new UnsupportedOperationException("Cannot deal with such decision: " + decision);
    }

    private int asLit(IntVar var, DecisionOperator<IntVar> op, int val) {
        int l;
        if (DecisionOperatorFactory.makeIntEq().equals(op)) {
            l = MiniSat.makeLiteral(this.png.makeIntEq(var, val), false);
        } else if (DecisionOperatorFactory.makeIntNeq().equals(op)) {
            l = MiniSat.makeLiteral(this.png.makeIntEq(var, val), true);
        } else if (DecisionOperatorFactory.makeIntSplit().equals(op)) {
            l = MiniSat.makeLiteral(this.png.makeIntLe(var, val), false);
        } else if (DecisionOperatorFactory.makeIntReverseSplit().equals(op)) {
            l = MiniSat.makeLiteral(this.png.makeIntLe(var, val), true);
        } else {
            throw new UnsupportedOperationException("Cannot deal with such operator: " + op);
        }
        return l;
    }

    private int asLit(SetVar var, DecisionOperator<SetVar> op, int val) {
        int l;
        if (DecisionOperatorFactory.makeSetForce().equals(op)) {
            l = MiniSat.makeLiteral(this.png.makeSetIn(var, val), false);
        } else if (DecisionOperatorFactory.makeSetRemove().equals(op)) {
            l = MiniSat.makeLiteral(this.png.makeSetIn(var, val), true);
        } else {
            throw new UnsupportedOperationException("Cannot deal with such operator: " + op);
        }
        return l;
    }
}

