/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra.missingData;

import org.ejml.data.DenseMatrix64F;

public class PermutationIndices {
    private final DenseMatrix64F matrix;
    private final int dim;
    private int zeroCount;
    private int nonZeroFiniteCount;
    private int infiniteCount;
    private int[] nonZeroFiniteIndices;
    private int[] zeroIndices;
    private int[] infiniteIndices;

    public PermutationIndices(DenseMatrix64F denseMatrix64F) {
        this.matrix = denseMatrix64F;
        this.dim = denseMatrix64F.getNumCols();
        assert (this.dim == denseMatrix64F.getNumRows());
        for (int i = 0; i < this.dim; ++i) {
            double d = denseMatrix64F.get(i, i);
            if (Double.isInfinite(d)) {
                ++this.infiniteCount;
                continue;
            }
            if (d == 0.0) {
                ++this.zeroCount;
                continue;
            }
            ++this.nonZeroFiniteCount;
        }
    }

    public int getNumberOfZeroDiagonals() {
        return this.zeroCount;
    }

    public int getNumberOfNonZeroFiniteDiagonals() {
        return this.nonZeroFiniteCount;
    }

    public int getNumberOfInfiniteDiagonals() {
        return this.infiniteCount;
    }

    public int[] getNonZeroFiniteIndices() {
        if (this.nonZeroFiniteIndices == null) {
            this.makeIndices();
        }
        return this.nonZeroFiniteIndices;
    }

    public int[] getZeroIndices() {
        if (this.zeroIndices == null) {
            this.makeIndices();
        }
        return this.zeroIndices;
    }

    public int[] getInfiniteIndices() {
        if (this.infiniteIndices == null) {
            this.makeIndices();
        }
        return this.infiniteIndices;
    }

    private void makeIndices() {
        this.nonZeroFiniteIndices = new int[this.nonZeroFiniteCount];
        this.zeroIndices = new int[this.zeroCount];
        this.infiniteIndices = new int[this.infiniteCount];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.dim; ++i) {
            double d = this.matrix.get(i, i);
            if (Double.isInfinite(d)) {
                this.infiniteIndices[n3] = i;
                ++n3;
                continue;
            }
            if (d == 0.0) {
                this.zeroIndices[n] = i;
                ++n;
                continue;
            }
            this.nonZeroFiniteIndices[n2] = i;
            ++n2;
        }
    }
}

