/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class PoissonDist
extends DiscreteDistributionInt {
    private double lambda;
    public static double MAXLAMBDA = 100000.0;

    public PoissonDist(double d) {
        this.setLambda(d);
    }

    public double prob(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.pdf == null) {
            return PoissonDist.prob(this.lambda, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return PoissonDist.prob(this.lambda, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        double d = 0.0;
        if (n < 0) {
            return 0.0;
        }
        if (this.lambda == 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return GammaDist.barF((double)n + 1.0, 15, this.lambda);
        }
        if (n >= this.xmax) {
            return 1.0;
        }
        if (n < this.xmin) {
            double d2;
            d = d2 = PoissonDist.prob(this.lambda, n);
            int n2 = n;
            while (n2 > 0 && n2 >= n - 20) {
                d2 = d2 * (double)n2 / this.lambda;
                --n2;
                d += d2;
            }
            return d;
        }
        if (n <= this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n + 1 - this.xmin];
    }

    public double barF(int n) {
        if (n <= 0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return GammaDist.cdf(n, 15, this.lambda);
        }
        if (n > this.xmax) {
            return PoissonDist.barF(this.lambda, n);
        }
        if (n <= this.xmin) {
            return 1.0;
        }
        if (n > this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n - 1 - this.xmin];
    }

    public int inverseFInt(double d) {
        if (this.cdf == null) {
            return PoissonDist.inverseF(this.lambda, d);
        }
        return super.inverseFInt(d);
    }

    public double getMean() {
        return PoissonDist.getMean(this.lambda);
    }

    public double getVariance() {
        return PoissonDist.getVariance(this.lambda);
    }

    public double getStandardDeviation() {
        return PoissonDist.getStandardDeviation(this.lambda);
    }

    public static double prob(double d, int n) {
        double d2;
        if (n < 0) {
            return 0.0;
        }
        if (d >= 100.0 ? (double)n >= 10.0 * d : (d >= 3.0 ? (double)n >= 100.0 * d : (double)n >= 200.0 * Math.max(1.0, d))) {
            return 0.0;
        }
        if (d < 20.0 && n <= 100) {
            d2 = Math.exp(-d) * Math.pow(d, n) / Num.factorial(n);
        } else {
            double d3 = (double)n * Math.log(d) - Num.lnGamma((double)n + 1.0) - d;
            d2 = Math.exp(d3);
        }
        return d2;
    }

    public static double cdf(double d, int n) {
        double d2;
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (d == 0.0) {
            return 1.0;
        }
        if (n < 0) {
            return 0.0;
        }
        if (d >= 100.0 ? (double)n >= 10.0 * d : (double)n >= 100.0 * Math.max(1.0, d)) {
            return 1.0;
        }
        if (d > 200.0) {
            return GammaDist.barF((double)n + 1.0, 15, d);
        }
        if ((double)n >= d) {
            return 1.0 - PoissonDist.barF(d, n + 1);
        }
        double d3 = d2 = PoissonDist.prob(d, n);
        for (int i = n; d2 > EPSILON && i > 0; d2 *= (double)i / d, --i) {
        }
        d3 = d2;
        for (int i = i + 1; i <= n; ++i) {
            d3 += (d2 *= d / (double)i);
        }
        return d3;
    }

    public static double barF(double d, int n) {
        double d2;
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (n <= 0) {
            return 1.0;
        }
        if (d >= 100.0 ? (double)n >= 10.0 * d : (double)n >= 100.0 + 100.0 * Math.max(1.0, d)) {
            return 0.0;
        }
        if (d > 200.0) {
            return GammaDist.cdf(n, 15, d);
        }
        if ((double)n <= d) {
            return 1.0 - PoissonDist.cdf(d, n - 1);
        }
        double d3 = d2 = PoissonDist.prob(d, n);
        for (int i = n + 1; d2 > EPSILON || i <= n + 20; ++i) {
            d3 += (d2 *= d / (double)i);
        }
        return d3;
    }

    public static int inverseF(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("u is not in range [0,1]");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (d2 >= 1.0) {
            return Integer.MAX_VALUE;
        }
        if (d2 <= 0.0) {
            return 0;
        }
        int n = 0;
        if (d < 700.0) {
            double d3 = -1.0;
            d2 *= Math.exp(d);
            double d4 = 1.0;
            for (double d5 = 1.0; d5 < d2 && d5 > d3; d5 += (d4 *= d / (double)(++n))) {
                d3 = d5;
            }
        } else {
            double d6 = PoissonDist.prob(d, (int)d);
            if (d2 <= 0.5) {
                for (n = (int)d; d6 > EPSILON && n > 0; d6 *= (double)n / d, --n) {
                }
                for (double d7 = d6; d7 < d2; d7 += (d6 *= d / (double)(++n))) {
                }
            } else {
                for (double d8 = PoissonDist.cdf(d, (int)d); d6 > EPSILON && d8 < d2; d8 += (d6 *= d / (double)(++n))) {
                }
            }
        }
        return n;
    }

    public static double[] getMLE(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray = new double[1];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        dArray[0] = d / (double)n;
        return dArray;
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        return PoissonDist.getMLE(nArray, n);
    }

    public static PoissonDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = PoissonDist.getMaximumLikelihoodEstimate(nArray, n);
        return new PoissonDist(dArray[0]);
    }

    public static double getMean(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        return d;
    }

    public static double getVariance(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        return d;
    }

    public static double getStandardDeviation(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        return Math.sqrt(d);
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double d) {
        int n;
        int n2;
        this.supportA = 0;
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        this.lambda = d;
        if (d > MAXLAMBDA) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int n3 = (int)(d + 16.0 * (2.0 + Math.sqrt(d)));
        double[] dArray = new double[1 + n3];
        double[] dArray2 = new double[1 + n3];
        int n4 = (int)d;
        double d2 = EPSILON * 0.01 / PoissonDist.prob(d, n4);
        dArray[n4] = 1.0;
        double d3 = 1.0;
        int n5 = n4;
        while (n5 > 0 && dArray[n5] > d2) {
            dArray[n5 - 1] = dArray[n5] * (double)n5 / d;
            d3 += dArray[--n5];
        }
        this.xmin = n2 = n5;
        n5 = n4;
        while (dArray[n5] > d2) {
            dArray[n5 + 1] = dArray[n5] * d / (double)(n5 + 1);
            d3 += dArray[++n5];
            if (n5 < n3 - 1) continue;
            double[] dArray3 = new double[1 + (n3 *= 2)];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            dArray = dArray3;
            dArray3 = new double[1 + n3];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            dArray2 = dArray3;
        }
        this.xmax = n = n5;
        n5 = n2;
        while (n5 <= n) {
            int n6 = n5++;
            dArray[n6] = dArray[n6] / d3;
        }
        dArray2[n2] = dArray[n2];
        n5 = n2;
        while (n5 < n && dArray2[n5] < 0.5) {
            dArray2[++n5] = dArray[n5] + dArray2[n5 - 1];
        }
        this.xmed = n5;
        dArray2[n] = dArray[n];
        n5 = n - 1;
        do {
            dArray2[n5] = dArray[n5] + dArray2[n5 + 1];
        } while (--n5 > this.xmed);
        for (n5 = n2; n5 < this.xmed && dArray2[n5] < EPSILON; ++n5) {
        }
        this.xmin = n2 = n5;
        for (n5 = n; n5 > this.xmed && dArray2[n5] < EPSILON; --n5) {
        }
        this.xmax = n = n5;
        this.pdf = new double[n + 1 - n2];
        this.cdf = new double[n + 1 - n2];
        System.arraycopy(dArray, n2, this.pdf, 0, n - n2 + 1);
        System.arraycopy(dArray2, n2, this.cdf, 0, n - n2 + 1);
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.lambda};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : lambda = " + this.lambda;
    }
}

