/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Prism;

public class Selector
implements Comparable {
    int atributo;
    int operador;
    double[] valor;
    String[] valorN;
    boolean nominal;

    public Selector(int atr, int op, double val) {
        this.atributo = atr;
        this.operador = op;
        this.valor = new double[1];
        this.valor[0] = val;
    }

    public Selector(int atr, int op, String val, boolean nominal) {
        this.atributo = atr;
        this.operador = op;
        this.valorN = new String[1];
        this.valorN[0] = val;
        this.valor = new double[1];
        this.nominal = nominal;
    }

    public Selector(int atr, int op, double[] val) {
        this.atributo = atr;
        this.operador = op;
        this.valor = new double[val.length];
        for (int i = 0; i < val.length; ++i) {
            this.valor[i] = val[i];
        }
    }

    public int compareTo(Object o) {
        Selector s2 = (Selector)o;
        int sal = -2;
        if (this.atributo == s2.getAtributo()) {
            if (this.operador == s2.getOperador() && this.mismoValor(s2.getValores())) {
                sal = 0;
            } else if (this.subsumido(s2.getValores(), s2.getOperador())) {
                sal = -3;
            } else if (this.operador == s2.getOperador() && this.valor[0] <= s2.getValor()) {
                sal = -1;
            } else if (this.operador == s2.getOperador() && this.valor[0] > s2.getValor()) {
                sal = 1;
            }
        } else {
            sal = 3;
            if (this.operador != s2.getOperador()) {
                sal = 2;
            }
        }
        return sal;
    }

    private boolean mismoValor(double[] valores) {
        boolean salida = false;
        if (valores.length == this.valor.length) {
            salida = true;
            for (int i = 0; i < valores.length && salida; ++i) {
                salida = this.valor[i] == valores[i];
            }
        }
        return salida;
    }

    private boolean subsumido(double[] valores, int _operador) {
        boolean salida = false;
        boolean bl = salida = this.mismoValor(valores) && !this.opContrario(_operador);
        if (!salida && this.operador == _operador && this.operador == 0 && this.valor.length < valores.length) {
            salida = true;
            for (int i = 0; i < this.valor.length && salida; ++i) {
                salida = this.valor[i] == valores[i];
            }
        }
        return salida;
    }

    private boolean opContrario(int op) {
        if (this.operador == 0) {
            return op == 1 || op == 2;
        }
        if (this.operador == 1) {
            return op == 0;
        }
        if (this.operador == 2) {
            return op == 3 || op == 0;
        }
        if (this.operador == 3) {
            return op == 2;
        }
        return false;
    }

    public int getAtributo() {
        return this.atributo;
    }

    public int getOperador() {
        return this.operador;
    }

    public double getValor() {
        return this.valor[0];
    }

    public String getValorN() {
        return this.valorN[0];
    }

    public double[] getValores() {
        return this.valor;
    }

    public String[] getValoresN() {
        return this.valorN;
    }

    public void setAtributo(int i) {
        this.atributo = i;
    }

    public void setOperador(int i) {
        this.operador = i;
    }

    public void setValor(double f) {
        this.valor[0] = f;
    }

    public void setValores(double[] f) {
        this.valor = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            this.valor[i] = f[i];
        }
    }

    public void print() {
        System.out.print("(Atr" + this.getAtributo() + " ");
        switch (this.getOperador()) {
            case 0: {
                System.out.print("=");
                break;
            }
            case 1: {
                System.out.print("<>");
                break;
            }
            case 2: {
                System.out.print("<=");
                break;
            }
            default: {
                System.out.print(">");
            }
        }
        if (this.nominal) {
            System.out.print(" " + this.getValorN() + ")\n");
        } else {
            System.out.println(" " + this.getValor() + ")\n");
        }
    }
}

