/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.myDataset;

public class Apriori {
    ArrayList<Itemset> L2;
    double minpsup;
    double minpconf;
    int nClasses;
    int nVariables;
    RuleBase ruleBase;
    myDataset train;
    DataBase dataBase;

    public Apriori() {
    }

    public Apriori(DataBase dataBase, myDataset train) {
        this.train = train;
        this.dataBase = dataBase;
        this.L2 = new ArrayList();
    }

    public void setSupportConfidence(double minpsup, double minpconf) {
        this.minpsup = minpsup;
        this.minpconf = minpconf;
    }

    public RuleBase generateRB(double minpsup, double minpconf) {
        this.ruleBase = new RuleBase(this.dataBase, this.train);
        this.minpsup = minpsup;
        this.minpconf = minpconf;
        if (this.minpsup == 0.0 || this.minpconf == 0.0) {
            return this.ruleBase;
        }
        this.nClasses = this.train.getnClasses();
        this.nVariables = this.train.getnInputs();
        this.generateL2();
        this.generateLarge(this.L2);
        System.gc();
        this.ruleBase.reduceRules();
        return this.ruleBase;
    }

    private void generateL2() {
        this.L2.clear();
        Itemset itemset = new Itemset(0);
        for (int i = 0; i < this.nVariables; ++i) {
            for (int j = 0; j < this.dataBase.numLabels(i); ++j) {
                Item item = new Item(i, j);
                itemset.add(item);
                for (int k = 0; k < this.nClasses; ++k) {
                    itemset.setClas(k);
                    itemset.calculateSupports(this.train);
                    if (!(itemset.getSupportClass() > this.minpsup)) continue;
                    this.L2.add(itemset.clone());
                }
                itemset.remove(0);
            }
        }
        this.generateRules(this.L2);
    }

    private void generateLarge(ArrayList<Itemset> Lk) {
        int size = Lk.size();
        if (size > 1 && Lk.get(0).size() < this.nVariables) {
            ArrayList<Itemset> Lnew = new ArrayList<Itemset>();
            for (int i = 0; i < size - 1; ++i) {
                Itemset itemseti = Lk.get(i);
                for (int j = i + 1; j < size; ++j) {
                    Itemset itemsetj = Lk.get(j);
                    if (!this.isCombinable(itemseti, itemsetj)) continue;
                    Itemset newItemset = itemseti.clone();
                    newItemset.add(itemsetj.get(itemsetj.size() - 1).clone());
                    newItemset.calculateSupports(this.train);
                    if (!(newItemset.getSupportClass() > this.minpsup)) continue;
                    Lnew.add(newItemset);
                }
                this.generateLarge(Lnew);
                this.generateRules(Lnew);
                Lnew.clear();
                System.gc();
            }
        }
    }

    private boolean isCombinable(Itemset itemseti, Itemset itemsetj) {
        if (itemseti.getClas() != itemsetj.getClas()) {
            return false;
        }
        Item itemi = itemseti.get(itemseti.size() - 1);
        Item itemj = itemsetj.get(itemseti.size() - 1);
        return itemi.getVariable() < itemj.getVariable();
    }

    private void generateRules(ArrayList<Itemset> Lk) {
        for (int i = 0; i < Lk.size(); ++i) {
            Itemset itemset = Lk.get(i);
            double confidence = itemset.getSupport() > 0.0 ? itemset.getSupportClass() / itemset.getSupport() : 0.0;
            if (!(confidence > this.minpconf)) continue;
            this.ruleBase.add(itemset);
        }
        if (this.ruleBase.size() > 200000) {
            this.ruleBase.reduceRules();
            System.out.println("Number of rules: " + this.ruleBase.size());
            System.gc();
        }
    }
}

