/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistribution2Dim;

public class BiStudentDist
extends ContinuousDistribution2Dim {
    protected int nu;
    protected double rho;
    protected double facRho;

    public BiStudentDist(int nu, double rho) {
        this.setParams(nu, rho);
    }

    public double density(double x, double y) {
        if (Math.abs(this.rho) == 1.0) {
            throw new IllegalArgumentException("|rho| = 1");
        }
        double T = 1.0 + (x * x - 2.0 * this.rho * x * y + y * y) / ((double)this.nu * this.facRho * this.facRho);
        return 1.0 / (Math.pow(T, (double)(this.nu + 2) / 2.0) * (Math.PI * 2 * this.facRho));
    }

    public double cdf(double x, double y) {
        return BiStudentDist.cdf(this.nu, x, y, this.rho);
    }

    public double barF(double x, double y) {
        return BiStudentDist.barF(this.nu, x, y, this.rho);
    }

    public static double density(int nu, double x, double y, double rho) {
        if (nu < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(rho) >= 1.0) {
            throw new IllegalArgumentException("|rho| >= 1");
        }
        double fRho = (1.0 - rho) * (1.0 + rho);
        double T = 1.0 + (x * x - 2.0 * rho * x * y + y * y) / ((double)nu * fRho);
        return 1.0 / (Math.pow(T, (double)(nu + 2) / 2.0) * (Math.PI * 2 * Math.sqrt(fRho)));
    }

    public static double cdf(int nu, double x, double y, double rho) {
        double bvt;
        double xnkh;
        double xnhk;
        if (nu < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double dh = x;
        double dk = y;
        double eps = 1.0E-15;
        double tpi = Math.PI * 2;
        if (1.0 - rho <= 1.0E-15) {
            x = Math.min(dh, dk);
            return StudentDist.cdf(nu, x);
        }
        if (rho + 1.0 <= 1.0E-15) {
            if (dh > -dk) {
                return StudentDist.cdf(nu, dh) - StudentDist.cdf(nu, -dk);
            }
            return 0.0;
        }
        double ors = (1.0 - rho) * (1.0 + rho);
        double hrk = dh - rho * dk;
        double krh = dk - rho * dh;
        if (Math.abs(hrk) + ors > 0.0) {
            xnhk = hrk * hrk / (hrk * hrk + ors * ((double)nu + dk * dk));
            xnkh = krh * krh / (krh * krh + ors * ((double)nu + dh * dh));
        } else {
            xnhk = 0.0;
            xnkh = 0.0;
        }
        int hs = dh - rho * dk > 0.0 ? 1 : (dh - rho * dk < 0.0 ? -1 : 0);
        int ks = dk - rho * dh > 0.0 ? 1 : (dk - rho * dh < 0.0 ? -1 : 0);
        if (nu % 2 == 0) {
            bvt = Math.atan2(Math.sqrt(ors), -rho) / (Math.PI * 2);
            double gmph = dh / Math.sqrt(16.0 * ((double)nu + dh * dh));
            double gmpk = dk / Math.sqrt(16.0 * ((double)nu + dk * dk));
            double btnckh = 2.0 * Math.atan2(Math.sqrt(xnkh), Math.sqrt(1.0 - xnkh)) / Math.PI;
            double btpdkh = 2.0 * Math.sqrt(xnkh * (1.0 - xnkh)) / Math.PI;
            double btnchk = 2.0 * Math.atan2(Math.sqrt(xnhk), Math.sqrt(1.0 - xnhk)) / Math.PI;
            double btpdhk = 2.0 * Math.sqrt(xnhk * (1.0 - xnhk)) / Math.PI;
            for (int j = 1; j <= nu / 2; ++j) {
                bvt += gmph * (1.0 + (double)ks * btnckh);
                bvt += gmpk * (1.0 + (double)hs * btnchk);
                btnckh += btpdkh;
                btpdkh = (double)(2 * j) * btpdkh * (1.0 - xnkh) / (double)(2 * j + 1);
                btnchk += btpdhk;
                btpdhk = (double)(2 * j) * btpdhk * (1.0 - xnhk) / (double)(2 * j + 1);
                gmph = gmph * ((double)j - 0.5) / ((double)j * (1.0 + dh * dh / (double)nu));
                gmpk = gmpk * ((double)j - 0.5) / ((double)j * (1.0 + dk * dk / (double)nu));
            }
        } else {
            double btnchk;
            double btnckh;
            double qhrk = Math.sqrt(dh * dh + dk * dk - 2.0 * rho * dh * dk + (double)nu * ors);
            double hkrn = dh * dk + rho * (double)nu;
            double hkn = dh * dk - (double)nu;
            double hpk = dh + dk;
            bvt = Math.atan2(-Math.sqrt(nu) * (hkn * qhrk + hpk * hkrn), hkn * hkrn - (double)nu * hpk * qhrk) / (Math.PI * 2);
            if (bvt < -1.0000000000000002E-14) {
                bvt += 1.0;
            }
            double gmph = dh / (Math.PI * 2 * Math.sqrt(nu) * (1.0 + dh * dh / (double)nu));
            double gmpk = dk / (Math.PI * 2 * Math.sqrt(nu) * (1.0 + dk * dk / (double)nu));
            double btpdkh = btnckh = Math.sqrt(xnkh);
            double btpdhk = btnchk = Math.sqrt(xnhk);
            for (int j = 1; j <= (nu - 1) / 2; ++j) {
                bvt += gmph * (1.0 + (double)ks * btnckh);
                bvt += gmpk * (1.0 + (double)hs * btnchk);
                btpdkh = (double)(2 * j - 1) * btpdkh * (1.0 - xnkh) / (double)(2 * j);
                btnckh += btpdkh;
                btpdhk = (double)(2 * j - 1) * btpdhk * (1.0 - xnhk) / (double)(2 * j);
                btnchk += btpdhk;
                gmph = gmph * (double)j / (((double)j + 0.5) * (1.0 + dh * dh / (double)nu));
                gmpk = gmpk * (double)j / (((double)j + 0.5) * (1.0 + dk * dk / (double)nu));
            }
        }
        return bvt;
    }

    public static double barF(int nu, double x, double y, double rho) {
        double u = 1.0 + BiStudentDist.cdf(nu, x, y, rho) - BiStudentDist.cdf(nu, 1000.0, y, rho) - BiStudentDist.cdf(nu, x, 1000.0, rho);
        double eps = 1.0E-15;
        if (u < 1.0E-15) {
            return 0.0;
        }
        if (u <= 1.0) {
            return u;
        }
        return 1.0;
    }

    public double[] getMean() {
        return BiStudentDist.getMean(this.nu, this.rho);
    }

    public static double[] getMean(int nu, double rho) {
        if (nu < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[] mean = new double[]{0.0, 0.0};
        return mean;
    }

    public double[][] getCovariance() {
        return BiStudentDist.getCovariance(this.nu, this.rho);
    }

    public static double[][] getCovariance(int nu, double rho) {
        double coeff;
        if (nu < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] cov = new double[2][2];
        cov[0][0] = coeff = (double)nu / ((double)nu - 2.0);
        cov[0][1] = coeff * rho;
        cov[1][0] = coeff * rho;
        cov[1][1] = coeff;
        return cov;
    }

    public double[][] getCorrelation() {
        return BiStudentDist.getCovariance(this.nu, this.rho);
    }

    public static double[][] getCorrelation(int nu, double rho) {
        if (nu < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] corr = new double[2][2];
        corr[0][0] = 1.0;
        corr[0][1] = rho;
        corr[1][0] = rho;
        corr[1][1] = 1.0;
        return corr;
    }

    protected void setParams(int nu, double rho) {
        if (nu < 1) {
            throw new IllegalArgumentException("nu < 1");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        this.dimension = 2;
        this.nu = nu;
        this.rho = rho;
        this.facRho = Math.sqrt((1.0 - rho) * (1.0 + rho));
    }
}

