/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor;

import choco.cp.model.CPModel;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.variables.AbstractVariable;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class DetectorFactory {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();

    public static void associateIndexes(CPModel m) {
        AbstractVariable iv;
        Iterator<AbstractVariable> it = m.getIntVarIterator();
        int cpt = 0;
        while (it.hasNext()) {
            iv = it.next();
            iv.setHook(cpt);
            ++cpt;
        }
        it = m.getMultipleVarIterator();
        cpt = 0;
        while (it.hasNext()) {
            iv = (MultipleVariables)it.next();
            if (!(iv instanceof TaskVariable)) continue;
            iv.setHook(cpt);
            ++cpt;
        }
    }

    public static void associateIndexes(int from, Variable ... ivars) {
        int cpt = from;
        for (int i = 0; i < ivars.length; ++i) {
            ivars[i].setHook(cpt++);
        }
    }

    public static int maxHookOnMultipleVariables(CPModel model) {
        Iterator<MultipleVariables> it = model.getMultipleVarIterator();
        int hook = Integer.MIN_VALUE;
        while (it.hasNext()) {
            MultipleVariables iv = it.next();
            if (!(iv instanceof TaskVariable) || iv.getHook() <= hook) continue;
            hook = iv.getHook();
        }
        return Math.max(0, hook);
    }

    public static void resetIndexes(CPModel m) {
        AbstractVariable iv;
        Iterator<AbstractVariable> it = m.getIntVarIterator();
        while (it.hasNext()) {
            iv = it.next();
            iv.resetHook();
        }
        it = m.getMultipleVarIterator();
        while (it.hasNext()) {
            iv = (MultipleVariables)it.next();
            if (!(iv instanceof TaskVariable)) continue;
            iv.resetHook();
        }
    }
}

