/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.widgets;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.validator.routines.DoubleValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContrastTableModel
extends AbstractTableModel {
    List<String> header;
    public List<List<Double>> data = new Vector<List<Double>>();
    JLabel jlInfo;
    boolean ratio = false;

    public ContrastTableModel(List<String> header, JLabel jlInfo) {
        this.header = header;
        this.jlInfo = jlInfo;
        for (String s : header) {
            this.data.add(new Vector());
        }
    }

    @Override
    public int getColumnCount() {
        return this.header.size();
    }

    @Override
    public int getRowCount() {
        return this.data.get(0).size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        return this.data.get(c).get(r);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value != null && value instanceof Double) {
            DoubleValidator validator = new DoubleValidator();
            Double d = validator.validate(value.toString());
            this.data.get(col).set(row, d);
        }
        this.check();
    }

    @Override
    public String getColumnName(int column) {
        return this.header.get(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void addLine() {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.get(i).add(0.0);
        }
        this.fireTableStructureChanged();
    }

    public void addLine(Double[] row) {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.get(i).add(row[i]);
        }
        this.fireTableStructureChanged();
    }

    public void removeLine(int i) {
        for (List<Double> row : this.data) {
            row.remove(i);
        }
        this.fireTableStructureChanged();
    }

    public Double sum(int row) {
        double sum = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            sum += this.data.get(i).get(row).doubleValue();
        }
        return sum;
    }

    public Double sumabs(int row) {
        double sum = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            sum += Math.abs(this.data.get(i).get(row));
        }
        return sum;
    }

    public void check() {
        String msg = "";
        Vector<Integer> list = new Vector<Integer>();
        for (int i = 0; i < this.data.get(0).size(); ++i) {
            if (!(this.sum(i) > (double)(this.ratio ? 1 : 0) + 0.001)) {
                double d = this.sum(i);
                boolean bl = this.ratio;
                if (!(d < (double)bl - 0.001)) continue;
            }
            list.add(i + 1);
        }
        if (list.size() != 0) {
            if (list.size() == 1) {
                msg = msg + "Line " + list.get(0) + " does not sum up to " + (this.ratio ? 1 : 0) + ".";
            } else {
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    int row = (Integer)i$.next();
                    if (msg.equals("")) {
                        msg = msg + "Line " + row;
                        continue;
                    }
                    msg = msg + ", " + row;
                }
                msg = msg + " do not sum up to " + (this.ratio ? 1 : 0) + ".";
            }
        }
        this.jlInfo.setText(msg);
    }

    public void scale() {
        for (int i = 0; i < this.data.get(0).size(); ++i) {
            double sumabs;
            if (this.sum(i) != 0.0 || (sumabs = this.sumabs(i).doubleValue()) == 0.0) continue;
            for (int j = 0; j < this.data.size(); ++j) {
                this.setValueAt(2.0 * this.data.get(j).get(i) / sumabs, i, j);
            }
        }
        this.fireTableStructureChanged();
    }

    public String getMatrix() {
        if (this.data.size() == 0 || this.data.get(0).size() == 0) {
            return "matrix()";
        }
        String s = "matrix(data=c( ";
        for (List<Double> l : this.data) {
            for (Double d : l) {
                s = s + d + ",";
            }
        }
        s = s.substring(0, s.length() - 1);
        s = s + "), nrow=" + this.data.get(0).size() + ", ncol=" + this.data.size() + ", byrow = FALSE)";
        return s;
    }

    public void setRatio(boolean b) {
        this.ratio = b;
    }
}

