/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.introspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.FilteringDataRecordIterator;
import org.vikamine.kernel.data.IncludingDataRecordFilter;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.subgroup.SupportingFactor;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRComparator;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResult;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResultSet;
import org.vikamine.kernel.subgroup.analysis.introspect.CompareMode;
import org.vikamine.kernel.subgroup.analysis.introspect.PrototypicalPatternCase;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.util.VKMUtil;

public class SGCBRIntrospector {
    private final SG subgroup;
    private final List<Attribute> relevantAttributes;
    private final Ontology ontology;

    public SGCBRIntrospector(SG subgroup, List<Attribute> relevantAttributes, Ontology ontology) {
        this.subgroup = subgroup;
        this.ontology = ontology;
        this.relevantAttributes = relevantAttributes;
    }

    private List<NominalAttribute> getRelevantNominalAttributesForCBR() {
        LinkedList<NominalAttribute> result = new LinkedList<NominalAttribute>();
        for (Attribute att : this.ontology.getAttributes()) {
            if (!att.isNominal()) continue;
            result.add((NominalAttribute)att);
        }
        return this.toDefaultNominalAttributes(result);
    }

    private List<NominalAttribute> toDefaultNominalAttributes(List<? extends Attribute> attributes) {
        LinkedList<NominalAttribute> result = new LinkedList<NominalAttribute>();
        for (Attribute attribute : attributes) {
            result.add((NominalAttribute)attribute);
        }
        return result;
    }

    public PrototypicalPatternCase getSubgroupFactorsAsPrototypicalPatternCase(CBRResultSet resultSet) {
        List<SGSelector> principalFactors = VKMUtil.asList(this.subgroup.getSGDescription().iterator());
        List<SupportingFactor> supportingFactors = SGUtils.computeSupportingFactors(this.subgroup, this.relevantAttributes, false);
        LinkedList<SupportingFactor> filteredSupportingFactors = new LinkedList<SupportingFactor>();
        for (SupportingFactor suppFactor : supportingFactors) {
            if (!suppFactor.isPositivelyCorrelated()) continue;
            filteredSupportingFactors.add(suppFactor);
        }
        return new PrototypicalPatternCase(principalFactors, filteredSupportingFactors, resultSet);
    }

    public List<SGNominalSelector> getSubgroupFactors(boolean doCombineSelectorForCommonAttribute) {
        List<SGSelector> principalFactors = VKMUtil.asList(this.subgroup.getSGDescription().iterator());
        List<SupportingFactor> supportingFactors = SGUtils.computeSupportingFactors(this.subgroup, this.relevantAttributes, false);
        List<SGSelector> subgroupFactors = new LinkedList<SGSelector>(principalFactors);
        for (SupportingFactor suppFactor : supportingFactors) {
            if (!suppFactor.isPositivelyCorrelated()) continue;
            subgroupFactors.add(suppFactor.getSelector());
        }
        if (doCombineSelectorForCommonAttribute) {
            List<SGNominalSelector> combinedSubgroupFactors = this.combineSubgroupFactorSelectorsForCommonAttribute(subgroupFactors);
            subgroupFactors = combinedSubgroupFactors;
        }
        return subgroupFactors;
    }

    private List<SGNominalSelector> combineSubgroupFactorSelectorsForCommonAttribute(List<SGNominalSelector> subgroupFactors) {
        LinkedList<SGNominalSelector> combinedSubgroupFactors = new LinkedList<SGNominalSelector>();
        HashMap<Attribute, LinkedList<SGNominalSelector>> attributeToSelectorMap = new HashMap<Attribute, LinkedList<SGNominalSelector>>();
        for (SGNominalSelector sGNominalSelector : subgroupFactors) {
            LinkedList<SGNominalSelector> selectorsForAttribute = (LinkedList<SGNominalSelector>)attributeToSelectorMap.get(sGNominalSelector.getAttribute());
            if (selectorsForAttribute == null) {
                selectorsForAttribute = new LinkedList<SGNominalSelector>();
            }
            selectorsForAttribute.add(sGNominalSelector);
            attributeToSelectorMap.put(sGNominalSelector.getAttribute(), selectorsForAttribute);
        }
        for (Map.Entry entry : attributeToSelectorMap.entrySet()) {
            Attribute attr = (Attribute)entry.getKey();
            List selectorsForAttribute = (List)entry.getValue();
            if (selectorsForAttribute.size() > 1) {
                HashSet<Value> values = new HashSet<Value>();
                for (SGNominalSelector sel : selectorsForAttribute) {
                    values.addAll(sel.getValues());
                }
                DefaultSGSelector factorSel = new DefaultSGSelector(attr, values);
                combinedSubgroupFactors.add(factorSel);
                continue;
            }
            combinedSubgroupFactors.add((SGNominalSelector)selectorsForAttribute.get(0));
        }
        return combinedSubgroupFactors;
    }

    private List<Attribute> createAttributesForCBR() {
        LinkedList<Attribute> attributesForCBR = new LinkedList<Attribute>();
        for (Attribute attribute : this.getRelevantNominalAttributesForCBR()) {
            attributesForCBR.add(attribute);
        }
        return attributesForCBR;
    }

    public CBRResultSet retrieveKMostSimilarCases(int k) {
        return new SimpleMatchingCBRComparator().retrieveKMostSimilarCases(k);
    }

    public void fillPrototypicalPatternCase(PrototypicalPatternCase expCase, CBRResultSet resultset) {
        List<NominalAttribute> relevantNominalAttributes = this.getRelevantNominalAttributesForCBR();
        List<SGSelector> selectors = expCase.getUnionOfPrincipleAndSupportingFactors();
        for (SGSelector selector : selectors) {
            if (!relevantNominalAttributes.contains(selector.getAttribute())) continue;
            relevantNominalAttributes.remove(selector.getAttribute());
        }
        LinkedList<SGNominalSelector> explicationCases = new LinkedList<SGNominalSelector>();
        for (NominalAttribute att : relevantNominalAttributes) {
            HashMap<Value, Integer> countingMap = new HashMap<Value, Integer>();
            for (CBRResult result : resultset.getResults()) {
                double value = result.getRetrievedCase().getValue(att);
                if (Value.isMissingValue(value)) continue;
                Value val = att.getNominalValue((int)value);
                Integer counter = (Integer)countingMap.get(val);
                counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
                countingMap.put(val, counter);
            }
            Value mostFrequentValue = this.getMostFrequentValue(countingMap);
            if (mostFrequentValue == null) continue;
            explicationCases.add(new DefaultSGSelector((Attribute)att, mostFrequentValue));
        }
        expCase.setPrototypicalPatternCases(explicationCases);
    }

    private Value getMostFrequentValue(Map<Value, Integer> countingMap) {
        int count = 0;
        Value result = null;
        for (Map.Entry<Value, Integer> entry : countingMap.entrySet()) {
            int countOfVal;
            Value val = entry.getKey();
            if (result == null) {
                result = val;
            }
            if ((countOfVal = entry.getValue().intValue()) <= count) continue;
            count = countOfVal;
            result = val;
        }
        return result;
    }

    public CBRResultSet retrieveKMostDiverseOf2KSimilarCases(int k) {
        CBRComparator comparator = this.createDefaultCBRComparator();
        CBRResultSet mostDiverseCases = new CBRResultSet(null);
        CBRResultSet mostSimilarCases = this.retrieveKMostSimilarCases(2 * k);
        CBRResult mostSimilarCase = mostSimilarCases.getResult(0);
        mostDiverseCases.addResult(mostSimilarCase);
        ArrayList<CBRResult> availableCBRResults = new ArrayList<CBRResult>();
        availableCBRResults.addAll(mostSimilarCases.getResults());
        availableCBRResults.remove(mostSimilarCase);
        int i = 1;
        while (i < k) {
            CBRResult mostDiverseCase = this.getMostDiverseCase(availableCBRResults, mostDiverseCases.getResults(), comparator);
            if (mostDiverseCase == null) break;
            mostDiverseCases.addResult(mostDiverseCase);
            availableCBRResults.remove(mostDiverseCase);
            if (availableCBRResults.isEmpty()) break;
            ++i;
        }
        return mostDiverseCases;
    }

    private CBRComparator createDefaultCBRComparator() {
        CBRComparator comparator = new CBRComparator(this.ontology);
        comparator.setUseKnowledge(false);
        comparator.setCompareMode(CompareMode.RETRIEVE_CASE_FILL_UNKNOWN);
        comparator.setAttributesForCBR(this.createAttributesForCBR());
        return comparator;
    }

    private CBRResult getMostDiverseCase(List<CBRResult> mostSimilarCases, List<CBRResult> alreadySelectedDiverseCases, CBRComparator comparator) {
        CBRResult mostDiverseCase = null;
        double highestDiversity = 0.0;
        for (CBRResult eachSimilarCase : mostSimilarCases) {
            if (mostDiverseCase == null) {
                mostDiverseCase = eachSimilarCase;
                continue;
            }
            double relativeDiversity = this.getRelativeDiversity(eachSimilarCase, alreadySelectedDiverseCases, comparator);
            if (!(highestDiversity < (relativeDiversity *= eachSimilarCase.getSimilarity()))) continue;
            mostDiverseCase = eachSimilarCase;
            highestDiversity = relativeDiversity;
        }
        return mostDiverseCase;
    }

    private double getRelativeDiversity(CBRResult theCase, List<CBRResult> alreadySelectedCases, CBRComparator comparator) {
        double summedDiversity = 0.0;
        for (CBRResult eachSelectedCase : alreadySelectedCases) {
            summedDiversity = 1.0 - comparator.calculateSimilarityBetweenQueryCaseAndRetrievedCase(theCase.getRetrievedCase(), eachSelectedCase.getRetrievedCase());
        }
        return summedDiversity / (double)alreadySelectedCases.size();
    }

    private class SimpleMatchingCBRComparator {
        private double calculateSimilarityToRetrievedCase(List<SGNominalSelector> subgroupFactors, DataRecord retrievedCase) {
            double similarity = 0.0;
            for (SGNominalSelector sel : subgroupFactors) {
                if (!sel.isContainedInInstance(retrievedCase)) continue;
                similarity += 1.0;
            }
            return similarity / (double)subgroupFactors.size();
        }

        public CBRResultSet retrieveKMostSimilarCases(int k) {
            CBRResultSet resultSet = new CBRResultSet(null);
            List<SGNominalSelector> subgroupFactors = SGCBRIntrospector.this.getSubgroupFactors(true);
            FilteringDataRecordIterator instanceIterator = new FilteringDataRecordIterator(SGCBRIntrospector.this.subgroup.subgroupInstanceIterator(), new IncludingDataRecordFilter(){

                @Override
                public boolean isIncluded(DataRecord instance) {
                    if (SGCBRIntrospector.this.subgroup.getTarget() instanceof BooleanTarget) {
                        return ((BooleanTarget)SGCBRIntrospector.this.subgroup.getTarget()).isPositive(instance);
                    }
                    return true;
                }
            });
            while (instanceIterator.hasNext()) {
                DataRecord retrieveCase = (DataRecord)instanceIterator.next();
                resultSet.addResult(new CBRResult(null, retrieveCase, this.calculateSimilarityToRetrievedCase(subgroupFactors, retrieveCase)));
            }
            return resultSet.getKBest(k);
        }
    }
}

