/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.math.Binomial;
import java.util.BitSet;

public class CountConstrainedRankedHistories {
    private static BitSet createClade(String string) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '1') continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private static void computeF(BitSet[] bitSetArray, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            BitSet bitSet = new BitSet();
            bitSet.or(bitSetArray[i]);
            int n = 0;
            for (int j = i + 1; j < nArray.length; ++j) {
                int n2 = CountConstrainedRankedHistories.parent(bitSetArray, j);
                if (n2 != i) continue;
                ++n;
                bitSet.andNot(bitSetArray[j]);
            }
            nArray[i] = bitSet.cardinality() + n - 2;
        }
    }

    private static long Nc(int[] nArray) {
        int n = nArray.length;
        long l = 1L;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            l = (long)((double)l * Binomial.choose(nArray[i] + n - i - 1, n - i - 1));
        }
        return l;
    }

    private static long R(int n, int n2) {
        long l = 1L;
        for (int i = 0; i < n2; ++i) {
            l = (long)((double)l * Binomial.choose2(n - i));
        }
        if (l == 0L) {
            // empty if block
        }
        return l;
    }

    private static long X(int[][] nArray, int[][] nArray2, int[] nArray3) {
        int n;
        int n2 = nArray3.length;
        long l = 1L;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n + 1; ++i) {
                l *= CountConstrainedRankedHistories.R(nArray[n][i], nArray2[n][i]);
            }
        }
        for (n = 0; n < n2; ++n) {
            l *= CountConstrainedRankedHistories.totalOrder(nArray2[n]);
        }
        return l;
    }

    private static int[] nC(BitSet[] bitSetArray) {
        int[] nArray = new int[bitSetArray.length];
        for (int i = 0; i < bitSetArray.length; ++i) {
            nArray[i] = bitSetArray[i].cardinality();
            BitSet bitSet = new BitSet();
            bitSet.or(bitSetArray[i]);
            for (int j = i + 1; j < bitSetArray.length; ++j) {
                if (!bitSetArray[j].intersects(bitSetArray[i])) continue;
                bitSet.andNot(bitSetArray[j]);
            }
            nArray[i] = bitSet.cardinality();
        }
        return nArray;
    }

    private static long totalOrder(int[] nArray) {
        long l = 1L;
        int n = nArray[0];
        int n2 = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            l = (long)((double)l * Binomial.choose(n += nArray[i + 1], n2 += nArray[i]));
        }
        return l;
    }

    private static int parent(BitSet[] bitSetArray, int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!bitSetArray[i].intersects(bitSetArray[n])) continue;
            return i;
        }
        return 0;
    }

    private static void computeN(int[][] nArray, int[][] nArray2, int[] nArray3, BitSet[] bitSetArray) {
        int n;
        int n2;
        int n3 = nArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n3 - 1][n2] = nArray3[n2];
        }
        for (n2 = n3 - 1; n2 > 0; --n2) {
            for (n = 0; n < n2; ++n) {
                nArray2[n2 - 1][n] = nArray2[n2][n] - nArray[n2][n];
            }
        }
        for (n2 = n3 - 1; n2 > 0; --n2) {
            n = CountConstrainedRankedHistories.parent(bitSetArray, n2);
            for (int i = n2 - 1; i >= n; --i) {
                int[] nArray4 = nArray2[i];
                int n4 = n;
                nArray4[n4] = nArray4[n4] + 1;
            }
        }
    }

    private static boolean kton_next(int[][] nArray, int[] nArray2, int n) {
        int n2 = nArray[n].length - 1;
        if (n2 < 0) {
            if (n < nArray.length - 1) {
                CountConstrainedRankedHistories.reset(nArray, n);
                return CountConstrainedRankedHistories.kton_next(nArray, nArray2, n + 1);
            }
            return false;
        }
        while (nArray[n][n2] == nArray2[n] - 1) {
            if (--n2 >= 0) continue;
            if (n < nArray.length - 1) {
                CountConstrainedRankedHistories.reset(nArray, n);
                return CountConstrainedRankedHistories.kton_next(nArray, nArray2, n + 1);
            }
            return false;
        }
        int n3 = nArray[n][n2] + 1;
        while (n2 < nArray[n].length) {
            nArray[n][n2] = n3;
            ++n2;
        }
        return true;
    }

    private static void reset(int[][] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray[i][j] = 0;
            }
        }
    }

    public static void print(int[][] nArray, int[][] nArray2) {
        int n;
        int n2;
        System.out.println("k:");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < nArray[n2].length; ++n) {
                int n3 = n + n2;
                System.out.print(nArray[n2][n] + "\t");
            }
            System.out.println();
        }
        System.out.println("n:");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < nArray[n2].length; ++n) {
                System.out.print(nArray2[n2][n] + "\t");
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"11111111111111111111", "00000000011110000000", "00000000000110000000", "00000000011000000000", "00000000000000011111", "11111111100000000000", "11111111000000000000", "11111000000000000000"};
        int n = stringArray2.length;
        System.out.println("n = " + stringArray2[0].length());
        System.out.println("#calibrations = " + (stringArray2.length - 1));
        System.out.println("Constraints:");
        for (int i = 0; i < n; ++i) {
            System.out.println("  " + stringArray2[i]);
        }
        BitSet[] bitSetArray = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            bitSetArray[i] = CountConstrainedRankedHistories.createClade(stringArray2[i]);
        }
        int[] nArray = new int[n];
        CountConstrainedRankedHistories.computeF(bitSetArray, nArray);
        int[] nArray2 = CountConstrainedRankedHistories.nC(bitSetArray);
        int[][] nArrayArray = new int[n][];
        int[][] nArrayArray2 = new int[n][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[i + 1];
            nArrayArray2[i] = new int[i + 1];
        }
        CountConstrainedRankedHistories.computeN(nArrayArray, nArrayArray2, nArray2, bitSetArray);
        long l = 0L;
        int[][] nArrayArray3 = new int[n][];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArrayArray3[i] = new int[nArray[i]];
            nArray3[i] = n - i;
        }
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        do {
            int n3;
            int n4;
            for (n4 = 0; n4 < nArrayArray.length; ++n4) {
                for (n3 = 0; n3 < nArrayArray[n4].length; ++n3) {
                    nArrayArray[n4][n3] = 0;
                }
            }
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < nArrayArray3[n4].length; ++n3) {
                    int[] nArray4 = nArrayArray[nArrayArray3[n4][n3] + n4];
                    int n5 = n4;
                    nArray4[n5] = nArray4[n5] + 1;
                }
            }
            CountConstrainedRankedHistories.computeN(nArrayArray, nArrayArray2, nArray2, bitSetArray);
            l += CountConstrainedRankedHistories.X(nArrayArray2, nArrayArray, nArray);
            ++n2;
        } while (CountConstrainedRankedHistories.kton_next(nArrayArray3, nArray3, 0));
        long l3 = System.currentTimeMillis();
        System.out.println("Total # constrained ranked histories = " + l + " in " + n2 + " calls.");
        System.out.println("Elapsed time " + (double)Math.round((double)(l3 - l2) / 10.0) / 100.0 + " seconds");
    }
}

