/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.TreeTrait;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface TreeTraitProvider {
    public TreeTrait[] getTreeTraits();

    public TreeTrait getTreeTrait(String var1);

    public static class Helper
    implements TreeTraitProvider {
        private Map<String, TreeTrait> traits = new HashMap<String, TreeTrait>();

        public Helper() {
        }

        public Helper(TreeTrait treeTrait) {
            this.addTrait(treeTrait);
        }

        public Helper(String string, TreeTrait treeTrait) {
            this.addTrait(string, treeTrait);
        }

        public Helper(TreeTrait[] treeTraitArray) {
            this.addTraits(treeTraitArray);
        }

        public Helper(Collection<TreeTrait> collection) {
            this.addTraits(collection);
        }

        public void addTrait(TreeTrait treeTrait) {
            this.traits.put(treeTrait.getTraitName(), treeTrait);
        }

        public void addTrait(String string, TreeTrait treeTrait) {
            if (this.traits.containsKey(string)) {
                throw new RuntimeException("All traits must have unique names");
            }
            this.traits.put(string, treeTrait);
        }

        public void addTraits(TreeTrait[] treeTraitArray) {
            for (TreeTrait treeTrait : treeTraitArray) {
                this.traits.put(treeTrait.getTraitName(), treeTrait);
            }
        }

        public void addTraits(Collection<TreeTrait> collection) {
            for (TreeTrait treeTrait : collection) {
                this.traits.put(treeTrait.getTraitName(), treeTrait);
            }
        }

        @Override
        public TreeTrait[] getTreeTraits() {
            TreeTrait[] treeTraitArray = new TreeTrait[this.traits.values().size()];
            return this.traits.values().toArray(treeTraitArray);
        }

        @Override
        public TreeTrait getTreeTrait(String string) {
            return this.traits.get(string);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Helper helper = (Helper)object;
            return Objects.equals(this.traits, helper.traits);
        }

        public int hashCode() {
            return this.traits != null ? this.traits.hashCode() : 0;
        }
    }
}

