/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.util;

import dr.evolution.util.TimeScale;
import dr.evolution.util.Units;
import dr.util.Attribute;
import dr.util.NumberFormatter;
import java.util.Calendar;
import java.util.TimeZone;

public class Date
extends TimeScale
implements Attribute {
    public static final String DATE = "date";
    private double uncertainty = 0.0;
    private double time;
    private NumberFormatter formatter = new NumberFormatter(5);

    public Date(double d, Units.Type type, boolean bl, java.util.Date date) {
        super(type, bl, date);
        this.time = d;
    }

    public Date(java.util.Date date) {
        super(Units.Type.YEARS, false);
        this.origin = -1970.0;
        this.initUsingDate(date);
    }

    public Date(java.util.Date date, Units.Type type) {
        super(type, false);
        this.initUsingDate(date);
    }

    public Date(java.util.Date date, Units.Type type, java.util.Date date2) {
        super(type, false, date2);
        this.initUsingDate(date);
    }

    public Date(double d, Units.Type type, boolean bl) {
        super(type, bl);
        this.time = d;
    }

    private Date(double d, Units.Type type, boolean bl, double d2) {
        super(type, bl, d2);
        this.time = d;
    }

    public static Date createRelativeAge(double d, Units.Type type) {
        return new Date(d, type, true);
    }

    public static Date createTimeAgoFromOrigin(double d, Units.Type type, java.util.Date date) {
        return new Date(d, type, true, date);
    }

    public static Date createTimeAgoFromOrigin(double d, Units.Type type, double d2) {
        return new Date(d, type, true, d2);
    }

    public static Date createTimeSinceOrigin(double d, Units.Type type, java.util.Date date) {
        return new Date(d, type, false, date);
    }

    public static Date createTimeSinceOrigin(double d, Units.Type type, double d2) {
        return new Date(d, type, false, d2);
    }

    public static Date createDate(java.util.Date date) {
        return new Date(date, Units.Type.YEARS);
    }

    private void initUsingDate(java.util.Date date) {
        long l = date.getTime();
        double d = (double)l / MILLIS_PER_DAY;
        switch (this.units) {
            case DAYS: {
                this.time = d;
                break;
            }
            case MONTHS: {
                this.time = d / DAYS_PER_MONTH;
                break;
            }
            case YEARS: {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.setTime(date);
                int n = calendar.get(1);
                long l2 = calendar.getTimeInMillis();
                calendar.set(n, 0, 1, 0, 0);
                long l3 = calendar.getTimeInMillis();
                calendar.set(n + 1, 0, 1, 0, 0);
                long l4 = calendar.getTimeInMillis();
                double d2 = (double)(l2 - l3) / (double)(l4 - l3);
                this.time = d2 + (double)n - 1970.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.time < this.getOrigin()) {
            this.time = this.getOrigin() - this.time;
            this.backwards = true;
        } else {
            this.time -= this.getOrigin();
            this.backwards = false;
        }
    }

    public double getTimeValue() {
        return this.time;
    }

    public double getAbsoluteTimeValue() {
        if (this.isBackwards()) {
            return this.getOrigin() - this.getTimeValue();
        }
        return this.getOrigin() + this.getTimeValue();
    }

    public boolean before(Date date) {
        double d = this.convertTime(date.getTimeValue(), date);
        if (this.isBackwards()) {
            return this.getTimeValue() > d;
        }
        return this.getTimeValue() < d;
    }

    public boolean after(Date date) {
        double d = this.convertTime(date.getTimeValue(), date);
        if (this.isBackwards()) {
            return this.getTimeValue() < d;
        }
        return this.getTimeValue() > d;
    }

    public boolean equals(Date date) {
        double d = this.convertTime(date.getTimeValue(), date);
        return this.getTimeValue() == d;
    }

    @Override
    public String getAttributeName() {
        return DATE;
    }

    public Object getAttributeValue() {
        return this;
    }

    @Override
    public String toString() {
        if (this.isBackwards()) {
            return this.formatter.format(this.time).trim() + " " + this.unitString(this.time) + " ago";
        }
        return this.formatter.format(this.time).trim() + " " + this.unitString(this.time);
    }

    public void setUncertainty(double d) {
        this.uncertainty = d;
    }

    public double getUncertainty() {
        return this.uncertainty;
    }
}

