/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGTree;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collections;

public class ARGDistinctTreeCountStatistic
extends Statistic.Abstract {
    public static final String ARG_TREE_COUNT = "argTreeCount";
    public static final String PRINT_TREES = "printTrees";
    private ARGModel arg;
    private int numberOfPartitions;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return "Provides number of distinct loci trees";
        }

        @Override
        public Class getReturnType() {
            return ARGDistinctTreeCountStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(ARGModel.class)};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            return new ARGDistinctTreeCountStatistic(aRGModel);
        }

        @Override
        public String getParserName() {
            return ARGDistinctTreeCountStatistic.ARG_TREE_COUNT;
        }
    };

    public ARGDistinctTreeCountStatistic(ARGModel aRGModel) {
        this.arg = aRGModel;
        this.numberOfPartitions = aRGModel.getNumberOfPartitions();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.numberOfPartitions / 10);
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            ARGTree aRGTree = new ARGTree(this.arg, i);
            String string = aRGTree.getUniqueNewick();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.size();
    }

    public String getFullOutput() {
        ArrayList<String> arrayList = new ArrayList<String>(this.numberOfPartitions);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.numberOfPartitions);
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            ARGTree aRGTree = new ARGTree(this.arg, i);
            String string = aRGTree.getUniqueNewick();
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                arrayList2.add(1);
                continue;
            }
            int n = arrayList.indexOf(string);
            arrayList2.set(n, (Integer)arrayList2.get(n) + 1);
        }
        ArrayList<DistinctTreeCount> arrayList3 = new ArrayList<DistinctTreeCount>(this.numberOfPartitions);
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList3.add(new DistinctTreeCount((String)arrayList.get(i), (Integer)arrayList2.get(i)));
        }
        Collections.sort(arrayList3);
        return arrayList3.toString();
    }

    private class DistinctTreeCount
    implements Comparable<DistinctTreeCount> {
        private final String tree;
        private int count;

        public DistinctTreeCount(String string, int n) {
            this.tree = string;
            this.count = n;
        }

        public void increaseCount() {
            ++this.count;
        }

        @Override
        public int compareTo(DistinctTreeCount distinctTreeCount) {
            if (this.tree.equals(distinctTreeCount.tree)) {
                return 0;
            }
            if (this.count < distinctTreeCount.count) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            try {
                DistinctTreeCount distinctTreeCount = (DistinctTreeCount)object;
                return distinctTreeCount.compareTo(this) == 0;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String toString() {
            return this.tree + " " + this.count;
        }
    }
}

