/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class ScaledTreeLengthRateModel
extends AbstractBranchRateModel {
    private Parameter totalLength;
    protected Tree treeModel;
    private double storedRateFactor;
    private boolean currentFactorKnown;
    private double rateFactor;

    public ScaledTreeLengthRateModel(TreeModel treeModel, Parameter parameter) {
        super("scaledTreeLengthModel");
        this.totalLength = parameter;
        this.treeModel = treeModel;
        this.currentFactorKnown = false;
        this.addModel(treeModel);
        this.addVariable(parameter);
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (tree == this.treeModel);
        if (!this.currentFactorKnown) {
            this.updateCurrentLength();
        }
        return this.rateFactor;
    }

    public double getTotalLength() {
        return this.totalLength.getParameterValue(0);
    }

    protected void updateCurrentLength() {
        double d = 0.0;
        NodeRef nodeRef = this.treeModel.getRoot();
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef2 = this.treeModel.getNode(i);
            if (nodeRef2 == nodeRef) continue;
            d += this.treeModel.getBranchLength(nodeRef2);
        }
        this.rateFactor = this.totalLength.getParameterValue(0) / d;
        this.currentFactorKnown = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            this.currentFactorKnown = false;
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.totalLength) {
            this.currentFactorKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedRateFactor = this.rateFactor;
    }

    @Override
    protected void restoreState() {
        this.rateFactor = this.storedRateFactor;
    }

    @Override
    protected void acceptState() {
    }
}

