/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.BivariateTraitBranchAttributeProvider;
import dr.evomodel.continuous.SampledMultivariateTraitLikelihood;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class BranchMagnitudeAttributeProvider
extends BivariateTraitBranchAttributeProvider {
    public static final String MAGNITUDE_PROVIDER = "branchMagnitudes";
    public static final String SCALE = "scaleByLength";
    public static String DISTANCE_EXTENSION = ".distance";
    public static final String RATE_EXTENSION = ".rate";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(SampledMultivariateTraitLikelihood.class);
            boolean bl = xMLObject.getAttribute(BranchMagnitudeAttributeProvider.SCALE, false);
            return new BranchMagnitudeAttributeProvider(abstractMultivariateTraitLikelihood, bl);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(AbstractMultivariateTraitLikelihood.class), AttributeRule.newBooleanRule(BranchMagnitudeAttributeProvider.SCALE, true)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return BranchMagnitudeAttributeProvider.class;
        }

        @Override
        public String getParserName() {
            return BranchMagnitudeAttributeProvider.MAGNITUDE_PROVIDER;
        }
    };
    private boolean scale;

    public BranchMagnitudeAttributeProvider(AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, boolean bl) {
        super(abstractMultivariateTraitLikelihood);
        this.scale = bl;
        this.label = this.traitName + this.extensionName();
    }

    @Override
    protected String extensionName() {
        if (this.scale) {
            return RATE_EXTENSION;
        }
        return DISTANCE_EXTENSION;
    }

    @Override
    protected double convert(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2);
        if (this.scale) {
            d4 /= d3;
        }
        return d4;
    }
}

