/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InhibitionAssayLikelihood
extends AbstractModelLikelihood {
    public static final String TRAIT_LIKELIHOOD = "inhibitionLikelihood";
    public static final String TRAIT_NAME = "traitName";
    public static final String ROOT_PRIOR = "rootPrior";
    public static final String MODEL = "diffusionModel";
    public static final String TREE = "tree";
    public static final String TRAIT_PARAMETER = "traitParameter";
    public static final String SET_TRAIT = "setOutcomes";
    public static final String MISSING = "missingIndicator";
    public static final String CACHE_BRANCHES = "cacheBranches";
    public static final String IN_REAL_TIME = "inRealTime";
    public static final String PRECISION = "precision";
    private String[] attributeLabel = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(DefaultTreeModel.class), new ElementRule(MatrixParameter.class), new ElementRule("precision", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return InhibitionAssayLikelihood.TRAIT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)xMLObject.getChild(DefaultTreeModel.class);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getChild(MatrixParameter.class);
            XMLObject xMLObject2 = xMLObject.getChild(InhibitionAssayLikelihood.PRECISION);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            int n = defaultTreeModel.getExternalNodeCount();
            if (n != matrixParameter.getColumnDimension() || n != matrixParameter.getRowDimension()) {
                throw new XMLParseException("Dimensions of matrix '" + matrixParameter.getId() + "' do not match the number of taxa in '" + defaultTreeModel.getId() + "'");
            }
            Object var7_7 = null;
            return new InhibitionAssayLikelihood(defaultTreeModel, matrixParameter, parameter);
        }

        private Parameter getTraitParameterByName(CompoundParameter compoundParameter, String string) {
            for (int i = 0; i < compoundParameter.getParameterCount(); ++i) {
                Parameter parameter = compoundParameter.getParameter(i);
                if (parameter.getStatisticName().compareTo(string) != 0) continue;
                return parameter;
            }
            return null;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a continuous trait evolving on a tree by a given diffusion model.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return AbstractMultivariateTraitLikelihood.class;
        }
    };
    private DefaultTreeModel treeModel = null;
    private MatrixParameter dataParameter = null;
    private final Parameter precision = null;
    private final int N;
    MultivariateDiffusionModel diffusionModel = null;
    String traitName = null;
    CompoundParameter traitParameter;
    List<Integer> missingIndices;
    ArrayList dataList = new ArrayList();
    private double logLikelihood;
    private final double maxLogLikelihood = Double.NEGATIVE_INFINITY;
    private double storedLogLikelihood;
    private boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;
    private final HashMap<NodeRef, Double> cachedLikelihoods = null;
    private double treeLength;
    private double storedTreeLength;
    private boolean inSubstitutionTime;

    public InhibitionAssayLikelihood(DefaultTreeModel defaultTreeModel, MatrixParameter matrixParameter, Parameter parameter) {
        super(TRAIT_LIKELIHOOD);
        this.treeModel = defaultTreeModel;
        this.dataParameter = matrixParameter;
        this.addModel(defaultTreeModel);
        this.addVariable(matrixParameter);
        this.addVariable(parameter);
        this.N = defaultTreeModel.getExternalNodeCount();
        StringBuffer stringBuffer = new StringBuffer("Creating inhibition assay model:\n");
        stringBuffer.append("\tPlease cite O'Brien and Suchard (in preparation) if you publish results using this model.");
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    private double getBranchMean(DefaultTreeModel defaultTreeModel, NodeRef nodeRef) {
        if (defaultTreeModel.isRoot(nodeRef)) {
            return defaultTreeModel.getNodeTrait(nodeRef, "mean");
        }
        double d = this.isClusterChangeOnBranchAbove(defaultTreeModel, nodeRef) ? defaultTreeModel.getNodeTrait(nodeRef, "mean") : this.getBranchMean(defaultTreeModel, defaultTreeModel.getParent(nodeRef));
        return d;
    }

    public final boolean isClusterChangeOnBranchAbove(DefaultTreeModel defaultTreeModel, NodeRef nodeRef) {
        return defaultTreeModel.getNodeTrait(nodeRef, "indicator") == 1.0;
    }

    public final boolean areNodesInSameCluster(DefaultTreeModel defaultTreeModel, NodeRef nodeRef, NodeRef nodeRef2) {
        return this.clusterStart(defaultTreeModel, nodeRef) == this.clusterStart(defaultTreeModel, nodeRef2);
    }

    public final NodeRef clusterStart(DefaultTreeModel defaultTreeModel, NodeRef nodeRef) {
        if (defaultTreeModel.isRoot(nodeRef) || this.isClusterChangeOnBranchAbove(defaultTreeModel, nodeRef)) {
            return nodeRef;
        }
        return this.clusterStart(defaultTreeModel, defaultTreeModel.getParent(nodeRef));
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        this.storedTreeLength = this.treeLength;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        this.treeLength = this.storedTreeLength;
    }

    @Override
    protected void acceptState() {
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    public double calculateLogLikelihood() {
        this.logLikelihood = 0.0;
        double[] dArray = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = this.getBranchMean(this.treeModel, this.treeModel.getExternalNode(i));
        }
        double[][] dArray2 = this.dataParameter.getParameterAsMatrix();
        boolean[][] blArray = this.determineCommonClusters();
        for (int i = 0; i < this.N; ++i) {
            for (int j = i; j < this.N; ++j) {
                if (i != j && !blArray[i][j]) continue;
            }
        }
        return this.logLikelihood;
    }

    private boolean[][] determineCommonClusters() {
        boolean[][] blArray = new boolean[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = i; j < this.N; ++j) {
                NodeRef nodeRef;
                if (i == j) continue;
                NodeRef nodeRef2 = this.treeModel.getExternalNode(i);
                if (this.areNodesInSameCluster(this.treeModel, nodeRef2, nodeRef = this.treeModel.getExternalNode(j))) {
                    blArray[j][i] = true;
                    blArray[i][j] = true;
                    continue;
                }
                blArray[j][i] = false;
                blArray[i][j] = false;
            }
        }
        return blArray;
    }

    public double getMaxLogLikelihood() {
        return Double.NEGATIVE_INFINITY;
    }

    public int[] getRestrictedGrowthFunction() {
        boolean[][] blArray = this.determineCommonClusters();
        int n = 1;
        int[] nArray = new int[this.N];
        nArray[0] = 0;
        for (int i = 1; i < this.N; ++i) {
            boolean bl = true;
            for (int j = 0; bl && j < i; ++j) {
                if (!blArray[i][j]) continue;
                bl = false;
                nArray[i] = nArray[j];
            }
            if (!bl) continue;
            nArray[i] = n++;
        }
        return nArray;
    }

    public String getClusterString() {
        int[] nArray = this.getRestrictedGrowthFunction();
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(nArray[0]);
        for (int i = 1; i < this.N; ++i) {
            stringBuffer.append("," + nArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId()), new ClustersColumn(this.getId())};
    }

    public String[] getNodeAttributeLabel() {
        if (this.attributeLabel == null) {
            double[] dArray = this.treeModel.getMultivariateNodeTrait(this.treeModel.getRoot(), "trait");
            this.attributeLabel = new String[dArray.length];
            if (dArray.length == 1) {
                this.attributeLabel[0] = this.traitName;
            } else {
                for (int i = 1; i <= dArray.length; ++i) {
                    this.attributeLabel[i - 1] = this.traitName + i;
                }
            }
        }
        return this.attributeLabel;
    }

    public String[] getAttributeForNode(Tree tree, NodeRef nodeRef) {
        double[] dArray = this.treeModel.getMultivariateNodeTrait(nodeRef, "trait");
        String[] stringArray = new String[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            stringArray[i] = Double.toString(dArray[i]);
        }
        return stringArray;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    private class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return InhibitionAssayLikelihood.this.getLogLikelihood();
        }
    }

    private class ClustersColumn
    extends LogColumn.Abstract {
        public ClustersColumn(String string) {
            super(string);
        }

        @Override
        protected String getFormattedValue() {
            return InhibitionAssayLikelihood.this.getClusterString();
        }
    }
}

