/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.RestrictedPartials;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.distributions.WishartSufficientStatistics;
import dr.util.Citable;
import java.util.List;
import java.util.logging.Logger;

public class NonPhylogeneticMultivariateTraitLikelihood
extends FullyConjugateMultivariateTraitLikelihood {
    private final boolean exchangeableTips;
    private final int zeroHeightTip;
    private static final boolean DEBUG_NO_TREE = false;
    private static final boolean NO_RESCALING = false;

    public NonPhylogeneticMultivariateTraitLikelihood(String string, MutableTreeModel mutableTreeModel, MultivariateDiffusionModel multivariateDiffusionModel, CompoundParameter compoundParameter, Parameter parameter, List<Integer> list, boolean bl, boolean bl2, boolean bl3, BranchRateModel branchRateModel, Model model, boolean bl4, double[] dArray, double d, List<RestrictedPartials> list2, boolean bl5, boolean bl6) {
        super(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, parameter, list, bl, bl2, bl3, branchRateModel, null, null, null, model, bl4, dArray, list2, d, bl5);
        this.exchangeableTips = bl6;
        this.zeroHeightTip = this.findZeroHeightTip(mutableTreeModel);
        this.printInformtion2();
    }

    private int findZeroHeightTip(Tree tree) {
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            if (tree.getNodeHeight(nodeRef) != 0.0) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void printInformtion() {
    }

    protected void printInformtion2() {
        StringBuilder stringBuilder = new StringBuilder("Creating non-phylogenetic multivariate diffusion model:\n");
        stringBuilder.append("\tTrait: ").append(this.traitName).append("\n");
        stringBuilder.append("\tDiffusion process: ").append(this.diffusionModel.getId()).append("\n");
        stringBuilder.append("\tExchangeable tips: ").append(this.exchangeableTips ? "yes" : "no");
        if (this.exchangeableTips) {
            stringBuilder.append(" initial inverse-weight = ").append(1.0 / this.getLengthToRoot(this.treeModel.getExternalNode(0)));
        }
        stringBuilder.append("\n");
        stringBuilder.append(this.extraInfo());
        stringBuilder.append("\tPlease cite:\n");
        stringBuilder.append(Citable.Utils.getCitationString(this));
        stringBuilder.append("\n\tDiffusion dimension   : ").append(this.dimTrait).append("\n");
        stringBuilder.append("\tNumber of observations: ").append(this.numData).append("\n");
        Logger.getLogger("dr.evomodel").info(stringBuilder.toString());
    }

    @Override
    protected double getTreeLength() {
        double d = 0.0;
        double d2 = this.treeModel.getNodeHeight(this.treeModel.getRoot());
        d = 0.0;
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            d += d2 - this.treeModel.getNodeHeight(nodeRef);
        }
        return d;
    }

    protected double getLengthToRoot(NodeRef nodeRef) {
        double d = this.exchangeableTips ? this.getRescaledLengthToRoot(this.treeModel.getExternalNode(this.zeroHeightTip)) : this.getRescaledLengthToRoot(nodeRef);
        return d;
    }

    private SufficientStatistics computeInnerProductsForTips(double[][] dArray, double[] dArray2) {
        int n = this.treeModel.getRoot().getNumber();
        int n2 = this.dim * n;
        for (int i = 0; i < this.dim; ++i) {
            this.meanCache[n2 + i] = 0.0;
        }
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 0.0;
        int n3 = 0;
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            int n4 = nodeRef.getNumber();
            double d4 = 0.0;
            if (!this.missingTraits.isCompletelyMissing(n4)) {
                d4 = 1.0 / this.getLengthToRoot(nodeRef);
                int n5 = this.dim * n4;
                int n6 = this.dim * n;
                for (int j = 0; j < this.numData; ++j) {
                    for (int k = 0; k < this.dimTrait; ++k) {
                        int n7 = n6 + k;
                        this.meanCache[n7] = this.meanCache[n7] + d4 * this.meanCache[n5 + k];
                        dArray2[k] = this.meanCache[n5 + k];
                    }
                    double d5 = NonPhylogeneticMultivariateTraitLikelihood.computeWeightedAverageAndSumOfSquares(dArray2, this.Ay, dArray, this.dimTrait, d4);
                    d += d5;
                    n5 += this.dimTrait;
                    n6 += this.dimTrait;
                }
                if (this.computeWishartStatistics) {
                    this.incrementOuterProducts(n4, d4);
                }
            }
            if (!(d4 > 0.0)) continue;
            d3 += d4;
            d2 *= d4;
            ++n3;
        }
        this.lowerPrecisionCache[n] = d3;
        this.normalize(this.meanCache, n2, this.dim, d3);
        if (this.computeWishartStatistics) {
            this.incrementOuterProducts(n, -d3);
            this.wishartStatistics.incrementDf(-1);
        }
        return new SufficientStatistics(d3, d2, d, n3);
    }

    private void normalize(double[] dArray, int n, int n2, double d) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            dArray[n3] = dArray[n3] / d;
        }
    }

    private void incrementOuterProducts(int n, double d) {
        double[] dArray = this.wishartStatistics.getScaleMatrix();
        int n2 = this.dim * n;
        for (int i = 0; i < this.numData; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double d2 = this.meanCache[n2 + j];
                for (int k = 0; k < this.dim; ++k) {
                    int n3 = j * this.dim + k;
                    dArray[n3] = dArray[n3] + d2 * this.meanCache[n2 + k] * d;
                }
            }
            n2 += this.dimTrait;
        }
        this.wishartStatistics.incrementDf(1);
    }

    @Override
    protected boolean peel() {
        return false;
    }

    @Override
    public double calculateLogLikelihood() {
        double[][] dArray = this.diffusionModel.getPrecisionmatrix();
        double d = Math.log(this.diffusionModel.getDeterminantPrecisionMatrix());
        double[] dArray2 = this.tmp2;
        if (this.computeWishartStatistics) {
            this.wishartStatistics = new WishartSufficientStatistics(this.dimTrait);
        }
        SufficientStatistics sufficientStatistics = this.computeInnerProductsForTips(dArray, this.tmp2);
        double d2 = sufficientStatistics.sumWeight;
        double d3 = sufficientStatistics.productWeight;
        double d4 = sufficientStatistics.innerProduct;
        int n = sufficientStatistics.nonMissingTips;
        double d5 = d2 + this.rootPriorSampleSize;
        double d6 = d3 * this.rootPriorSampleSize;
        double d7 = d6 / d5;
        int n2 = this.treeModel.getRoot().getNumber();
        int n3 = this.dim * n2;
        for (int i = 0; i < this.numData; ++i) {
            for (int j = 0; j < this.dimTrait; ++j) {
                dArray2[j] = d2 * this.meanCache[n3 + j] + this.rootPriorSampleSize * this.rootPriorMean[j];
            }
            double d8 = NonPhylogeneticMultivariateTraitLikelihood.computeWeightedAverageAndSumOfSquares(this.rootPriorMean, this.Ay, dArray, this.dimTrait, this.rootPriorSampleSize);
            d4 += d8;
            double d9 = NonPhylogeneticMultivariateTraitLikelihood.computeWeightedAverageAndSumOfSquares(dArray2, this.Ay, dArray, this.dimTrait, 1.0 / d5);
            d4 -= d9;
            if (this.computeWishartStatistics) {
                double[] dArray3 = this.wishartStatistics.getScaleMatrix();
                double d10 = d2 * this.rootPriorSampleSize / d5;
                for (int j = 0; j < this.dimTrait; ++j) {
                    double d11 = this.meanCache[n3 + j] - this.rootPriorMean[j];
                    for (int k = 0; k < this.dimTrait; ++k) {
                        int n4 = j * this.dimTrait + k;
                        dArray3[n4] = dArray3[n4] + d11 * d10 * (this.meanCache[n3 + k] - this.rootPriorMean[k]);
                    }
                }
                this.wishartStatistics.incrementDf(1);
            }
            n3 += this.dimTrait;
        }
        double d12 = -LOG_SQRT_2_PI * (double)this.dimTrait * (double)n * (double)this.numData + 0.5 * d * (double)n * (double)this.numData + 0.5 * Math.log(d7) * (double)this.dimTrait * (double)this.numData - 0.5 * d4;
        this.areStatesRedrawn = false;
        return d12;
    }

    private class SufficientStatistics {
        double sumWeight;
        double productWeight;
        double innerProduct;
        int nonMissingTips;

        SufficientStatistics(double d, double d2, double d3, int n) {
            this.sumWeight = d;
            this.productWeight = d2;
            this.innerProduct = d3;
            this.nonMissingTips = n;
        }
    }
}

