/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.Arrays;

public class BranchMapModel
extends AbstractModel {
    private AbstractCase[] map;
    private AbstractCase[] storedMap;
    public static final String BRANCH_MAP_MODEL = "branchMapModel";

    public BranchMapModel(PartitionedTreeModel partitionedTreeModel) {
        super(BRANCH_MAP_MODEL);
        this.map = new AbstractCase[partitionedTreeModel.getNodeCount()];
        this.storedMap = new AbstractCase[partitionedTreeModel.getNodeCount()];
    }

    public void set(int n, AbstractCase abstractCase, boolean bl) {
        AbstractCase abstractCase2 = this.map[n];
        this.map[n] = abstractCase;
        if (!bl) {
            this.pushMapChangedEvent(new BranchMapChangedEvent(n, abstractCase2, abstractCase));
        }
    }

    public AbstractCase get(int n) {
        return this.map[n];
    }

    public void pushMapChangedEvents(ArrayList<BranchMapChangedEvent> arrayList) {
        this.listenerHelper.fireModelChanged(this, arrayList);
    }

    public void pushMapChangedEvent(BranchMapChangedEvent branchMapChangedEvent) {
        ArrayList<BranchMapChangedEvent> arrayList = new ArrayList<BranchMapChangedEvent>();
        arrayList.add(branchMapChangedEvent);
        this.pushMapChangedEvents(arrayList);
    }

    public AbstractCase[] getArray() {
        return this.map;
    }

    public void setAll(AbstractCase[] abstractCaseArray, boolean bl) {
        ArrayList<BranchMapChangedEvent> arrayList = new ArrayList<BranchMapChangedEvent>();
        for (int i = 0; i < this.map.length; ++i) {
            if (this.map[i] == abstractCaseArray[i]) continue;
            arrayList.add(new BranchMapChangedEvent(i, this.map[i], abstractCaseArray[i]));
        }
        if (!bl) {
            this.pushMapChangedEvents(arrayList);
        }
        this.map = abstractCaseArray;
    }

    public AbstractCase[] getArrayCopy() {
        return Arrays.copyOf(this.map, this.map.length);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    public int size() {
        return this.map.length;
    }

    @Override
    protected void storeState() {
        this.storedMap = Arrays.copyOf(this.map, this.map.length);
    }

    @Override
    protected void restoreState() {
        this.map = this.storedMap;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public class BranchMapChangedEvent {
        private final int nodeToRecalculate;
        private final AbstractCase oldCase;
        private final AbstractCase newCase;

        public BranchMapChangedEvent(int n, AbstractCase abstractCase, AbstractCase abstractCase2) {
            this.nodeToRecalculate = n;
            this.oldCase = abstractCase;
            this.newCase = abstractCase2;
        }

        public int getNodeToRecalculate() {
            return this.nodeToRecalculate;
        }

        public AbstractCase getOldCase() {
            return this.oldCase;
        }

        public AbstractCase getNewCase() {
            return this.newCase;
        }
    }
}

