/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class RateScaleOperator
extends AbstractAdaptableOperator {
    private TreeModel tree;
    private boolean noRoot;
    private double scaleFactor = 0.5;

    public RateScaleOperator(TreeModel treeModel, double d, boolean bl, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.scaleFactor = d;
        this.tree = treeModel;
        this.noRoot = bl;
    }

    @Override
    public final double doOperation() {
        int n;
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        if (this.noRoot) {
            while ((n = MathUtils.nextInt(this.tree.getNodeCount())) == this.tree.getRoot().getNumber()) {
            }
        } else {
            n = MathUtils.nextInt(this.tree.getNodeCount());
        }
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        this.getSubtree(arrayList, this.tree.getNode(n));
        double d2 = 0.0;
        for (NodeRef nodeRef : arrayList) {
            double d3 = this.tree.getNodeRate(nodeRef);
            double d4 = d3 * d;
            this.tree.setNodeRate(nodeRef, d4);
        }
        d2 = (double)(arrayList.size() - 2) * Math.log(d);
        return d2;
    }

    void getSubtree(List<NodeRef> list, NodeRef nodeRef) {
        list.add(nodeRef);
        int n = this.tree.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            this.getSubtree(list, this.tree.getChild(nodeRef, i));
        }
    }

    void cleanupOperation(double d, double d2) {
    }

    @Override
    public final String getOperatorName() {
        return "rateScale";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    public String toString() {
        return "rateScaleOperator( [" + this.scaleFactor + ", " + 1.0 / this.scaleFactor + "]";
    }
}

