/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.distribution.CauchyDistribution;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SubtreeLeapOperator
extends AbstractAdaptableTreeOperator {
    private double size;
    private final TreeModel tree;
    private final DistanceKernelType distanceKernel;
    private final boolean slideOnly;
    private final List<Integer> tips;

    public SubtreeLeapOperator(TreeModel treeModel, double d, double d2, DistanceKernelType distanceKernelType, AdaptationMode adaptationMode, double d3) {
        this(treeModel, d, d2, distanceKernelType, false, adaptationMode, d3);
    }

    public SubtreeLeapOperator(TreeModel treeModel, double d, double d2, DistanceKernelType distanceKernelType, boolean bl, AdaptationMode adaptationMode, double d3) {
        super(adaptationMode, d3);
        this.tree = treeModel;
        this.setWeight(d);
        this.size = d2;
        this.distanceKernel = distanceKernelType;
        this.slideOnly = bl;
        this.tips = null;
    }

    public SubtreeLeapOperator(TreeModel treeModel, TaxonList taxonList, double d, double d2, DistanceKernelType distanceKernelType, AdaptationMode adaptationMode, double d3) {
        super(adaptationMode, d3);
        this.tree = treeModel;
        this.setWeight(d);
        this.size = d2;
        this.distanceKernel = distanceKernelType;
        this.slideOnly = false;
        this.tips = new ArrayList<Integer>();
        for (Taxon taxon : taxonList) {
            boolean bl = false;
            for (int i = 0; i < treeModel.getExternalNodeCount(); ++i) {
                NodeRef nodeRef = treeModel.getExternalNode(i);
                if (!treeModel.getNodeTaxon(nodeRef).equals(taxon)) continue;
                this.tips.add(nodeRef.getNumber());
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException("Taxon, " + taxon.getId() + ", not found in tree with id " + treeModel.getId());
        }
    }

    @Override
    public double doOperation() {
        NodeRef nodeRef;
        double d = this.distanceKernel.getDelta(this.size);
        NodeRef nodeRef2 = this.tree.getRoot();
        if (this.tips == null) {
            while ((nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) == nodeRef2) {
            }
        } else {
            nodeRef = this.tree.getNode(this.tips.get(MathUtils.nextInt(this.tips.size())));
        }
        NodeRef nodeRef3 = this.tree.getParent(nodeRef);
        NodeRef nodeRef4 = this.getOtherChild(this.tree, nodeRef3, nodeRef);
        NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
        Map<NodeRef, Double> map = this.getDestinations(nodeRef, nodeRef3, nodeRef4, d, this.slideOnly);
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(map.keySet());
        int n = MathUtils.nextInt(map.size());
        double d2 = 1.0 / (double)map.size();
        NodeRef nodeRef6 = (NodeRef)arrayList.get(n);
        double d3 = map.get(nodeRef6);
        NodeRef nodeRef7 = this.tree.getParent(nodeRef6);
        if (nodeRef7 != null && d3 > this.tree.getNodeHeight(nodeRef7)) {
            throw new IllegalArgumentException("height error");
        }
        if (d3 < this.tree.getNodeHeight(nodeRef6)) {
            throw new IllegalArgumentException("height error");
        }
        this.tree.beginTreeEdit();
        if (nodeRef6 != nodeRef3 && nodeRef7 != nodeRef3) {
            if (nodeRef5 == null) {
                this.tree.removeChild(nodeRef3, nodeRef4);
                this.tree.setRoot(nodeRef4);
            } else {
                this.tree.removeChild(nodeRef3, nodeRef4);
                this.tree.removeChild(nodeRef5, nodeRef3);
                this.tree.addChild(nodeRef5, nodeRef4);
            }
            if (nodeRef7 == null) {
                this.tree.addChild(nodeRef3, nodeRef6);
                this.tree.setRoot(nodeRef3);
            } else {
                this.tree.removeChild(nodeRef7, nodeRef6);
                this.tree.addChild(nodeRef3, nodeRef6);
                this.tree.addChild(nodeRef7, nodeRef3);
            }
        }
        this.tree.setNodeHeight(nodeRef3, d3);
        this.tree.endTreeEdit();
        if (this.tree.getParent(nodeRef3) != null && d3 > this.tree.getNodeHeight(this.tree.getParent(nodeRef3))) {
            throw new IllegalArgumentException("height error");
        }
        if (d3 < this.tree.getNodeHeight(nodeRef)) {
            throw new IllegalArgumentException("height error");
        }
        if (d3 < this.tree.getNodeHeight(this.getOtherChild(this.tree, nodeRef3, nodeRef))) {
            throw new IllegalArgumentException("height error");
        }
        Map<NodeRef, Double> map2 = this.getDestinations(nodeRef, nodeRef3, this.getOtherChild(this.tree, nodeRef3, nodeRef), d, this.slideOnly);
        double d4 = 1.0 / (double)map2.size();
        double d5 = Math.log(d4) - Math.log(d2);
        return d5;
    }

    private Map<NodeRef, Double> getDestinations(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, double d, boolean bl) {
        NodeRef nodeRef42;
        LinkedHashMap<NodeRef, Double> linkedHashMap = new LinkedHashMap<NodeRef, Double>();
        double d2 = this.tree.getNodeHeight(nodeRef2);
        double d3 = d2 - d;
        if (d3 > this.tree.getNodeHeight(nodeRef)) {
            ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
            this.getIntersectingEdges(this.tree, nodeRef3, d3, arrayList);
            for (NodeRef nodeRef42 : arrayList) {
                linkedHashMap.put(nodeRef42, d3);
            }
        }
        double d4 = d2 + d;
        nodeRef42 = nodeRef2;
        boolean bl2 = false;
        while (!bl2) {
            NodeRef nodeRef5 = this.tree.getParent(nodeRef42);
            if (nodeRef5 != null) {
                double d5 = this.tree.getNodeHeight(nodeRef5);
                if (d5 < d4) {
                    if (!bl) {
                        NodeRef nodeRef6 = this.getOtherChild(this.tree, nodeRef5, nodeRef42);
                        double d6 = d5 - (d4 - d5);
                        if (d6 > this.tree.getNodeHeight(nodeRef)) {
                            ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
                            this.getIntersectingEdges(this.tree, nodeRef6, d6, arrayList);
                            for (NodeRef nodeRef7 : arrayList) {
                                linkedHashMap.put(nodeRef7, d6);
                            }
                        }
                    }
                } else {
                    linkedHashMap.put(nodeRef42, d4);
                    bl2 = true;
                }
                nodeRef42 = nodeRef5;
                continue;
            }
            linkedHashMap.put(nodeRef42, d4);
            bl2 = true;
        }
        return linkedHashMap;
    }

    private int getIntersectingEdges(Tree tree, NodeRef nodeRef, double d, List<NodeRef> list) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (tree.getNodeHeight(nodeRef2) < d) {
            return 0;
        }
        if (tree.getNodeHeight(nodeRef) < d) {
            list.add(nodeRef);
            return 1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            n += this.getIntersectingEdges(tree, tree.getChild(nodeRef, i), d, list);
        }
        return n;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        assert (Double.isFinite(d));
        this.size = d;
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        if (this.tips == null) {
            return "subtreeLeap(" + this.tree.getId() + ")";
        }
        return "tipLeap(" + this.tree.getId() + ")";
    }

    public static enum DistanceKernelType {
        NORMAL("normal"){

            @Override
            double getDelta(double d) {
                return Math.abs(MathUtils.nextGaussian() * d);
            }
        }
        ,
        CAUCHY("Cauchy"){

            @Override
            double getDelta(double d) {
                CauchyDistribution cauchyDistribution = new CauchyDistribution(0.0, d);
                double d2 = MathUtils.nextDouble();
                return Math.abs(cauchyDistribution.quantile(d2));
            }
        };

        String name;

        private DistanceKernelType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        abstract double getDelta(double var1);
    }
}

