/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import cern.colt.matrix.DoubleMatrix2D;
import dr.evomodel.substmodel.ColtEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.math.matrixAlgebra.RobustEigenDecomposition;
import java.util.Arrays;

public class ComplexColtEigenSystem
extends ColtEigenSystem {
    public ComplexColtEigenSystem(int n) {
        super(n);
    }

    public ComplexColtEigenSystem(int n, boolean bl, int n2, int n3) {
        super(n, bl, n2, n3);
    }

    @Override
    protected double[] getAllEigenValues(RobustEigenDecomposition robustEigenDecomposition) {
        double[] dArray = robustEigenDecomposition.getRealEigenvalues().toArray();
        double[] dArray2 = robustEigenDecomposition.getImagEigenvalues().toArray();
        int n = dArray.length;
        double[] dArray3 = new double[2 * n];
        System.arraycopy(dArray, 0, dArray3, 0, n);
        System.arraycopy(dArray2, 0, dArray3, n, n);
        return dArray3;
    }

    @Override
    protected double[] getEmptyAllEigenValues(int n) {
        return new double[2 * n];
    }

    protected boolean validDecomposition(DoubleMatrix2D doubleMatrix2D) {
        return true;
    }

    @Override
    public double computeExponential(EigenDecomposition eigenDecomposition, double d, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void computeExponential(EigenDecomposition eigenDecomposition, double d, double[] dArray) {
        int n;
        double d2;
        int n2;
        if (eigenDecomposition == null) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        double[] dArray2 = eigenDecomposition.getEigenVectors();
        double[] dArray3 = eigenDecomposition.getEigenValues();
        double[] dArray4 = new double[this.stateCount];
        System.arraycopy(dArray3, this.stateCount, dArray4, 0, this.stateCount);
        double[] dArray5 = eigenDecomposition.getInverseEigenVectors();
        double[][] dArray6 = new double[this.stateCount][this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            if (dArray4[n2] == 0.0) {
                d2 = Math.exp(d * dArray3[n2]);
                for (n = 0; n < this.stateCount; ++n) {
                    dArray6[n2][n] = dArray5[n2 * this.stateCount + n] * d2;
                }
                continue;
            }
            n = n2 + 1;
            double d3 = dArray4[n2];
            double d4 = Math.exp(d * dArray3[n2]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            for (int i = 0; i < this.stateCount; ++i) {
                dArray6[n2][i] = d5 * dArray5[n2 * this.stateCount + i] + d6 * dArray5[n * this.stateCount + i];
                dArray6[n][i] = d5 * dArray5[n * this.stateCount + i] - d6 * dArray5[n2 * this.stateCount + i];
            }
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < this.stateCount; ++n) {
            for (int i = 0; i < this.stateCount; ++i) {
                d2 = 0.0;
                for (int j = 0; j < this.stateCount; ++j) {
                    d2 += dArray2[n * this.stateCount + j] * dArray6[j][i];
                }
                dArray[n2] = Math.abs(d2);
                ++n2;
            }
        }
    }
}

