/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.transmission;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.transmission.TransmissionHistoryModel;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.BooleanStatistic;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.HashSet;
import java.util.Set;

public class TransmissionStatistic
extends TreeStatistic
implements BooleanStatistic {
    public static final String TRANSMISSION_STATISTIC = "transmissionStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("name", "A name for this statistic for the purpose of logging"), new XORRule(new ElementRule("hostTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)}), new ElementRule(TransmissionHistoryModel.class, "This describes the transmission history of the patients.")), new ElementRule("parasiteTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)})};

        @Override
        public String getParserName() {
            return TransmissionStatistic.TRANSMISSION_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("name");
            Tree tree = (Tree)xMLObject.getElementFirstChild("parasiteTree");
            if (xMLObject.getChild(TransmissionHistoryModel.class) != null) {
                TransmissionHistoryModel transmissionHistoryModel = (TransmissionHistoryModel)xMLObject.getChild(TransmissionHistoryModel.class);
                return new TransmissionStatistic(string, transmissionHistoryModel, tree);
            }
            Tree tree2 = (Tree)xMLObject.getElementFirstChild("hostTree");
            return new TransmissionStatistic(string, tree2, tree);
        }

        @Override
        public String getParserDescription() {
            return "A statistic that returns true if the given parasite tree is compatible with the host tree.";
        }

        @Override
        public Class getReturnType() {
            return Statistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Tree hostTree = null;
    private TransmissionHistoryModel transmissionHistoryModel = null;
    private Tree virusTree = null;
    private int hostCount;
    private int[] donorHost;
    private double[] transmissionTime;

    public TransmissionStatistic(String string, TransmissionHistoryModel transmissionHistoryModel, Tree tree) {
        super(string);
        this.transmissionHistoryModel = transmissionHistoryModel;
        this.virusTree = tree;
        this.setupHosts();
    }

    public TransmissionStatistic(String string, Tree tree, Tree tree2) {
        super(string);
        this.hostTree = tree;
        this.virusTree = tree2;
        this.setupHosts();
    }

    private void setupHosts() {
        this.hostCount = this.transmissionHistoryModel != null ? this.transmissionHistoryModel.getHostCount() : this.hostTree.getTaxonCount();
        this.donorHost = new int[this.hostCount];
        this.donorHost[0] = -1;
        this.transmissionTime = new double[this.hostCount];
        this.transmissionTime[0] = Double.POSITIVE_INFINITY;
        if (this.transmissionHistoryModel != null) {
            for (int i = 0; i < this.transmissionHistoryModel.getTransmissionEventCount(); ++i) {
                TransmissionHistoryModel.TransmissionEvent transmissionEvent = this.transmissionHistoryModel.getTransmissionEvent(i);
                int n = this.transmissionHistoryModel.getHostIndex(transmissionEvent.getDonor());
                int n2 = this.transmissionHistoryModel.getHostIndex(transmissionEvent.getRecipient());
                this.donorHost[n2] = n;
                this.transmissionTime[n2] = transmissionEvent.getTransmissionTime();
            }
        } else {
            this.setupHostsTree(this.hostTree.getRoot());
        }
    }

    private int setupHostsTree(NodeRef nodeRef) {
        int n;
        if (this.hostTree.isExternal(nodeRef)) {
            n = nodeRef.getNumber();
        } else {
            int n2 = this.setupHostsTree(this.hostTree.getChild(nodeRef, 0));
            int n3 = this.setupHostsTree(this.hostTree.getChild(nodeRef, 1));
            this.donorHost[n3] = n2;
            this.transmissionTime[n3] = this.hostTree.getNodeHeight(nodeRef);
            n = n2;
        }
        return n;
    }

    @Override
    public void setTree(Tree tree) {
        this.virusTree = tree;
    }

    @Override
    public Tree getTree() {
        return this.virusTree;
    }

    @Override
    public String getDimensionName(int n) {
        String string = this.transmissionHistoryModel.getHost(n).getId();
        String string2 = this.donorHost[n] == -1 ? "" : this.transmissionHistoryModel.getHost(this.donorHost[n]).getId() + "->";
        return "transmission(" + string2 + string + ")";
    }

    @Override
    public int getDimension() {
        return this.hostCount;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.setupHosts();
        this.isCompatible(this.virusTree.getRoot(), hashSet);
        return !hashSet.contains(n);
    }

    private int isCompatible(NodeRef nodeRef, Set<Integer> set) {
        int n;
        double d = this.virusTree.getNodeHeight(nodeRef);
        if (this.virusTree.isExternal(nodeRef)) {
            Taxon taxon = (Taxon)this.virusTree.getTaxonAttribute(nodeRef.getNumber(), "host");
            n = this.transmissionHistoryModel != null ? this.transmissionHistoryModel.getHostIndex(taxon) : this.hostTree.getTaxonIndex(taxon);
            if (n != -1 && d > this.transmissionTime[n]) {
                throw new RuntimeException("Sequence " + this.virusTree.getNodeTaxon(nodeRef) + ", was sampled (" + d + ") before host, " + taxon + ", was infected (" + this.transmissionTime[n] + ")");
            }
        } else {
            int n2;
            int n3 = this.isCompatible(this.virusTree.getChild(nodeRef, 0), set);
            if (n3 == (n2 = this.isCompatible(this.virusTree.getChild(nodeRef, 1), set))) {
                n = n3;
                while (d > this.transmissionTime[n]) {
                    n = this.donorHost[n];
                }
            } else {
                while (d > this.transmissionTime[n3]) {
                    n3 = this.donorHost[n3];
                }
                while (d > this.transmissionTime[n2]) {
                    n2 = this.donorHost[n2];
                }
                if (n3 != n2) {
                    if (this.transmissionTime[n3] < this.transmissionTime[n2]) {
                        set.add(n3);
                        n = n2;
                    } else {
                        set.add(n2);
                        n = n3;
                    }
                } else {
                    n = n3;
                }
            }
        }
        return n;
    }
}

