/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.BooleanStatistic;
import java.util.HashSet;
import java.util.Set;

public class SpeciesTreeStatistic
extends TreeStatistic
implements BooleanStatistic {
    private Tree speciesTree;
    private Tree popTree;

    public SpeciesTreeStatistic(String string, Tree tree, Tree tree2) {
        super(string);
        this.speciesTree = tree;
        this.popTree = tree2;
    }

    @Override
    public void setTree(Tree tree) {
        this.popTree = tree;
    }

    @Override
    public Tree getTree() {
        return this.popTree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        if (this.popTree.getNodeHeight(this.popTree.getRoot()) < this.speciesTree.getNodeHeight(this.speciesTree.getRoot())) {
            return false;
        }
        return this.isCompatible(this.popTree.getRoot(), null);
    }

    private boolean isCompatible(NodeRef nodeRef, Set<String> set) {
        if (this.popTree.isExternal(nodeRef)) {
            Taxon taxon = (Taxon)this.popTree.getTaxonAttribute(nodeRef.getNumber(), "species");
            set.add(taxon.getId());
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            int n = this.popTree.getChildCount(nodeRef);
            for (int i = 0; i < n; ++i) {
                if (this.isCompatible(this.popTree.getChild(nodeRef, i), hashSet)) continue;
                return false;
            }
            if (set != null) {
                set.addAll(hashSet);
                NodeRef nodeRef2 = TreeUtils.getCommonAncestorNode(this.speciesTree, hashSet);
                if (this.popTree.getNodeHeight(nodeRef) < this.speciesTree.getNodeHeight(nodeRef2)) {
                    return false;
                }
            }
        }
        return true;
    }
}

