/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.LogTricks;
import dr.math.MathUtils;
import dr.math.Polynomial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UniformNodeHeightPrior
extends AbstractModelLikelihood {
    public static final int MAX_ANALYTIC_TIPS = 60;
    public static final int DEFAULT_MC_SAMPLE = 100000;
    private static final double tolerance = 1.0E-6;
    private int k = 0;
    private double logFactorialK;
    private double maxRootHeight;
    private boolean isNicholls;
    private boolean useAnalytic;
    private boolean useMarginal;
    private boolean leadingTerm;
    private int mcSampleSize;
    Set<Double> tipDates = new TreeSet<Double>();
    List<Double> reversedTipDateList = new ArrayList<Double>();
    Map<Double, Integer> intervals = new TreeMap<Double, Integer>();
    private static final double INV_PRECISION = 10.0;
    Tree tree = null;
    double logLikelihood;
    private double storedLogLikelihood;
    boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;
    private boolean treePolynomialKnown = false;
    private boolean storedTreePolynomialKnown = false;
    private Polynomial treePolynomial;
    private Polynomial[] treePolynomials;
    private Polynomial storedTreePolynomial;
    private double tmpLogLikelihood;
    private Polynomial.Type polynomialType;
    private double[] logLikelihoods;
    private double[][] drawNodeHeights;
    private double[] minNodeHeights;

    public UniformNodeHeightPrior(Tree tree, boolean bl, boolean bl2, boolean bl3) {
        this("uniformNodeHeightPrior", tree, bl, 100000, bl2, bl3);
    }

    public UniformNodeHeightPrior(Tree tree, boolean bl, int n) {
        this("uniformNodeHeightPrior", tree, bl, n, false, false);
    }

    private UniformNodeHeightPrior(String string, Tree tree, boolean bl, int n, boolean bl2, boolean bl3) {
        super(string);
        this.tree = tree;
        this.isNicholls = false;
        this.useAnalytic = bl;
        this.useMarginal = bl2;
        this.mcSampleSize = n;
        this.leadingTerm = bl3;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            double d = tree.getNodeHeight(tree.getExternalNode(i));
            this.tipDates.add(d);
        }
        if (this.tipDates.size() == 1 || bl3) {
            this.k = tree.getInternalNodeCount() - 1;
            Logger.getLogger("dr.evomodel").info("Uniform Node Height Prior, Intervals = " + (this.k + 1));
            this.logFactorialK = this.logFactorial(this.k);
        } else {
            this.reversedTipDateList.addAll(this.tipDates);
            Collections.reverse(this.reversedTipDateList);
            double d = tree.getNodeHeight(tree.getRoot());
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (Double d2 : this.reversedTipDateList) {
                if (d - d2 < 1.0E-6) {
                    arrayList.add(d);
                }
                d = d2;
            }
            for (Double d2 : arrayList) {
                this.reversedTipDateList.remove(d2);
            }
            if (!bl) {
                this.logLikelihoods = new double[n];
                this.drawNodeHeights = new double[tree.getNodeCount()][n];
                this.minNodeHeights = new double[tree.getNodeCount()];
            }
        }
        this.polynomialType = tree.getExternalNodeCount() < 30 ? Polynomial.Type.DOUBLE : (tree.getExternalNodeCount() < 45 ? Polynomial.Type.LOG_DOUBLE : Polynomial.Type.LOG_DOUBLE);
        Logger.getLogger("dr.evomodel").info("Using " + (Object)((Object)this.polynomialType) + " polynomials!");
    }

    public UniformNodeHeightPrior(Tree tree, double d) {
        this("uniformNodeHeightPrior", tree, d);
    }

    private UniformNodeHeightPrior(String string, Tree tree, double d) {
        super(string);
        this.tree = tree;
        this.maxRootHeight = d;
        this.isNicholls = true;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
    }

    UniformNodeHeightPrior(String string) {
        super(string);
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
        this.treePolynomialKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected final void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected final void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
        this.treePolynomialKnown = false;
    }

    public double calculateLogLikelihood() {
        double d;
        double d2 = this.tree.getNodeHeight(this.tree.getRoot());
        if (this.isNicholls) {
            int n = this.tree.getExternalNodeCount();
            if (d2 < 0.0 || d2 > 0.999 * this.maxRootHeight) {
                return Double.NEGATIVE_INFINITY;
            }
            return d2 * (double)(2 - n) - Math.log(this.maxRootHeight - d2);
        }
        if (this.k > 0) {
            d = this.logFactorialK - (double)this.k * Math.log(d2);
        } else if (this.useAnalytic) {
            if (this.useMarginal) {
                if (!this.treePolynomialKnown) {
                    this.treePolynomials = this.constructRootPolyonmials(this.tree, this.polynomialType);
                    this.treePolynomialKnown = true;
                }
                if (Double.isNaN(d = -this.treePolynomials[0].logEvaluate(d2) - this.treePolynomials[1].logEvaluate(d2)) && Double.isNaN(d = -this.treePolynomials[0].logEvaluateHorner(d2) - this.treePolynomials[1].logEvaluateHorner(d2))) {
                    d = Double.NEGATIVE_INFINITY;
                }
            } else {
                this.tmpLogLikelihood = 0.0;
                this.recursivelyComputeDensity(this.tree, this.tree.getRoot(), 0.0);
                d = this.tmpLogLikelihood;
            }
        } else {
            double[] dArray = this.drawNodeHeights[this.tree.getRoot().getNumber()];
            Arrays.fill(dArray, d2);
            this.recursivelyFindNodeMinHeights(this.tree, this.tree.getRoot());
            Arrays.fill(this.logLikelihoods, 0.0);
            this.recursivelyComputeMCIntegral(this.tree, this.tree.getRoot(), this.tree.getRoot().getNumber());
            d = -LogTricks.logSum(this.logLikelihoods) + Math.log(this.mcSampleSize);
        }
        assert (!Double.isInfinite(d) && !Double.isNaN(d));
        return d;
    }

    private double recursivelyComputeDensity(Tree tree, NodeRef nodeRef, double d) {
        double d2;
        double d3;
        if (tree.isExternal(nodeRef)) {
            return tree.getNodeHeight(nodeRef);
        }
        double d4 = tree.getNodeHeight(nodeRef);
        double d5 = this.recursivelyComputeDensity(tree, tree.getChild(nodeRef, 0), d4);
        double d6 = d3 = d5 > (d2 = this.recursivelyComputeDensity(tree, tree.getChild(nodeRef, 1), d4)) ? d5 : d2;
        if (!tree.isRoot(nodeRef)) {
            double d7 = d - d3;
            this.tmpLogLikelihood = d7 <= 0.0 ? Double.NEGATIVE_INFINITY : (this.tmpLogLikelihood -= Math.log(d7));
        }
        return d3;
    }

    private double recursivelyFindNodeMinHeights(Tree tree, NodeRef nodeRef) {
        double d;
        double d2;
        double d3 = tree.isExternal(nodeRef) ? tree.getNodeHeight(nodeRef) : ((d2 = this.recursivelyFindNodeMinHeights(tree, tree.getChild(nodeRef, 0))) > (d = this.recursivelyFindNodeMinHeights(tree, tree.getChild(nodeRef, 1))) ? d2 : d);
        this.minNodeHeights[nodeRef.getNumber()] = d3;
        return d3;
    }

    private void recursivelyComputeMCIntegral(Tree tree, NodeRef nodeRef, int n) {
        if (tree.isExternal(nodeRef)) {
            return;
        }
        int n2 = nodeRef.getNumber();
        if (!tree.isRoot(nodeRef)) {
            double[] dArray = this.drawNodeHeights[n];
            double[] dArray2 = this.drawNodeHeights[n2];
            double d = this.minNodeHeights[n2];
            boolean bl = tree.isExternal(tree.getChild(nodeRef, 0)) && tree.isExternal(tree.getChild(nodeRef, 1));
            int n3 = 0;
            while (n3 < this.mcSampleSize) {
                double d2 = dArray[n3] - d;
                if (d2 <= 0.0) {
                    this.logLikelihoods[n3] = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (!bl) {
                    dArray2[n3] = MathUtils.nextDouble() * d2 + d;
                }
                int n4 = n3++;
                this.logLikelihoods[n4] = this.logLikelihoods[n4] + Math.log(d2);
            }
        }
        this.recursivelyComputeMCIntegral(tree, tree.getChild(nodeRef, 0), n2);
        this.recursivelyComputeMCIntegral(tree, tree.getChild(nodeRef, 1), n2);
    }

    private static double round(double d) {
        return (double)Math.round(d * 10.0) / 10.0;
    }

    private Polynomial[] constructRootPolyonmials(Tree tree, Polynomial.Type type) {
        NodeRef nodeRef = tree.getRoot();
        return new Polynomial[]{this.recursivelyComputePolynomial(tree, tree.getChild(nodeRef, 0), type).getPolynomial(), this.recursivelyComputePolynomial(tree, tree.getChild(nodeRef, 1), type).getPolynomial()};
    }

    private TipLabeledPolynomial recursivelyComputePolynomial(Tree tree, NodeRef nodeRef, Polynomial.Type type) {
        if (tree.isExternal(nodeRef)) {
            double[] dArray = new double[]{1.0};
            double d = UniformNodeHeightPrior.round(tree.getNodeHeight(nodeRef));
            return new TipLabeledPolynomial(dArray, d, type, true);
        }
        TipLabeledPolynomial tipLabeledPolynomial = this.recursivelyComputePolynomial(tree, tree.getChild(nodeRef, 0), type);
        TipLabeledPolynomial tipLabeledPolynomial2 = this.recursivelyComputePolynomial(tree, tree.getChild(nodeRef, 1), type);
        TipLabeledPolynomial tipLabeledPolynomial3 = tipLabeledPolynomial.multiply(tipLabeledPolynomial2);
        if (!tree.isRoot(nodeRef)) {
            tipLabeledPolynomial3 = tipLabeledPolynomial3.integrateWithLowerBound(tipLabeledPolynomial3.label);
        }
        return tipLabeledPolynomial3;
    }

    private double logFactorial(int n) {
        if (n == 0 || n == 1) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = n; i > 1; --i) {
            d += Math.log(i);
        }
        return d;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("createElement not implemented");
    }

    class TipLabeledPolynomial
    extends Polynomial.Abstract {
        private double label;
        private Polynomial polynomial;
        private boolean isTip;

        TipLabeledPolynomial(double[] dArray, double d, Polynomial.Type type, boolean bl) {
            switch (type) {
                case DOUBLE: {
                    this.polynomial = new Polynomial.Double(dArray);
                    break;
                }
                case LOG_DOUBLE: {
                    this.polynomial = new Polynomial.LogDouble(dArray);
                    break;
                }
                case BIG_DOUBLE: {
                    this.polynomial = new Polynomial.BigDouble(dArray);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown polynomial type");
                }
            }
            this.label = d;
            this.isTip = bl;
        }

        TipLabeledPolynomial(Polynomial polynomial, double d, boolean bl) {
            this.polynomial = polynomial;
            this.label = d;
            this.isTip = bl;
        }

        @Override
        public TipLabeledPolynomial copy() {
            Polynomial polynomial = this.polynomial.copy();
            return new TipLabeledPolynomial(polynomial, this.label, this.isTip);
        }

        @Override
        public Polynomial getPolynomial() {
            return this.polynomial;
        }

        public TipLabeledPolynomial multiply(TipLabeledPolynomial tipLabeledPolynomial) {
            double d = Math.max(this.label, tipLabeledPolynomial.label);
            return new TipLabeledPolynomial(this.polynomial.multiply(tipLabeledPolynomial), d, false);
        }

        @Override
        public int getDegree() {
            return this.polynomial.getDegree();
        }

        @Override
        public Polynomial multiply(Polynomial polynomial) {
            return this.polynomial.multiply(polynomial);
        }

        @Override
        public Polynomial integrate() {
            return this.polynomial.integrate();
        }

        @Override
        public void expand(double d) {
            this.polynomial.expand(d);
        }

        @Override
        public double evaluate(double d) {
            return this.polynomial.evaluate(d);
        }

        @Override
        public double logEvaluate(double d) {
            return this.polynomial.logEvaluate(d);
        }

        @Override
        public double logEvaluateHorner(double d) {
            return this.polynomial.logEvaluateHorner(d);
        }

        @Override
        public void setCoefficient(int n, double d) {
            this.polynomial.setCoefficient(n, d);
        }

        @Override
        public TipLabeledPolynomial integrateWithLowerBound(double d) {
            return new TipLabeledPolynomial(this.polynomial.integrateWithLowerBound(d), this.label, this.isTip);
        }

        @Override
        public double getCoefficient(int n) {
            return this.polynomial.getCoefficient(n);
        }

        @Override
        public String toString() {
            return this.polynomial.toString() + " {" + this.label + "}";
        }

        @Override
        public String getCoefficientString(int n) {
            return this.polynomial.getCoefficientString(n);
        }
    }
}

