/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import java.util.Arrays;

public abstract class TreeTraversal {
    protected final Tree treeModel;
    protected final BranchRateModel branchRateModel;
    protected final boolean[] updateNode;
    protected boolean updateAllNodes;
    protected final TraversalType traversalType;

    protected TreeTraversal(Tree tree, BranchRateModel branchRateModel, TraversalType traversalType) {
        this.treeModel = tree;
        this.branchRateModel = branchRateModel;
        this.traversalType = traversalType;
        this.updateNode = new boolean[tree.getNodeCount()];
        this.updateAllNodes();
    }

    public abstract void dispatchTreeTraversalCollectBranchAndNodeOperations();

    public final Tree getTree() {
        return this.treeModel;
    }

    public final void setAllNodesUpdated() {
        Arrays.fill(this.updateNode, false);
        this.updateAllNodes = false;
    }

    public final void updateAllNodes() {
        Arrays.fill(this.updateNode, true);
        this.updateAllNodes = true;
    }

    public final void updateNode(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
    }

    public final void updateNodeAndChildren(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNode[nodeRef2.getNumber()] = true;
        }
    }

    public final void updateNodeAndDescendents(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNodeAndDescendents(nodeRef2);
        }
    }

    public final void updateNodeAndAncestors(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        if (!this.treeModel.isRoot(nodeRef)) {
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            this.updateNodeAndAncestors(nodeRef2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final double computeBranchLength(Tree tree, NodeRef nodeRef) {
        double d;
        BranchRateModel branchRateModel = this.branchRateModel;
        synchronized (branchRateModel) {
            d = this.branchRateModel.getBranchRate(tree, nodeRef);
        }
        double d2 = tree.getNodeHeight(tree.getParent(nodeRef));
        double d3 = tree.getNodeHeight(nodeRef);
        double d4 = d * (d2 - d3);
        assert (d4 >= 0.0) : "Negative branch length: " + d4 + " for node " + nodeRef.getNumber() + (tree.isExternal(nodeRef) ? " (" + tree.getNodeTaxon(nodeRef).getId() + ")" : "");
        return d4;
    }

    public static enum TraversalType {
        POST_ORDER,
        REVERSE_LEVEL_ORDER,
        PRE_ORDER;

    }
}

