/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.coalescent.TreeIntervalList;
import dr.evomodel.coalescent.GMRFSkyrideLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.discrete.AbstractNodeHeightTransformDelegate;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

@Deprecated
public class NodeHeightToCoalescentIntervalsDelegate
extends AbstractNodeHeightTransformDelegate {
    private GMRFSkyrideLikelihood skyrideLikelihood;
    private Parameter coalescentIntervals;
    private TreeIntervalList intervalNodeMapping;
    private boolean proxyValuesKnown;

    public NodeHeightToCoalescentIntervalsDelegate(TreeModel treeModel, Parameter parameter, GMRFSkyrideLikelihood gMRFSkyrideLikelihood) {
        super(treeModel, parameter);
        this.skyrideLikelihood = gMRFSkyrideLikelihood;
        TreeIntervalList treeIntervalList = (TreeIntervalList)gMRFSkyrideLikelihood.getIntervalList();
        assert (treeIntervalList.isBuildIntervalNodeMapping());
        this.intervalNodeMapping = treeIntervalList;
        this.coalescentIntervals = this.createProxyForCoalescentIntervals();
        this.coalescentIntervals.addBounds(new CoalescentIntervalBounds());
        this.addVariable(this.coalescentIntervals);
        this.proxyValuesKnown = false;
    }

    @Override
    public double[] setMaskByHeightDifference(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double[] setMaskByRatio(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    double[] transform(double[] dArray) {
        this.setNodeHeights(dArray);
        this.skyrideLikelihood.setupCoalescentIntervals();
        return this.coalescentIntervals.getParameterValues();
    }

    @Override
    double[] inverse(double[] dArray) {
        if (dArray.length != this.coalescentIntervals.getDimension()) {
            throw new RuntimeException("Dimension mismatch!");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            int[] nArray = this.intervalNodeMapping.getNodeNumbersForInterval(i);
            this.tree.setNodeHeightQuietly(this.tree.getNode(nArray[nArray.length - 1]), d += dArray[i]);
        }
        this.tree.pushTreeChangedEvent();
        return this.nodeHeights.getParameterValues();
    }

    @Override
    String getReport() {
        return null;
    }

    @Override
    Parameter getParameter() {
        return this.coalescentIntervals;
    }

    @Override
    double getLogJacobian(double[] dArray) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.proxyValuesKnown = false;
    }

    private Parameter createProxyForCoalescentIntervals() {
        return new Parameter.Proxy("coalescentIntervals", this.skyrideLikelihood.getCoalescentIntervalDimension()){
            private double[] proxy;
            private Bounds<Double> bounds;
            {
                this.bounds = null;
                this.proxy = new double[this.dim];
            }

            @Override
            public double getParameterValue(int n) {
                this.updateCoalescentIntervals();
                return this.proxy[n];
            }

            @Override
            public void setParameterValue(int n, double d) {
                this.setParameterValueQuietly(n, d);
                this.updateAllNodeHeights();
                NodeHeightToCoalescentIntervalsDelegate.this.proxyValuesKnown = false;
            }

            @Override
            public void setParameterValueQuietly(int n, double d) {
                this.proxy[n] = d;
            }

            @Override
            public void setParameterValueNotifyChangedAll(int n, double d) {
                this.setParameterValue(n, d);
            }

            @Override
            public void addBounds(Bounds<Double> bounds) {
                if (this.bounds != null) {
                    throw new RuntimeException("Not yet implemented for multiple use of addBounds.");
                }
                this.bounds = bounds;
            }

            @Override
            public Bounds<Double> getBounds() {
                if (this.bounds == null) {
                    throw new NullPointerException(this.getParameterName() + " parameter: Bounds not set");
                }
                return this.bounds;
            }

            @Override
            public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
                this.updateAllNodeHeights();
            }

            private void updateCoalescentIntervals() {
                if (!NodeHeightToCoalescentIntervalsDelegate.this.proxyValuesKnown) {
                    System.arraycopy(NodeHeightToCoalescentIntervalsDelegate.this.intervalNodeMapping.getCoalescentIntervals(), 0, this.proxy, 0, this.proxy.length);
                    ((CoalescentIntervalBounds)this.getBounds()).setupBounds();
                    NodeHeightToCoalescentIntervalsDelegate.this.proxyValuesKnown = true;
                }
            }

            private void updateAllNodeHeights() {
                this.updateCoalescentIntervals();
                NodeHeightToCoalescentIntervalsDelegate.this.inverse(this.proxy);
            }
        };
    }

    private class CoalescentIntervalBounds
    implements Bounds<Double> {
        private final int dim;
        private double[] upperBounds;
        private double[] lowerBounds;

        public CoalescentIntervalBounds() {
            this.dim = NodeHeightToCoalescentIntervalsDelegate.this.coalescentIntervals.getDimension();
            this.upperBounds = new double[this.dim];
            this.lowerBounds = new double[this.dim];
            this.setupBounds();
        }

        public void setupBounds() {
            if (!NodeHeightToCoalescentIntervalsDelegate.this.proxyValuesKnown) {
                double d = Double.POSITIVE_INFINITY;
                this.upperBounds[this.dim - 1] = Double.POSITIVE_INFINITY;
                for (int i = this.dim - 2; i > -1; --i) {
                    double d2;
                    int[] nArray = NodeHeightToCoalescentIntervalsDelegate.this.intervalNodeMapping.getNodeNumbersForInterval(i + 1);
                    double d3 = d2 = nArray.length > 1 ? NodeHeightToCoalescentIntervalsDelegate.this.tree.getNodeHeight(NodeHeightToCoalescentIntervalsDelegate.this.tree.getNode(nArray[1])) - NodeHeightToCoalescentIntervalsDelegate.this.tree.getNodeHeight(NodeHeightToCoalescentIntervalsDelegate.this.tree.getNode(nArray[0])) : Double.POSITIVE_INFINITY;
                    if (d > d2) {
                        d = d2;
                    }
                    this.upperBounds[i] = NodeHeightToCoalescentIntervalsDelegate.this.skyrideLikelihood.getCoalescentInterval(i) + d;
                }
                double d4 = Double.POSITIVE_INFINITY;
                for (int i = this.dim - 1; i > -1; --i) {
                    double d5;
                    int[] nArray = NodeHeightToCoalescentIntervalsDelegate.this.intervalNodeMapping.getNodeNumbersForInterval(i);
                    double d6 = d5 = nArray.length > 1 ? NodeHeightToCoalescentIntervalsDelegate.this.tree.getNodeHeight(NodeHeightToCoalescentIntervalsDelegate.this.tree.getNode(nArray[nArray.length - 1])) - NodeHeightToCoalescentIntervalsDelegate.this.tree.getNodeHeight(NodeHeightToCoalescentIntervalsDelegate.this.tree.getNode(nArray[nArray.length - 2])) : Double.POSITIVE_INFINITY;
                    if (d4 > d5) {
                        d4 = d5;
                    }
                    this.lowerBounds[i] = NodeHeightToCoalescentIntervalsDelegate.this.skyrideLikelihood.getCoalescentInterval(i) - d4;
                }
            }
        }

        @Override
        public Double getUpperLimit(int n) {
            this.setupBounds();
            return this.upperBounds[n];
        }

        @Override
        public Double getLowerLimit(int n) {
            this.setupBounds();
            return this.lowerBounds[n];
        }

        @Override
        public int getBoundsDimension() {
            return this.dim;
        }
    }
}

