/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.OrRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class TaxaParser
extends AbstractXMLObjectParser {
    public static final String TAXA = "taxa";
    public static final String EXCLUDE = "exclude";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new OrRule(new ElementRule(Taxa.class, 1, Integer.MAX_VALUE), new ElementRule(Taxon.class, 1, Integer.MAX_VALUE)), new ElementRule("exclude", Taxa.class, "taxa to exclude", 0, Integer.MAX_VALUE)};

    @Override
    public String getParserName() {
        return TAXA;
    }

    @Override
    public String getExample() {
        return "<!-- A list of six taxa -->\n<taxa id=\"greatApes\">\n\t<taxon id=\"human\"/>\n\t<taxon id=\"chimp\"/>\n\t<taxon id=\"bonobo\"/>\n\t<taxon id=\"gorilla\"/>\n\t<taxon id=\"orangutan\"/>\n\t<taxon id=\"siamang\"/>\n</taxa>\n\n<!-- A list of three taxa by references to above taxon objects -->\n<taxa id=\"humanAndChimps\">\n\t<taxon idref=\"human\"/>\n\t<taxon idref=\"chimp\"/>\n\t<taxon idref=\"bonobo\"/>\n</taxa>\n";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Taxa taxa = new Taxa();
        for (Taxon object2 : xMLObject.getAllChildren(Taxon.class)) {
            taxa.addTaxon(object2);
        }
        for (Taxa taxa2 : xMLObject.getAllChildren(Taxa.class)) {
            taxa.addTaxa(taxa2);
        }
        for (XMLObject xMLObject2 : xMLObject.getAllChildren(EXCLUDE)) {
            for (Taxa taxa3 : xMLObject2.getAllChildren(Taxa.class)) {
                taxa.removeTaxa(taxa3);
            }
        }
        Logger logger = Logger.getLogger("dr.evoxml");
        String string = xMLObject.hasId() ? "'" + xMLObject.getId() + "' " : "";
        logger.info("\nTaxon list " + string + "created with " + taxa.getTaxonCount() + " taxa.");
        logger.info("    most recent taxon date = " + Taxon.getMostRecentDate());
        return taxa;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Defines a set of taxon objects.";
    }

    @Override
    public Class getReturnType() {
        return Taxa.class;
    }
}

